@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HostedConnection].
 */
@PulumiTagMarker
public class HostedConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostedConnectionArgs = HostedConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HostedConnectionArgsBuilder.() -> Unit) {
        val builder = HostedConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HostedConnection {
        val builtJavaResource = com.pulumi.aws.directconnect.HostedConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HostedConnection(builtJavaResource)
    }
}

/**
 * Provides a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects. Intended for use by AWS Direct Connect Partners only.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const hosted = new aws.directconnect.HostedConnection("hosted", {
 *     connectionId: "dxcon-ffabc123",
 *     bandwidth: "100Mbps",
 *     name: "tf-dx-hosted-connection",
 *     ownerAccountId: "123456789012",
 *     vlan: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * hosted = aws.directconnect.HostedConnection("hosted",
 *     connection_id="dxcon-ffabc123",
 *     bandwidth="100Mbps",
 *     name="tf-dx-hosted-connection",
 *     owner_account_id="123456789012",
 *     vlan=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hosted = new Aws.DirectConnect.HostedConnection("hosted", new()
 *     {
 *         ConnectionId = "dxcon-ffabc123",
 *         Bandwidth = "100Mbps",
 *         Name = "tf-dx-hosted-connection",
 *         OwnerAccountId = "123456789012",
 *         Vlan = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewHostedConnection(ctx, "hosted", &directconnect.HostedConnectionArgs{
 * 			ConnectionId:   pulumi.String("dxcon-ffabc123"),
 * 			Bandwidth:      pulumi.String("100Mbps"),
 * 			Name:           pulumi.String("tf-dx-hosted-connection"),
 * 			OwnerAccountId: pulumi.String("123456789012"),
 * 			Vlan:           pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.HostedConnection;
 * import com.pulumi.aws.directconnect.HostedConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hosted = new HostedConnection("hosted", HostedConnectionArgs.builder()
 *             .connectionId("dxcon-ffabc123")
 *             .bandwidth("100Mbps")
 *             .name("tf-dx-hosted-connection")
 *             .ownerAccountId("123456789012")
 *             .vlan(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   hosted:
 *     type: aws:directconnect:HostedConnection
 *     properties:
 *       connectionId: dxcon-ffabc123
 *       bandwidth: 100Mbps
 *       name: tf-dx-hosted-connection
 *       ownerAccountId: '123456789012'
 *       vlan: 1
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class HostedConnection internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.HostedConnection,
) : KotlinCustomResource(javaResource, HostedConnectionMapper) {
    /**
     * The Direct Connect endpoint on which the physical connection terminates.
     */
    public val awsDevice: Output<String>
        get() = javaResource.awsDevice().applyValue({ args0 -> args0 })

    /**
     * The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
     */
    public val bandwidth: Output<String>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The ID of the interconnect or LAG.
     */
    public val connectionId: Output<String>
        get() = javaResource.connectionId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
     */
    public val hasLogicalRedundancy: Output<String>
        get() = javaResource.hasLogicalRedundancy().applyValue({ args0 -> args0 })

    /**
     * Boolean value representing if jumbo frames have been enabled for this connection.
     */
    public val jumboFrameCapable: Output<Boolean>
        get() = javaResource.jumboFrameCapable().applyValue({ args0 -> args0 })

    /**
     * The ID of the LAG.
     */
    public val lagId: Output<String>
        get() = javaResource.lagId().applyValue({ args0 -> args0 })

    /**
     * The time of the most recent call to [DescribeLoa](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLoa.html) for this connection.
     */
    public val loaIssueTime: Output<String>
        get() = javaResource.loaIssueTime().applyValue({ args0 -> args0 })

    /**
     * The location of the connection.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the connection.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of the AWS account of the customer for the connection.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * The name of the AWS Direct Connect service provider associated with the connection.
     */
    public val partnerName: Output<String>
        get() = javaResource.partnerName().applyValue({ args0 -> args0 })

    /**
     * The name of the service provider associated with the connection.
     */
    public val providerName: Output<String>
        get() = javaResource.providerName().applyValue({ args0 -> args0 })

    /**
     * The AWS Region where the connection is located.
     */
    public val region: Output<String>
        get() = javaResource.region().applyValue({ args0 -> args0 })

    /**
     * The state of the connection. Possible values include: ordering, requested, pending, available, down, deleting, deleted, rejected, unknown. See [AllocateHostedConnection](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AllocateHostedConnection.html) for a description of each connection state.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The dedicated VLAN provisioned to the hosted connection.
     */
    public val vlan: Output<Int>
        get() = javaResource.vlan().applyValue({ args0 -> args0 })
}

public object HostedConnectionMapper : ResourceMapper<HostedConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.HostedConnection::class == javaResource::class

    override fun map(javaResource: Resource): HostedConnection = HostedConnection(
        javaResource as
            com.pulumi.aws.directconnect.HostedConnection,
    )
}

/**
 * @see [HostedConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HostedConnection].
 */
public suspend fun hostedConnection(
    name: String,
    block: suspend HostedConnectionResourceBuilder.() -> Unit,
): HostedConnection {
    val builder = HostedConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HostedConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hostedConnection(name: String): HostedConnection {
    val builder = HostedConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
