@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.HostedConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects. Intended for use by AWS Direct Connect Partners only.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const hosted = new aws.directconnect.HostedConnection("hosted", {
 *     connectionId: "dxcon-ffabc123",
 *     bandwidth: "100Mbps",
 *     name: "tf-dx-hosted-connection",
 *     ownerAccountId: "123456789012",
 *     vlan: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * hosted = aws.directconnect.HostedConnection("hosted",
 *     connection_id="dxcon-ffabc123",
 *     bandwidth="100Mbps",
 *     name="tf-dx-hosted-connection",
 *     owner_account_id="123456789012",
 *     vlan=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hosted = new Aws.DirectConnect.HostedConnection("hosted", new()
 *     {
 *         ConnectionId = "dxcon-ffabc123",
 *         Bandwidth = "100Mbps",
 *         Name = "tf-dx-hosted-connection",
 *         OwnerAccountId = "123456789012",
 *         Vlan = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewHostedConnection(ctx, "hosted", &directconnect.HostedConnectionArgs{
 * 			ConnectionId:   pulumi.String("dxcon-ffabc123"),
 * 			Bandwidth:      pulumi.String("100Mbps"),
 * 			Name:           pulumi.String("tf-dx-hosted-connection"),
 * 			OwnerAccountId: pulumi.String("123456789012"),
 * 			Vlan:           pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.HostedConnection;
 * import com.pulumi.aws.directconnect.HostedConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hosted = new HostedConnection("hosted", HostedConnectionArgs.builder()
 *             .connectionId("dxcon-ffabc123")
 *             .bandwidth("100Mbps")
 *             .name("tf-dx-hosted-connection")
 *             .ownerAccountId("123456789012")
 *             .vlan(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   hosted:
 *     type: aws:directconnect:HostedConnection
 *     properties:
 *       connectionId: dxcon-ffabc123
 *       bandwidth: 100Mbps
 *       name: tf-dx-hosted-connection
 *       ownerAccountId: '123456789012'
 *       vlan: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * @property bandwidth The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
 * @property connectionId The ID of the interconnect or LAG.
 * @property name The name of the connection.
 * @property ownerAccountId The ID of the AWS account of the customer for the connection.
 * @property vlan The dedicated VLAN provisioned to the hosted connection.
 */
public data class HostedConnectionArgs(
    public val bandwidth: Output<String>? = null,
    public val connectionId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ownerAccountId: Output<String>? = null,
    public val vlan: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.HostedConnectionArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.HostedConnectionArgs =
        com.pulumi.aws.directconnect.HostedConnectionArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ownerAccountId(ownerAccountId?.applyValue({ args0 -> args0 }))
            .vlan(vlan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostedConnectionArgs].
 */
@PulumiTagMarker
public class HostedConnectionArgsBuilder internal constructor() {
    private var bandwidth: Output<String>? = null

    private var connectionId: Output<String>? = null

    private var name: Output<String>? = null

    private var ownerAccountId: Output<String>? = null

    private var vlan: Output<Int>? = null

    /**
     * @param value The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
     */
    @JvmName("vqffkaeussfapabf")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value The ID of the interconnect or LAG.
     */
    @JvmName("qpdytjvkstxtcdmy")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("vjlnanbxsjpiaabr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the AWS account of the customer for the connection.
     */
    @JvmName("qipptwhsxijfqmlt")
    public suspend fun ownerAccountId(`value`: Output<String>) {
        this.ownerAccountId = value
    }

    /**
     * @param value The dedicated VLAN provisioned to the hosted connection.
     */
    @JvmName("yglmutwtjuufwhqt")
    public suspend fun vlan(`value`: Output<Int>) {
        this.vlan = value
    }

    /**
     * @param value The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
     */
    @JvmName("sqdxddjahrjdhwnf")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The ID of the interconnect or LAG.
     */
    @JvmName("bfagkuyfohtrprqv")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("fqjgrmwnjevlfbgn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the AWS account of the customer for the connection.
     */
    @JvmName("ojwflklmwujikscp")
    public suspend fun ownerAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerAccountId = mapped
    }

    /**
     * @param value The dedicated VLAN provisioned to the hosted connection.
     */
    @JvmName("qhrcvxhyslysdokw")
    public suspend fun vlan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlan = mapped
    }

    internal fun build(): HostedConnectionArgs = HostedConnectionArgs(
        bandwidth = bandwidth,
        connectionId = connectionId,
        name = name,
        ownerAccountId = ownerAccountId,
        vlan = vlan,
    )
}
