@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage the accepter's side of a Direct Connect hosted public virtual interface.
 * This resource accepts ownership of a public virtual interface created by another AWS account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const accepter = aws.getCallerIdentity({});
 * // Creator's side of the VIF
 * const creator = new aws.directconnect.HostedPublicVirtualInterface("creator", {
 *     connectionId: "dxcon-zzzzzzzz",
 *     ownerAccountId: accepter.then(accepter => accepter.accountId),
 *     name: "vif-foo",
 *     vlan: 4094,
 *     addressFamily: "ipv4",
 *     bgpAsn: 65352,
 *     customerAddress: "175.45.176.1/30",
 *     amazonAddress: "175.45.176.2/30",
 *     routeFilterPrefixes: [
 *         "210.52.109.0/24",
 *         "175.45.176.0/22",
 *     ],
 * });
 * // Accepter's side of the VIF.
 * const accepterHostedPublicVirtualInterfaceAccepter = new aws.directconnect.HostedPublicVirtualInterfaceAccepter("accepter", {
 *     virtualInterfaceId: creator.id,
 *     tags: {
 *         Side: "Accepter",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * accepter = aws.get_caller_identity()
 * # Creator's side of the VIF
 * creator = aws.directconnect.HostedPublicVirtualInterface("creator",
 *     connection_id="dxcon-zzzzzzzz",
 *     owner_account_id=accepter.account_id,
 *     name="vif-foo",
 *     vlan=4094,
 *     address_family="ipv4",
 *     bgp_asn=65352,
 *     customer_address="175.45.176.1/30",
 *     amazon_address="175.45.176.2/30",
 *     route_filter_prefixes=[
 *         "210.52.109.0/24",
 *         "175.45.176.0/22",
 *     ])
 * # Accepter's side of the VIF.
 * accepter_hosted_public_virtual_interface_accepter = aws.directconnect.HostedPublicVirtualInterfaceAccepter("accepter",
 *     virtual_interface_id=creator.id,
 *     tags={
 *         "Side": "Accepter",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accepter = Aws.GetCallerIdentity.Invoke();
 *     // Creator's side of the VIF
 *     var creator = new Aws.DirectConnect.HostedPublicVirtualInterface("creator", new()
 *     {
 *         ConnectionId = "dxcon-zzzzzzzz",
 *         OwnerAccountId = accepter.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *         Name = "vif-foo",
 *         Vlan = 4094,
 *         AddressFamily = "ipv4",
 *         BgpAsn = 65352,
 *         CustomerAddress = "175.45.176.1/30",
 *         AmazonAddress = "175.45.176.2/30",
 *         RouteFilterPrefixes = new[]
 *         {
 *             "210.52.109.0/24",
 *             "175.45.176.0/22",
 *         },
 *     });
 *     // Accepter's side of the VIF.
 *     var accepterHostedPublicVirtualInterfaceAccepter = new Aws.DirectConnect.HostedPublicVirtualInterfaceAccepter("accepter", new()
 *     {
 *         VirtualInterfaceId = creator.Id,
 *         Tags =
 *         {
 *             { "Side", "Accepter" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		accepter, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Creator's side of the VIF
 * 		creator, err := directconnect.NewHostedPublicVirtualInterface(ctx, "creator", &directconnect.HostedPublicVirtualInterfaceArgs{
 * 			ConnectionId:    pulumi.String("dxcon-zzzzzzzz"),
 * 			OwnerAccountId:  pulumi.String(accepter.AccountId),
 * 			Name:            pulumi.String("vif-foo"),
 * 			Vlan:            pulumi.Int(4094),
 * 			AddressFamily:   pulumi.String("ipv4"),
 * 			BgpAsn:          pulumi.Int(65352),
 * 			CustomerAddress: pulumi.String("175.45.176.1/30"),
 * 			AmazonAddress:   pulumi.String("175.45.176.2/30"),
 * 			RouteFilterPrefixes: pulumi.StringArray{
 * 				pulumi.String("210.52.109.0/24"),
 * 				pulumi.String("175.45.176.0/22"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Accepter's side of the VIF.
 * 		_, err = directconnect.NewHostedPublicVirtualInterfaceAccepter(ctx, "accepter", &directconnect.HostedPublicVirtualInterfaceAccepterArgs{
 * 			VirtualInterfaceId: creator.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Side": pulumi.String("Accepter"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterface;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceArgs;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepter;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var accepter = AwsFunctions.getCallerIdentity();
 *         // Creator's side of the VIF
 *         var creator = new HostedPublicVirtualInterface("creator", HostedPublicVirtualInterfaceArgs.builder()
 *             .connectionId("dxcon-zzzzzzzz")
 *             .ownerAccountId(accepter.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .name("vif-foo")
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .customerAddress("175.45.176.1/30")
 *             .amazonAddress("175.45.176.2/30")
 *             .routeFilterPrefixes(
 *                 "210.52.109.0/24",
 *                 "175.45.176.0/22")
 *             .build());
 *         // Accepter's side of the VIF.
 *         var accepterHostedPublicVirtualInterfaceAccepter = new HostedPublicVirtualInterfaceAccepter("accepterHostedPublicVirtualInterfaceAccepter", HostedPublicVirtualInterfaceAccepterArgs.builder()
 *             .virtualInterfaceId(creator.id())
 *             .tags(Map.of("Side", "Accepter"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Creator's side of the VIF
 *   creator:
 *     type: aws:directconnect:HostedPublicVirtualInterface
 *     properties:
 *       connectionId: dxcon-zzzzzzzz
 *       ownerAccountId: ${accepter.accountId}
 *       name: vif-foo
 *       vlan: 4094
 *       addressFamily: ipv4
 *       bgpAsn: 65352
 *       customerAddress: 175.45.176.1/30
 *       amazonAddress: 175.45.176.2/30
 *       routeFilterPrefixes:
 *         - 210.52.109.0/24
 *         - 175.45.176.0/22
 *   # Accepter's side of the VIF.
 *   accepterHostedPublicVirtualInterfaceAccepter:
 *     type: aws:directconnect:HostedPublicVirtualInterfaceAccepter
 *     name: accepter
 *     properties:
 *       virtualInterfaceId: ${creator.id}
 *       tags:
 *         Side: Accepter
 * variables:
 *   accepter:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Direct Connect hosted public virtual interfaces using the VIF `id`. For example:
 * ```sh
 * $ pulumi import aws:directconnect/hostedPublicVirtualInterfaceAccepter:HostedPublicVirtualInterfaceAccepter test dxvif-33cc44dd
 * ```
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property virtualInterfaceId The ID of the Direct Connect virtual interface to accept.
 */
public data class HostedPublicVirtualInterfaceAccepterArgs(
    public val tags: Output<Map<String, String>>? = null,
    public val virtualInterfaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs =
        com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs.builder()
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualInterfaceId(virtualInterfaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostedPublicVirtualInterfaceAccepterArgs].
 */
@PulumiTagMarker
public class HostedPublicVirtualInterfaceAccepterArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    private var virtualInterfaceId: Output<String>? = null

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dmrxoahlvciwsyjv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the Direct Connect virtual interface to accept.
     */
    @JvmName("wjyatdsybfjoklut")
    public suspend fun virtualInterfaceId(`value`: Output<String>) {
        this.virtualInterfaceId = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dtbbfayrkkfcxrwi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jflsgraxivpokjwd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the Direct Connect virtual interface to accept.
     */
    @JvmName("rfbhahjquyrrygum")
    public suspend fun virtualInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualInterfaceId = mapped
    }

    internal fun build(): HostedPublicVirtualInterfaceAccepterArgs =
        HostedPublicVirtualInterfaceAccepterArgs(
            tags = tags,
            virtualInterfaceId = virtualInterfaceId,
        )
}
