@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HostedTransitVirtualInterface].
 */
@PulumiTagMarker
public class HostedTransitVirtualInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostedTransitVirtualInterfaceArgs = HostedTransitVirtualInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HostedTransitVirtualInterfaceArgsBuilder.() -> Unit) {
        val builder = HostedTransitVirtualInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HostedTransitVirtualInterface {
        val builtJavaResource =
            com.pulumi.aws.directconnect.HostedTransitVirtualInterface(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HostedTransitVirtualInterface(builtJavaResource)
    }
}

/**
 * Provides a Direct Connect hosted transit virtual interface resource.
 * This resource represents the allocator's side of the hosted virtual interface.
 * A hosted virtual interface is a virtual interface that is owned by another AWS account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directconnect.HostedTransitVirtualInterface("example", {
 *     connectionId: exampleAwsDxConnection.id,
 *     name: "tf-transit-vif-example",
 *     vlan: 4094,
 *     addressFamily: "ipv4",
 *     bgpAsn: 65352,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directconnect.HostedTransitVirtualInterface("example",
 *     connection_id=example_aws_dx_connection["id"],
 *     name="tf-transit-vif-example",
 *     vlan=4094,
 *     address_family="ipv4",
 *     bgp_asn=65352)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectConnect.HostedTransitVirtualInterface("example", new()
 *     {
 *         ConnectionId = exampleAwsDxConnection.Id,
 *         Name = "tf-transit-vif-example",
 *         Vlan = 4094,
 *         AddressFamily = "ipv4",
 *         BgpAsn = 65352,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewHostedTransitVirtualInterface(ctx, "example", &directconnect.HostedTransitVirtualInterfaceArgs{
 * 			ConnectionId:  pulumi.Any(exampleAwsDxConnection.Id),
 * 			Name:          pulumi.String("tf-transit-vif-example"),
 * 			Vlan:          pulumi.Int(4094),
 * 			AddressFamily: pulumi.String("ipv4"),
 * 			BgpAsn:        pulumi.Int(65352),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.HostedTransitVirtualInterface;
 * import com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HostedTransitVirtualInterface("example", HostedTransitVirtualInterfaceArgs.builder()
 *             .connectionId(exampleAwsDxConnection.id())
 *             .name("tf-transit-vif-example")
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directconnect:HostedTransitVirtualInterface
 *     properties:
 *       connectionId: ${exampleAwsDxConnection.id}
 *       name: tf-transit-vif-example
 *       vlan: 4094
 *       addressFamily: ipv4
 *       bgpAsn: 65352
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Direct Connect hosted transit virtual interfaces using the VIF `id`. For example:
 * ```sh
 * $ pulumi import aws:directconnect/hostedTransitVirtualInterface:HostedTransitVirtualInterface test dxvif-33cc44dd
 * ```
 */
public class HostedTransitVirtualInterface internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.HostedTransitVirtualInterface,
) : KotlinCustomResource(javaResource, HostedTransitVirtualInterfaceMapper) {
    /**
     * The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    public val addressFamily: Output<String>
        get() = javaResource.addressFamily().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    public val amazonAddress: Output<String>
        get() = javaResource.amazonAddress().applyValue({ args0 -> args0 })

    public val amazonSideAsn: Output<String>
        get() = javaResource.amazonSideAsn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the virtual interface.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Direct Connect endpoint on which the virtual interface terminates.
     */
    public val awsDevice: Output<String>
        get() = javaResource.awsDevice().applyValue({ args0 -> args0 })

    /**
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    public val bgpAsn: Output<Int>
        get() = javaResource.bgpAsn().applyValue({ args0 -> args0 })

    /**
     * The authentication key for BGP configuration.
     */
    public val bgpAuthKey: Output<String>
        get() = javaResource.bgpAuthKey().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    public val connectionId: Output<String>
        get() = javaResource.connectionId().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    public val customerAddress: Output<String>
        get() = javaResource.customerAddress().applyValue({ args0 -> args0 })

    /**
     * Indicates whether jumbo frames (8500 MTU) are supported.
     */
    public val jumboFrameCapable: Output<Boolean>
        get() = javaResource.jumboFrameCapable().applyValue({ args0 -> args0 })

    /**
     * The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection. The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
     */
    public val mtu: Output<Int>?
        get() = javaResource.mtu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name for the virtual interface.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The AWS account that will own the new virtual interface.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * The VLAN ID.
     */
    public val vlan: Output<Int>
        get() = javaResource.vlan().applyValue({ args0 -> args0 })
}

public object HostedTransitVirtualInterfaceMapper : ResourceMapper<HostedTransitVirtualInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.HostedTransitVirtualInterface::class == javaResource::class

    override fun map(javaResource: Resource): HostedTransitVirtualInterface =
        HostedTransitVirtualInterface(
            javaResource as
                com.pulumi.aws.directconnect.HostedTransitVirtualInterface,
        )
}

/**
 * @see [HostedTransitVirtualInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HostedTransitVirtualInterface].
 */
public suspend fun hostedTransitVirtualInterface(
    name: String,
    block: suspend HostedTransitVirtualInterfaceResourceBuilder.() -> Unit,
): HostedTransitVirtualInterface {
    val builder = HostedTransitVirtualInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HostedTransitVirtualInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hostedTransitVirtualInterface(name: String): HostedTransitVirtualInterface {
    val builder = HostedTransitVirtualInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
