@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Direct Connect hosted transit virtual interface resource.
 * This resource represents the allocator's side of the hosted virtual interface.
 * A hosted virtual interface is a virtual interface that is owned by another AWS account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directconnect.HostedTransitVirtualInterface("example", {
 *     connectionId: exampleAwsDxConnection.id,
 *     name: "tf-transit-vif-example",
 *     vlan: 4094,
 *     addressFamily: "ipv4",
 *     bgpAsn: 65352,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directconnect.HostedTransitVirtualInterface("example",
 *     connection_id=example_aws_dx_connection["id"],
 *     name="tf-transit-vif-example",
 *     vlan=4094,
 *     address_family="ipv4",
 *     bgp_asn=65352)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectConnect.HostedTransitVirtualInterface("example", new()
 *     {
 *         ConnectionId = exampleAwsDxConnection.Id,
 *         Name = "tf-transit-vif-example",
 *         Vlan = 4094,
 *         AddressFamily = "ipv4",
 *         BgpAsn = 65352,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewHostedTransitVirtualInterface(ctx, "example", &directconnect.HostedTransitVirtualInterfaceArgs{
 * 			ConnectionId:  pulumi.Any(exampleAwsDxConnection.Id),
 * 			Name:          pulumi.String("tf-transit-vif-example"),
 * 			Vlan:          pulumi.Int(4094),
 * 			AddressFamily: pulumi.String("ipv4"),
 * 			BgpAsn:        pulumi.Int(65352),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.HostedTransitVirtualInterface;
 * import com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HostedTransitVirtualInterface("example", HostedTransitVirtualInterfaceArgs.builder()
 *             .connectionId(exampleAwsDxConnection.id())
 *             .name("tf-transit-vif-example")
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directconnect:HostedTransitVirtualInterface
 *     properties:
 *       connectionId: ${exampleAwsDxConnection.id}
 *       name: tf-transit-vif-example
 *       vlan: 4094
 *       addressFamily: ipv4
 *       bgpAsn: 65352
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Direct Connect hosted transit virtual interfaces using the VIF `id`. For example:
 * ```sh
 * $ pulumi import aws:directconnect/hostedTransitVirtualInterface:HostedTransitVirtualInterface test dxvif-33cc44dd
 * ```
 * @property addressFamily The address family for the BGP peer. `ipv4 ` or `ipv6`.
 * @property amazonAddress The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
 * @property bgpAsn The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
 * @property bgpAuthKey The authentication key for BGP configuration.
 * @property connectionId The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
 * @property customerAddress The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
 * @property mtu The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection. The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
 * @property name The name for the virtual interface.
 * @property ownerAccountId The AWS account that will own the new virtual interface.
 * @property vlan The VLAN ID.
 */
public data class HostedTransitVirtualInterfaceArgs(
    public val addressFamily: Output<String>? = null,
    public val amazonAddress: Output<String>? = null,
    public val bgpAsn: Output<Int>? = null,
    public val bgpAuthKey: Output<String>? = null,
    public val connectionId: Output<String>? = null,
    public val customerAddress: Output<String>? = null,
    public val mtu: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val ownerAccountId: Output<String>? = null,
    public val vlan: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceArgs =
        com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceArgs.builder()
            .addressFamily(addressFamily?.applyValue({ args0 -> args0 }))
            .amazonAddress(amazonAddress?.applyValue({ args0 -> args0 }))
            .bgpAsn(bgpAsn?.applyValue({ args0 -> args0 }))
            .bgpAuthKey(bgpAuthKey?.applyValue({ args0 -> args0 }))
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .customerAddress(customerAddress?.applyValue({ args0 -> args0 }))
            .mtu(mtu?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ownerAccountId(ownerAccountId?.applyValue({ args0 -> args0 }))
            .vlan(vlan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostedTransitVirtualInterfaceArgs].
 */
@PulumiTagMarker
public class HostedTransitVirtualInterfaceArgsBuilder internal constructor() {
    private var addressFamily: Output<String>? = null

    private var amazonAddress: Output<String>? = null

    private var bgpAsn: Output<Int>? = null

    private var bgpAuthKey: Output<String>? = null

    private var connectionId: Output<String>? = null

    private var customerAddress: Output<String>? = null

    private var mtu: Output<Int>? = null

    private var name: Output<String>? = null

    private var ownerAccountId: Output<String>? = null

    private var vlan: Output<Int>? = null

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("ppbnuwcdjwwjjrbx")
    public suspend fun addressFamily(`value`: Output<String>) {
        this.addressFamily = value
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    @JvmName("dsxxylwsaloycyaa")
    public suspend fun amazonAddress(`value`: Output<String>) {
        this.amazonAddress = value
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("ypvpgjmunofobghe")
    public suspend fun bgpAsn(`value`: Output<Int>) {
        this.bgpAsn = value
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("fmqesypcxyrgdeme")
    public suspend fun bgpAuthKey(`value`: Output<String>) {
        this.bgpAuthKey = value
    }

    /**
     * @param value The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    @JvmName("ixhooxqxeirawdbo")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    @JvmName("pynwpiuwppcjttuj")
    public suspend fun customerAddress(`value`: Output<String>) {
        this.customerAddress = value
    }

    /**
     * @param value The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection. The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
     */
    @JvmName("eybcoefimjydlnke")
    public suspend fun mtu(`value`: Output<Int>) {
        this.mtu = value
    }

    /**
     * @param value The name for the virtual interface.
     */
    @JvmName("wtukrhyxtolcrgdj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The AWS account that will own the new virtual interface.
     */
    @JvmName("mwllghdqxaocfutc")
    public suspend fun ownerAccountId(`value`: Output<String>) {
        this.ownerAccountId = value
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("djrcsktksmqrxlsj")
    public suspend fun vlan(`value`: Output<Int>) {
        this.vlan = value
    }

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("enimjgxsxvlqtcrk")
    public suspend fun addressFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    @JvmName("suqikaxnhxrhkwxw")
    public suspend fun amazonAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonAddress = mapped
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("xwrqxaukiocospkd")
    public suspend fun bgpAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAsn = mapped
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("bdnmckqlbumidwym")
    public suspend fun bgpAuthKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAuthKey = mapped
    }

    /**
     * @param value The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    @JvmName("emwjbpeeesojibqd")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    @JvmName("yjmpvqywialjojlp")
    public suspend fun customerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerAddress = mapped
    }

    /**
     * @param value The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection. The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
     */
    @JvmName("porgcpktfeqbugjk")
    public suspend fun mtu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mtu = mapped
    }

    /**
     * @param value The name for the virtual interface.
     */
    @JvmName("ujvotrvqmewhhicb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The AWS account that will own the new virtual interface.
     */
    @JvmName("lmgvyxiymotluhuu")
    public suspend fun ownerAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerAccountId = mapped
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("ppwjatcfopiabapc")
    public suspend fun vlan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlan = mapped
    }

    internal fun build(): HostedTransitVirtualInterfaceArgs = HostedTransitVirtualInterfaceArgs(
        addressFamily = addressFamily,
        amazonAddress = amazonAddress,
        bgpAsn = bgpAsn,
        bgpAuthKey = bgpAuthKey,
        connectionId = connectionId,
        customerAddress = customerAddress,
        mtu = mtu,
        name = name,
        ownerAccountId = ownerAccountId,
        vlan = vlan,
    )
}
