@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MacsecKeyAssociation].
 */
@PulumiTagMarker
public class MacsecKeyAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MacsecKeyAssociationArgs = MacsecKeyAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MacsecKeyAssociationArgsBuilder.() -> Unit) {
        val builder = MacsecKeyAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MacsecKeyAssociation {
        val builtJavaResource =
            com.pulumi.aws.directconnect.MacsecKeyAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MacsecKeyAssociation(builtJavaResource)
    }
}

/**
 * Provides a MAC Security (MACSec) secret key resource for use with Direct Connect. See [MACsec prerequisites](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) for information about MAC Security (MACsec) prerequisites.
 * Creating this resource will also create a resource of type `aws.secretsmanager.Secret` which is managed by Direct Connect. While you can import this resource into your state, because this secret is managed by Direct Connect, you will not be able to make any modifications to it. See [How AWS Direct Connect uses AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/integrating_how-services-use-secrets_directconnect.html) for details.
 * > **Note:** All arguments including `ckn` and `cak` will be stored in the raw state as plain-text.
 * > **Note:** The `secret_arn` argument can only be used to reference a previously created MACSec key. You cannot associate a Secrets Manager secret created outside of the `aws.directconnect.MacsecKeyAssociation` resource.
 * ## Example Usage
 * ### Create MACSec key with CKN and CAK
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.directconnect.getConnection({
 *     name: "tf-dx-connection",
 * });
 * const test = new aws.directconnect.MacsecKeyAssociation("test", {
 *     connectionId: example.then(example => example.id),
 *     ckn: "0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef",
 *     cak: "abcdef0123456789abcdef0123456789abcdef0123456789abcdef0123456789",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directconnect.get_connection(name="tf-dx-connection")
 * test = aws.directconnect.MacsecKeyAssociation("test",
 *     connection_id=example.id,
 *     ckn="0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef",
 *     cak="abcdef0123456789abcdef0123456789abcdef0123456789abcdef0123456789")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.DirectConnect.GetConnection.Invoke(new()
 *     {
 *         Name = "tf-dx-connection",
 *     });
 *     var test = new Aws.DirectConnect.MacsecKeyAssociation("test", new()
 *     {
 *         ConnectionId = example.Apply(getConnectionResult => getConnectionResult.Id),
 *         Ckn = "0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef",
 *         Cak = "abcdef0123456789abcdef0123456789abcdef0123456789abcdef0123456789",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := directconnect.LookupConnection(ctx, &directconnect.LookupConnectionArgs{
 * 			Name: "tf-dx-connection",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directconnect.NewMacsecKeyAssociation(ctx, "test", &directconnect.MacsecKeyAssociationArgs{
 * 			ConnectionId: pulumi.String(example.Id),
 * 			Ckn:          pulumi.String("0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef"),
 * 			Cak:          pulumi.String("abcdef0123456789abcdef0123456789abcdef0123456789abcdef0123456789"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.DirectconnectFunctions;
 * import com.pulumi.aws.directconnect.inputs.GetConnectionArgs;
 * import com.pulumi.aws.directconnect.MacsecKeyAssociation;
 * import com.pulumi.aws.directconnect.MacsecKeyAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = DirectconnectFunctions.getConnection(GetConnectionArgs.builder()
 *             .name("tf-dx-connection")
 *             .build());
 *         var test = new MacsecKeyAssociation("test", MacsecKeyAssociationArgs.builder()
 *             .connectionId(example.applyValue(getConnectionResult -> getConnectionResult.id()))
 *             .ckn("0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef")
 *             .cak("abcdef0123456789abcdef0123456789abcdef0123456789abcdef0123456789")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:directconnect:MacsecKeyAssociation
 *     properties:
 *       connectionId: ${example.id}
 *       ckn: 0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef
 *       cak: abcdef0123456789abcdef0123456789abcdef0123456789abcdef0123456789
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:directconnect:getConnection
 *       Arguments:
 *         name: tf-dx-connection
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create MACSec key with existing Secrets Manager secret
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.directconnect.getConnection({
 *     name: "tf-dx-connection",
 * });
 * const exampleGetSecret = aws.secretsmanager.getSecret({
 *     name: "directconnect!prod/us-east-1/directconnect/0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef",
 * });
 * const test = new aws.directconnect.MacsecKeyAssociation("test", {
 *     connectionId: example.then(example => example.id),
 *     secretArn: exampleGetSecret.then(exampleGetSecret => exampleGetSecret.arn),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directconnect.get_connection(name="tf-dx-connection")
 * example_get_secret = aws.secretsmanager.get_secret(name="directconnect!prod/us-east-1/directconnect/0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef")
 * test = aws.directconnect.MacsecKeyAssociation("test",
 *     connection_id=example.id,
 *     secret_arn=example_get_secret.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.DirectConnect.GetConnection.Invoke(new()
 *     {
 *         Name = "tf-dx-connection",
 *     });
 *     var exampleGetSecret = Aws.SecretsManager.GetSecret.Invoke(new()
 *     {
 *         Name = "directconnect!prod/us-east-1/directconnect/0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef",
 *     });
 *     var test = new Aws.DirectConnect.MacsecKeyAssociation("test", new()
 *     {
 *         ConnectionId = example.Apply(getConnectionResult => getConnectionResult.Id),
 *         SecretArn = exampleGetSecret.Apply(getSecretResult => getSecretResult.Arn),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := directconnect.LookupConnection(ctx, &directconnect.LookupConnectionArgs{
 * 			Name: "tf-dx-connection",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetSecret, err := secretsmanager.LookupSecret(ctx, &secretsmanager.LookupSecretArgs{
 * 			Name: pulumi.StringRef("directconnect!prod/us-east-1/directconnect/0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directconnect.NewMacsecKeyAssociation(ctx, "test", &directconnect.MacsecKeyAssociationArgs{
 * 			ConnectionId: pulumi.String(example.Id),
 * 			SecretArn:    pulumi.String(exampleGetSecret.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.DirectconnectFunctions;
 * import com.pulumi.aws.directconnect.inputs.GetConnectionArgs;
 * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
 * import com.pulumi.aws.secretsmanager.inputs.GetSecretArgs;
 * import com.pulumi.aws.directconnect.MacsecKeyAssociation;
 * import com.pulumi.aws.directconnect.MacsecKeyAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = DirectconnectFunctions.getConnection(GetConnectionArgs.builder()
 *             .name("tf-dx-connection")
 *             .build());
 *         final var exampleGetSecret = SecretsmanagerFunctions.getSecret(GetSecretArgs.builder()
 *             .name("directconnect!prod/us-east-1/directconnect/0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef")
 *             .build());
 *         var test = new MacsecKeyAssociation("test", MacsecKeyAssociationArgs.builder()
 *             .connectionId(example.applyValue(getConnectionResult -> getConnectionResult.id()))
 *             .secretArn(exampleGetSecret.applyValue(getSecretResult -> getSecretResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:directconnect:MacsecKeyAssociation
 *     properties:
 *       connectionId: ${example.id}
 *       secretArn: ${exampleGetSecret.arn}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:directconnect:getConnection
 *       Arguments:
 *         name: tf-dx-connection
 *   exampleGetSecret:
 *     fn::invoke:
 *       Function: aws:secretsmanager:getSecret
 *       Arguments:
 *         name: directconnect!prod/us-east-1/directconnect/0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class MacsecKeyAssociation internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.MacsecKeyAssociation,
) : KotlinCustomResource(javaResource, MacsecKeyAssociationMapper) {
    /**
     * The MAC Security (MACsec) CAK to associate with the dedicated connection. The valid values are 64 hexadecimal characters (0-9, A-E). Required if using `ckn`.
     */
    public val cak: Output<String>?
        get() = javaResource.cak().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The MAC Security (MACsec) CKN to associate with the dedicated connection. The valid values are 64 hexadecimal characters (0-9, A-E). Required if using `cak`.
     */
    public val ckn: Output<String>
        get() = javaResource.ckn().applyValue({ args0 -> args0 })

    /**
     * The ID of the dedicated Direct Connect connection. The connection must be a dedicated connection in the `AVAILABLE` state.
     */
    public val connectionId: Output<String>
        get() = javaResource.connectionId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.
     * > **Note:** `ckn` and `cak` are mutually exclusive with `secret_arn` - these arguments cannot be used together. If you use `ckn` and `cak`, you should not use `secret_arn`. If you use the `secret_arn` argument to reference an existing MAC Security (MACSec) secret key, you should not use `ckn` or `cak`.
     */
    public val secretArn: Output<String>
        get() = javaResource.secretArn().applyValue({ args0 -> args0 })

    /**
     * The date in UTC format that the MAC Security (MACsec) secret key takes effect.
     */
    public val startOn: Output<String>
        get() = javaResource.startOn().applyValue({ args0 -> args0 })

    /**
     * The state of the MAC Security (MACsec) secret key. The possible values are: associating, associated, disassociating, disassociated. See [MacSecKey](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_MacSecKey.html#DX-Type-MacSecKey-state) for descriptions of each state.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })
}

public object MacsecKeyAssociationMapper : ResourceMapper<MacsecKeyAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.MacsecKeyAssociation::class == javaResource::class

    override fun map(javaResource: Resource): MacsecKeyAssociation = MacsecKeyAssociation(
        javaResource
            as com.pulumi.aws.directconnect.MacsecKeyAssociation,
    )
}

/**
 * @see [MacsecKeyAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MacsecKeyAssociation].
 */
public suspend fun macsecKeyAssociation(
    name: String,
    block: suspend MacsecKeyAssociationResourceBuilder.() -> Unit,
): MacsecKeyAssociation {
    val builder = MacsecKeyAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MacsecKeyAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun macsecKeyAssociation(name: String): MacsecKeyAssociation {
    val builder = MacsecKeyAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
