@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.PrivateVirtualInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Direct Connect private virtual interface resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.directconnect.PrivateVirtualInterface("foo", {
 *     connectionId: "dxcon-zzzzzzzz",
 *     name: "vif-foo",
 *     vlan: 4094,
 *     addressFamily: "ipv4",
 *     bgpAsn: 65352,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.directconnect.PrivateVirtualInterface("foo",
 *     connection_id="dxcon-zzzzzzzz",
 *     name="vif-foo",
 *     vlan=4094,
 *     address_family="ipv4",
 *     bgp_asn=65352)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.DirectConnect.PrivateVirtualInterface("foo", new()
 *     {
 *         ConnectionId = "dxcon-zzzzzzzz",
 *         Name = "vif-foo",
 *         Vlan = 4094,
 *         AddressFamily = "ipv4",
 *         BgpAsn = 65352,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewPrivateVirtualInterface(ctx, "foo", &directconnect.PrivateVirtualInterfaceArgs{
 * 			ConnectionId:  pulumi.String("dxcon-zzzzzzzz"),
 * 			Name:          pulumi.String("vif-foo"),
 * 			Vlan:          pulumi.Int(4094),
 * 			AddressFamily: pulumi.String("ipv4"),
 * 			BgpAsn:        pulumi.Int(65352),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.PrivateVirtualInterface;
 * import com.pulumi.aws.directconnect.PrivateVirtualInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new PrivateVirtualInterface("foo", PrivateVirtualInterfaceArgs.builder()
 *             .connectionId("dxcon-zzzzzzzz")
 *             .name("vif-foo")
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:directconnect:PrivateVirtualInterface
 *     properties:
 *       connectionId: dxcon-zzzzzzzz
 *       name: vif-foo
 *       vlan: 4094
 *       addressFamily: ipv4
 *       bgpAsn: 65352
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Direct Connect private virtual interfaces using the VIF `id`. For example:
 * ```sh
 * $ pulumi import aws:directconnect/privateVirtualInterface:PrivateVirtualInterface test dxvif-33cc44dd
 * ```
 * @property addressFamily The address family for the BGP peer. `ipv4 ` or `ipv6`.
 * @property amazonAddress The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
 * @property bgpAsn The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
 * @property bgpAuthKey The authentication key for BGP configuration.
 * @property connectionId The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
 * @property customerAddress The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
 * @property dxGatewayId The ID of the Direct Connect gateway to which to connect the virtual interface.
 * @property mtu The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection.
 * The MTU of a virtual private interface can be either `1500` or `9001` (jumbo frames). Default is `1500`.
 * @property name The name for the virtual interface.
 * @property sitelinkEnabled Indicates whether to enable or disable SiteLink.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vlan The VLAN ID.
 * @property vpnGatewayId The ID of the virtual private gateway to which to connect the virtual interface.
 */
public data class PrivateVirtualInterfaceArgs(
    public val addressFamily: Output<String>? = null,
    public val amazonAddress: Output<String>? = null,
    public val bgpAsn: Output<Int>? = null,
    public val bgpAuthKey: Output<String>? = null,
    public val connectionId: Output<String>? = null,
    public val customerAddress: Output<String>? = null,
    public val dxGatewayId: Output<String>? = null,
    public val mtu: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val sitelinkEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vlan: Output<Int>? = null,
    public val vpnGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.PrivateVirtualInterfaceArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.PrivateVirtualInterfaceArgs =
        com.pulumi.aws.directconnect.PrivateVirtualInterfaceArgs.builder()
            .addressFamily(addressFamily?.applyValue({ args0 -> args0 }))
            .amazonAddress(amazonAddress?.applyValue({ args0 -> args0 }))
            .bgpAsn(bgpAsn?.applyValue({ args0 -> args0 }))
            .bgpAuthKey(bgpAuthKey?.applyValue({ args0 -> args0 }))
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .customerAddress(customerAddress?.applyValue({ args0 -> args0 }))
            .dxGatewayId(dxGatewayId?.applyValue({ args0 -> args0 }))
            .mtu(mtu?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sitelinkEnabled(sitelinkEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vlan(vlan?.applyValue({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateVirtualInterfaceArgs].
 */
@PulumiTagMarker
public class PrivateVirtualInterfaceArgsBuilder internal constructor() {
    private var addressFamily: Output<String>? = null

    private var amazonAddress: Output<String>? = null

    private var bgpAsn: Output<Int>? = null

    private var bgpAuthKey: Output<String>? = null

    private var connectionId: Output<String>? = null

    private var customerAddress: Output<String>? = null

    private var dxGatewayId: Output<String>? = null

    private var mtu: Output<Int>? = null

    private var name: Output<String>? = null

    private var sitelinkEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vlan: Output<Int>? = null

    private var vpnGatewayId: Output<String>? = null

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("uqtsbcddydvgiwjf")
    public suspend fun addressFamily(`value`: Output<String>) {
        this.addressFamily = value
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    @JvmName("mgktlxxucqfnkttq")
    public suspend fun amazonAddress(`value`: Output<String>) {
        this.amazonAddress = value
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("fplkekuomqmenybl")
    public suspend fun bgpAsn(`value`: Output<Int>) {
        this.bgpAsn = value
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("jyhcddrcpoolpbcu")
    public suspend fun bgpAuthKey(`value`: Output<String>) {
        this.bgpAuthKey = value
    }

    /**
     * @param value The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    @JvmName("rrdctlhbypusrqfc")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    @JvmName("onfxojsmkkulwckf")
    public suspend fun customerAddress(`value`: Output<String>) {
        this.customerAddress = value
    }

    /**
     * @param value The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    @JvmName("hahlalmgkbolcoex")
    public suspend fun dxGatewayId(`value`: Output<String>) {
        this.dxGatewayId = value
    }

    /**
     * @param value The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection.
     * The MTU of a virtual private interface can be either `1500` or `9001` (jumbo frames). Default is `1500`.
     */
    @JvmName("rruaqrxvrjcidgkt")
    public suspend fun mtu(`value`: Output<Int>) {
        this.mtu = value
    }

    /**
     * @param value The name for the virtual interface.
     */
    @JvmName("ddwhpecwkrflqhas")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether to enable or disable SiteLink.
     */
    @JvmName("ycgsntshvnbdaxrw")
    public suspend fun sitelinkEnabled(`value`: Output<Boolean>) {
        this.sitelinkEnabled = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tscjieheukuyrkcl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("dljokijetqviusgk")
    public suspend fun vlan(`value`: Output<Int>) {
        this.vlan = value
    }

    /**
     * @param value The ID of the virtual private gateway to which to connect the virtual interface.
     */
    @JvmName("npwbsrpgtxtucbmd")
    public suspend fun vpnGatewayId(`value`: Output<String>) {
        this.vpnGatewayId = value
    }

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("mjladtifihtsvxjh")
    public suspend fun addressFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    @JvmName("jddohfbtdrpllgwc")
    public suspend fun amazonAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonAddress = mapped
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("vseffgtiwcaxuffj")
    public suspend fun bgpAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAsn = mapped
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("vsnggfwlwbmjtsrb")
    public suspend fun bgpAuthKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAuthKey = mapped
    }

    /**
     * @param value The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    @JvmName("bvknijrerdbvbuip")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    @JvmName("wgvbmrcctjkmqpeq")
    public suspend fun customerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerAddress = mapped
    }

    /**
     * @param value The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    @JvmName("ajxyvucwjwrclsfy")
    public suspend fun dxGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dxGatewayId = mapped
    }

    /**
     * @param value The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection.
     * The MTU of a virtual private interface can be either `1500` or `9001` (jumbo frames). Default is `1500`.
     */
    @JvmName("phwiamcriqvfbhct")
    public suspend fun mtu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mtu = mapped
    }

    /**
     * @param value The name for the virtual interface.
     */
    @JvmName("nopigjpfqbwiwvnh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether to enable or disable SiteLink.
     */
    @JvmName("tqmnvyrbrvliedmp")
    public suspend fun sitelinkEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sitelinkEnabled = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qupnatyxwunqjykf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qcfaepmhnsraqjxh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("qgfopuaprpirfrhp")
    public suspend fun vlan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlan = mapped
    }

    /**
     * @param value The ID of the virtual private gateway to which to connect the virtual interface.
     */
    @JvmName("dfqujhdbiogbapbh")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayId = mapped
    }

    internal fun build(): PrivateVirtualInterfaceArgs = PrivateVirtualInterfaceArgs(
        addressFamily = addressFamily,
        amazonAddress = amazonAddress,
        bgpAsn = bgpAsn,
        bgpAuthKey = bgpAuthKey,
        connectionId = connectionId,
        customerAddress = customerAddress,
        dxGatewayId = dxGatewayId,
        mtu = mtu,
        name = name,
        sitelinkEnabled = sitelinkEnabled,
        tags = tags,
        vlan = vlan,
        vpnGatewayId = vpnGatewayId,
    )
}
