@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [PublicVirtualInterface].
 */
@PulumiTagMarker
public class PublicVirtualInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PublicVirtualInterfaceArgs = PublicVirtualInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PublicVirtualInterfaceArgsBuilder.() -> Unit) {
        val builder = PublicVirtualInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PublicVirtualInterface {
        val builtJavaResource =
            com.pulumi.aws.directconnect.PublicVirtualInterface(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PublicVirtualInterface(builtJavaResource)
    }
}

/**
 * Provides a Direct Connect public virtual interface resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.directconnect.PublicVirtualInterface("foo", {
 *     connectionId: "dxcon-zzzzzzzz",
 *     name: "vif-foo",
 *     vlan: 4094,
 *     addressFamily: "ipv4",
 *     bgpAsn: 65352,
 *     customerAddress: "175.45.176.1/30",
 *     amazonAddress: "175.45.176.2/30",
 *     routeFilterPrefixes: [
 *         "210.52.109.0/24",
 *         "175.45.176.0/22",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.directconnect.PublicVirtualInterface("foo",
 *     connection_id="dxcon-zzzzzzzz",
 *     name="vif-foo",
 *     vlan=4094,
 *     address_family="ipv4",
 *     bgp_asn=65352,
 *     customer_address="175.45.176.1/30",
 *     amazon_address="175.45.176.2/30",
 *     route_filter_prefixes=[
 *         "210.52.109.0/24",
 *         "175.45.176.0/22",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.DirectConnect.PublicVirtualInterface("foo", new()
 *     {
 *         ConnectionId = "dxcon-zzzzzzzz",
 *         Name = "vif-foo",
 *         Vlan = 4094,
 *         AddressFamily = "ipv4",
 *         BgpAsn = 65352,
 *         CustomerAddress = "175.45.176.1/30",
 *         AmazonAddress = "175.45.176.2/30",
 *         RouteFilterPrefixes = new[]
 *         {
 *             "210.52.109.0/24",
 *             "175.45.176.0/22",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewPublicVirtualInterface(ctx, "foo", &directconnect.PublicVirtualInterfaceArgs{
 * 			ConnectionId:    pulumi.String("dxcon-zzzzzzzz"),
 * 			Name:            pulumi.String("vif-foo"),
 * 			Vlan:            pulumi.Int(4094),
 * 			AddressFamily:   pulumi.String("ipv4"),
 * 			BgpAsn:          pulumi.Int(65352),
 * 			CustomerAddress: pulumi.String("175.45.176.1/30"),
 * 			AmazonAddress:   pulumi.String("175.45.176.2/30"),
 * 			RouteFilterPrefixes: pulumi.StringArray{
 * 				pulumi.String("210.52.109.0/24"),
 * 				pulumi.String("175.45.176.0/22"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.PublicVirtualInterface;
 * import com.pulumi.aws.directconnect.PublicVirtualInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new PublicVirtualInterface("foo", PublicVirtualInterfaceArgs.builder()
 *             .connectionId("dxcon-zzzzzzzz")
 *             .name("vif-foo")
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .customerAddress("175.45.176.1/30")
 *             .amazonAddress("175.45.176.2/30")
 *             .routeFilterPrefixes(
 *                 "210.52.109.0/24",
 *                 "175.45.176.0/22")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:directconnect:PublicVirtualInterface
 *     properties:
 *       connectionId: dxcon-zzzzzzzz
 *       name: vif-foo
 *       vlan: 4094
 *       addressFamily: ipv4
 *       bgpAsn: 65352
 *       customerAddress: 175.45.176.1/30
 *       amazonAddress: 175.45.176.2/30
 *       routeFilterPrefixes:
 *         - 210.52.109.0/24
 *         - 175.45.176.0/22
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Direct Connect public virtual interfaces using the VIF `id`. For example:
 * ```sh
 * $ pulumi import aws:directconnect/publicVirtualInterface:PublicVirtualInterface test dxvif-33cc44dd
 * ```
 */
public class PublicVirtualInterface internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.PublicVirtualInterface,
) : KotlinCustomResource(javaResource, PublicVirtualInterfaceMapper) {
    /**
     * The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    public val addressFamily: Output<String>
        get() = javaResource.addressFamily().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    public val amazonAddress: Output<String>
        get() = javaResource.amazonAddress().applyValue({ args0 -> args0 })

    public val amazonSideAsn: Output<String>
        get() = javaResource.amazonSideAsn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the virtual interface.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Direct Connect endpoint on which the virtual interface terminates.
     */
    public val awsDevice: Output<String>
        get() = javaResource.awsDevice().applyValue({ args0 -> args0 })

    /**
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    public val bgpAsn: Output<Int>
        get() = javaResource.bgpAsn().applyValue({ args0 -> args0 })

    /**
     * The authentication key for BGP configuration.
     */
    public val bgpAuthKey: Output<String>
        get() = javaResource.bgpAuthKey().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    public val connectionId: Output<String>
        get() = javaResource.connectionId().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    public val customerAddress: Output<String>
        get() = javaResource.customerAddress().applyValue({ args0 -> args0 })

    /**
     * The name for the virtual interface.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of routes to be advertised to the AWS network in this region.
     */
    public val routeFilterPrefixes: Output<List<String>>
        get() = javaResource.routeFilterPrefixes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VLAN ID.
     */
    public val vlan: Output<Int>
        get() = javaResource.vlan().applyValue({ args0 -> args0 })
}

public object PublicVirtualInterfaceMapper : ResourceMapper<PublicVirtualInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.PublicVirtualInterface::class == javaResource::class

    override fun map(javaResource: Resource): PublicVirtualInterface =
        PublicVirtualInterface(javaResource as com.pulumi.aws.directconnect.PublicVirtualInterface)
}

/**
 * @see [PublicVirtualInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PublicVirtualInterface].
 */
public suspend fun publicVirtualInterface(
    name: String,
    block: suspend PublicVirtualInterfaceResourceBuilder.() -> Unit,
): PublicVirtualInterface {
    val builder = PublicVirtualInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PublicVirtualInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun publicVirtualInterface(name: String): PublicVirtualInterface {
    val builder = PublicVirtualInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
