@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Direct Connect transit virtual interface resource.
 * A transit virtual interface is a VLAN that transports traffic from a Direct Connect gateway to one or more transit gateways.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directconnect.Gateway("example", {
 *     name: "tf-dxg-example",
 *     amazonSideAsn: "64512",
 * });
 * const exampleTransitVirtualInterface = new aws.directconnect.TransitVirtualInterface("example", {
 *     connectionId: exampleAwsDxConnection.id,
 *     dxGatewayId: example.id,
 *     name: "tf-transit-vif-example",
 *     vlan: 4094,
 *     addressFamily: "ipv4",
 *     bgpAsn: 65352,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directconnect.Gateway("example",
 *     name="tf-dxg-example",
 *     amazon_side_asn="64512")
 * example_transit_virtual_interface = aws.directconnect.TransitVirtualInterface("example",
 *     connection_id=example_aws_dx_connection["id"],
 *     dx_gateway_id=example.id,
 *     name="tf-transit-vif-example",
 *     vlan=4094,
 *     address_family="ipv4",
 *     bgp_asn=65352)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectConnect.Gateway("example", new()
 *     {
 *         Name = "tf-dxg-example",
 *         AmazonSideAsn = "64512",
 *     });
 *     var exampleTransitVirtualInterface = new Aws.DirectConnect.TransitVirtualInterface("example", new()
 *     {
 *         ConnectionId = exampleAwsDxConnection.Id,
 *         DxGatewayId = example.Id,
 *         Name = "tf-transit-vif-example",
 *         Vlan = 4094,
 *         AddressFamily = "ipv4",
 *         BgpAsn = 65352,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := directconnect.NewGateway(ctx, "example", &directconnect.GatewayArgs{
 * 			Name:          pulumi.String("tf-dxg-example"),
 * 			AmazonSideAsn: pulumi.String("64512"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directconnect.NewTransitVirtualInterface(ctx, "example", &directconnect.TransitVirtualInterfaceArgs{
 * 			ConnectionId:  pulumi.Any(exampleAwsDxConnection.Id),
 * 			DxGatewayId:   example.ID(),
 * 			Name:          pulumi.String("tf-transit-vif-example"),
 * 			Vlan:          pulumi.Int(4094),
 * 			AddressFamily: pulumi.String("ipv4"),
 * 			BgpAsn:        pulumi.Int(65352),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.directconnect.TransitVirtualInterface;
 * import com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .name("tf-dxg-example")
 *             .amazonSideAsn(64512)
 *             .build());
 *         var exampleTransitVirtualInterface = new TransitVirtualInterface("exampleTransitVirtualInterface", TransitVirtualInterfaceArgs.builder()
 *             .connectionId(exampleAwsDxConnection.id())
 *             .dxGatewayId(example.id())
 *             .name("tf-transit-vif-example")
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directconnect:Gateway
 *     properties:
 *       name: tf-dxg-example
 *       amazonSideAsn: 64512
 *   exampleTransitVirtualInterface:
 *     type: aws:directconnect:TransitVirtualInterface
 *     name: example
 *     properties:
 *       connectionId: ${exampleAwsDxConnection.id}
 *       dxGatewayId: ${example.id}
 *       name: tf-transit-vif-example
 *       vlan: 4094
 *       addressFamily: ipv4
 *       bgpAsn: 65352
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Direct Connect transit virtual interfaces using the VIF `id`. For example:
 * ```sh
 * $ pulumi import aws:directconnect/transitVirtualInterface:TransitVirtualInterface test dxvif-33cc44dd
 * ```
 * @property addressFamily The address family for the BGP peer. `ipv4 ` or `ipv6`.
 * @property amazonAddress The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
 * @property bgpAsn The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
 * @property bgpAuthKey The authentication key for BGP configuration.
 * @property connectionId The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
 * @property customerAddress The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
 * @property dxGatewayId The ID of the Direct Connect gateway to which to connect the virtual interface.
 * @property mtu The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection.
 * The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
 * @property name The name for the virtual interface.
 * @property sitelinkEnabled Indicates whether to enable or disable SiteLink.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vlan The VLAN ID.
 */
public data class TransitVirtualInterfaceArgs(
    public val addressFamily: Output<String>? = null,
    public val amazonAddress: Output<String>? = null,
    public val bgpAsn: Output<Int>? = null,
    public val bgpAuthKey: Output<String>? = null,
    public val connectionId: Output<String>? = null,
    public val customerAddress: Output<String>? = null,
    public val dxGatewayId: Output<String>? = null,
    public val mtu: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val sitelinkEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vlan: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs =
        com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs.builder()
            .addressFamily(addressFamily?.applyValue({ args0 -> args0 }))
            .amazonAddress(amazonAddress?.applyValue({ args0 -> args0 }))
            .bgpAsn(bgpAsn?.applyValue({ args0 -> args0 }))
            .bgpAuthKey(bgpAuthKey?.applyValue({ args0 -> args0 }))
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .customerAddress(customerAddress?.applyValue({ args0 -> args0 }))
            .dxGatewayId(dxGatewayId?.applyValue({ args0 -> args0 }))
            .mtu(mtu?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sitelinkEnabled(sitelinkEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vlan(vlan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitVirtualInterfaceArgs].
 */
@PulumiTagMarker
public class TransitVirtualInterfaceArgsBuilder internal constructor() {
    private var addressFamily: Output<String>? = null

    private var amazonAddress: Output<String>? = null

    private var bgpAsn: Output<Int>? = null

    private var bgpAuthKey: Output<String>? = null

    private var connectionId: Output<String>? = null

    private var customerAddress: Output<String>? = null

    private var dxGatewayId: Output<String>? = null

    private var mtu: Output<Int>? = null

    private var name: Output<String>? = null

    private var sitelinkEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vlan: Output<Int>? = null

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("aqecjgjdglhvhnjb")
    public suspend fun addressFamily(`value`: Output<String>) {
        this.addressFamily = value
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    @JvmName("ghgcthmiuanpsosh")
    public suspend fun amazonAddress(`value`: Output<String>) {
        this.amazonAddress = value
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("tiqefrtgltwveiia")
    public suspend fun bgpAsn(`value`: Output<Int>) {
        this.bgpAsn = value
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("scxlkhkhedafogba")
    public suspend fun bgpAuthKey(`value`: Output<String>) {
        this.bgpAuthKey = value
    }

    /**
     * @param value The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    @JvmName("autkjaowgdirwilk")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    @JvmName("sawailssjbhhejox")
    public suspend fun customerAddress(`value`: Output<String>) {
        this.customerAddress = value
    }

    /**
     * @param value The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    @JvmName("sgvbtrhrrxsxpnix")
    public suspend fun dxGatewayId(`value`: Output<String>) {
        this.dxGatewayId = value
    }

    /**
     * @param value The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection.
     * The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
     */
    @JvmName("dhbmccewsiqmkmdg")
    public suspend fun mtu(`value`: Output<Int>) {
        this.mtu = value
    }

    /**
     * @param value The name for the virtual interface.
     */
    @JvmName("wslxbqpmkfxdieoh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether to enable or disable SiteLink.
     */
    @JvmName("ypfpthhmrqfqomty")
    public suspend fun sitelinkEnabled(`value`: Output<Boolean>) {
        this.sitelinkEnabled = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jmxcaomkbxjpngxj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("jqwpvagbrmpjfctk")
    public suspend fun vlan(`value`: Output<Int>) {
        this.vlan = value
    }

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("nkgdxetmtpmuedph")
    public suspend fun addressFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    @JvmName("ksuvlnirjgewpawh")
    public suspend fun amazonAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonAddress = mapped
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("krdyrkesbnviaqhi")
    public suspend fun bgpAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAsn = mapped
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("yrrvhktixpuqsatg")
    public suspend fun bgpAuthKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAuthKey = mapped
    }

    /**
     * @param value The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    @JvmName("rqiiexakpyebobgm")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    @JvmName("diwvmqxclwqjrbji")
    public suspend fun customerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerAddress = mapped
    }

    /**
     * @param value The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    @JvmName("xbgjjrrrsujonvcn")
    public suspend fun dxGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dxGatewayId = mapped
    }

    /**
     * @param value The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection.
     * The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
     */
    @JvmName("vryrchnjyeumgpxj")
    public suspend fun mtu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mtu = mapped
    }

    /**
     * @param value The name for the virtual interface.
     */
    @JvmName("uuvpobaptqgguoin")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether to enable or disable SiteLink.
     */
    @JvmName("kajjmsegpwcxxkgi")
    public suspend fun sitelinkEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sitelinkEnabled = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dvnggqpmpiifulrv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cuoaaeiyccswexnd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("wxsicwrrvnrfughg")
    public suspend fun vlan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlan = mapped
    }

    internal fun build(): TransitVirtualInterfaceArgs = TransitVirtualInterfaceArgs(
        addressFamily = addressFamily,
        amazonAddress = amazonAddress,
        bgpAsn = bgpAsn,
        bgpAuthKey = bgpAuthKey,
        connectionId = connectionId,
        customerAddress = customerAddress,
        dxGatewayId = dxGatewayId,
        mtu = mtu,
        name = name,
        sitelinkEnabled = sitelinkEnabled,
        tags = tags,
        vlan = vlan,
    )
}
