@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin.inputs

import com.pulumi.aws.directconnect.inputs.GetGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGateway.
 * @property name Name of the gateway to retrieve.
 */
public data class GetGatewayPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.directconnect.inputs.GetGatewayPlainArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.inputs.GetGatewayPlainArgs =
        com.pulumi.aws.directconnect.inputs.GetGatewayPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetGatewayPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the gateway to retrieve.
     */
    @JvmName("jalskqvmdnxojttr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetGatewayPlainArgs = GetGatewayPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
