@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin.inputs

import com.pulumi.aws.directconnect.inputs.GetLocationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLocation.
 * @property locationCode Code for the location to retrieve.
 */
public data class GetLocationPlainArgs(
    public val locationCode: String,
) : ConvertibleToJava<com.pulumi.aws.directconnect.inputs.GetLocationPlainArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.inputs.GetLocationPlainArgs =
        com.pulumi.aws.directconnect.inputs.GetLocationPlainArgs.builder()
            .locationCode(locationCode.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLocationPlainArgs].
 */
@PulumiTagMarker
public class GetLocationPlainArgsBuilder internal constructor() {
    private var locationCode: String? = null

    /**
     * @param value Code for the location to retrieve.
     */
    @JvmName("xaxbnaqarfgmhowi")
    public suspend fun locationCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.locationCode = mapped
    }

    internal fun build(): GetLocationPlainArgs = GetLocationPlainArgs(
        locationCode = locationCode ?: throw PulumiNullFieldException("locationCode"),
    )
}
