@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getConnection.
 * @property arn ARN of the connection.
 * @property awsDevice Direct Connect endpoint on which the physical connection terminates.
 * @property bandwidth Bandwidth of the connection.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property location AWS Direct Connect location where the connection is located.
 * @property name
 * @property ownerAccountId ID of the AWS account that owns the connection.
 * @property partnerName The name of the AWS Direct Connect service provider associated with the connection.
 * @property providerName Name of the service provider associated with the connection.
 * @property tags Map of tags for the resource.
 * @property vlanId The VLAN ID.
 */
public data class GetConnectionResult(
    public val arn: String,
    public val awsDevice: String,
    public val bandwidth: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val ownerAccountId: String,
    public val partnerName: String,
    public val providerName: String,
    public val tags: Map<String, String>,
    public val vlanId: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directconnect.outputs.GetConnectionResult): GetConnectionResult = GetConnectionResult(
            arn = javaType.arn(),
            awsDevice = javaType.awsDevice(),
            bandwidth = javaType.bandwidth(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            ownerAccountId = javaType.ownerAccountId(),
            partnerName = javaType.partnerName(),
            providerName = javaType.providerName(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vlanId = javaType.vlanId(),
        )
    }
}
