@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getGateway.
 * @property amazonSideAsn ASN on the Amazon side of the connection.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property ownerAccountId AWS Account ID of the gateway.
 */
public data class GetGatewayResult(
    public val amazonSideAsn: String,
    public val id: String,
    public val name: String,
    public val ownerAccountId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directconnect.outputs.GetGatewayResult): GetGatewayResult = GetGatewayResult(
            amazonSideAsn = javaType.amazonSideAsn(),
            id = javaType.id(),
            name = javaType.name(),
            ownerAccountId = javaType.ownerAccountId(),
        )
    }
}
