@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLocation.
 * @property availableMacsecPortSpeeds The available MAC Security (MACsec) port speeds for the location.
 * @property availablePortSpeeds The available port speeds for the location.
 * @property availableProviders Names of the service providers for the location.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property locationCode
 * @property locationName Name of the location. This includes the name of the colocation partner and the physical site of the building.
 */
public data class GetLocationResult(
    public val availableMacsecPortSpeeds: List<String>,
    public val availablePortSpeeds: List<String>,
    public val availableProviders: List<String>,
    public val id: String,
    public val locationCode: String,
    public val locationName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directconnect.outputs.GetLocationResult): GetLocationResult = GetLocationResult(
            availableMacsecPortSpeeds = javaType.availableMacsecPortSpeeds().map({ args0 -> args0 }),
            availablePortSpeeds = javaType.availablePortSpeeds().map({ args0 -> args0 }),
            availableProviders = javaType.availableProviders().map({ args0 -> args0 }),
            id = javaType.id(),
            locationCode = javaType.locationCode(),
            locationName = javaType.locationName(),
        )
    }
}
