@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLocations.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property locationCodes Code for the locations.
 */
public data class GetLocationsResult(
    public val id: String,
    public val locationCodes: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directconnect.outputs.GetLocationsResult): GetLocationsResult = GetLocationsResult(
            id = javaType.id(),
            locationCodes = javaType.locationCodes().map({ args0 -> args0 }),
        )
    }
}
