@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRouterConfiguration.
 * @property customerRouterConfig Instructions for configuring your router
 * @property id The provider-assigned unique ID for this managed resource.
 * @property routerTypeIdentifier Router type identifier
 * @property routers Block of the router type details
 * @property virtualInterfaceId
 * @property virtualInterfaceName
 */
public data class GetRouterConfigurationResult(
    public val customerRouterConfig: String,
    public val id: String,
    public val routerTypeIdentifier: String,
    public val routers: List<GetRouterConfigurationRouter>,
    public val virtualInterfaceId: String,
    public val virtualInterfaceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directconnect.outputs.GetRouterConfigurationResult): GetRouterConfigurationResult = GetRouterConfigurationResult(
            customerRouterConfig = javaType.customerRouterConfig(),
            id = javaType.id(),
            routerTypeIdentifier = javaType.routerTypeIdentifier(),
            routers = javaType.routers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.directconnect.kotlin.outputs.GetRouterConfigurationRouter.Companion.toKotlin(args0)
                })
            }),
            virtualInterfaceId = javaType.virtualInterfaceId(),
            virtualInterfaceName = javaType.virtualInterfaceName(),
        )
    }
}
