@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ConditionalForwader].
 */
@PulumiTagMarker
public class ConditionalForwaderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConditionalForwaderArgs = ConditionalForwaderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConditionalForwaderArgsBuilder.() -> Unit) {
        val builder = ConditionalForwaderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConditionalForwader {
        val builtJavaResource =
            com.pulumi.aws.directoryservice.ConditionalForwader(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConditionalForwader(builtJavaResource)
    }
}

/**
 * Provides a conditional forwarder for managed Microsoft AD in AWS Directory Service.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directoryservice.ConditionalForwader("example", {
 *     directoryId: ad.id,
 *     remoteDomainName: "example.com",
 *     dnsIps: [
 *         "8.8.8.8",
 *         "8.8.4.4",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directoryservice.ConditionalForwader("example",
 *     directory_id=ad["id"],
 *     remote_domain_name="example.com",
 *     dns_ips=[
 *         "8.8.8.8",
 *         "8.8.4.4",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectoryService.ConditionalForwader("example", new()
 *     {
 *         DirectoryId = ad.Id,
 *         RemoteDomainName = "example.com",
 *         DnsIps = new[]
 *         {
 *             "8.8.8.8",
 *             "8.8.4.4",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directoryservice.NewConditionalForwader(ctx, "example", &directoryservice.ConditionalForwaderArgs{
 * 			DirectoryId:      pulumi.Any(ad.Id),
 * 			RemoteDomainName: pulumi.String("example.com"),
 * 			DnsIps: pulumi.StringArray{
 * 				pulumi.String("8.8.8.8"),
 * 				pulumi.String("8.8.4.4"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.ConditionalForwader;
 * import com.pulumi.aws.directoryservice.ConditionalForwaderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConditionalForwader("example", ConditionalForwaderArgs.builder()
 *             .directoryId(ad.id())
 *             .remoteDomainName("example.com")
 *             .dnsIps(
 *                 "8.8.8.8",
 *                 "8.8.4.4")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directoryservice:ConditionalForwader
 *     properties:
 *       directoryId: ${ad.id}
 *       remoteDomainName: example.com
 *       dnsIps:
 *         - 8.8.8.8
 *         - 8.8.4.4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import conditional forwarders using the directory id and remote_domain_name. For example:
 * ```sh
 * $ pulumi import aws:directoryservice/conditionalForwader:ConditionalForwader example d-1234567890:example.com
 * ```
 */
public class ConditionalForwader internal constructor(
    override val javaResource: com.pulumi.aws.directoryservice.ConditionalForwader,
) : KotlinCustomResource(javaResource, ConditionalForwaderMapper) {
    /**
     * ID of directory.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * A list of forwarder IP addresses.
     */
    public val dnsIps: Output<List<String>>
        get() = javaResource.dnsIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The fully qualified domain name of the remote domain for which forwarders will be used.
     */
    public val remoteDomainName: Output<String>
        get() = javaResource.remoteDomainName().applyValue({ args0 -> args0 })
}

public object ConditionalForwaderMapper : ResourceMapper<ConditionalForwader> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directoryservice.ConditionalForwader::class == javaResource::class

    override fun map(javaResource: Resource): ConditionalForwader = ConditionalForwader(
        javaResource
            as com.pulumi.aws.directoryservice.ConditionalForwader,
    )
}

/**
 * @see [ConditionalForwader].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConditionalForwader].
 */
public suspend fun conditionalForwader(
    name: String,
    block: suspend ConditionalForwaderResourceBuilder.() -> Unit,
): ConditionalForwader {
    val builder = ConditionalForwaderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConditionalForwader].
 * @param name The _unique_ name of the resulting resource.
 */
public fun conditionalForwader(name: String): ConditionalForwader {
    val builder = ConditionalForwaderResourceBuilder()
    builder.name(name)
    return builder.build()
}
