@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.ConditionalForwaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a conditional forwarder for managed Microsoft AD in AWS Directory Service.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directoryservice.ConditionalForwader("example", {
 *     directoryId: ad.id,
 *     remoteDomainName: "example.com",
 *     dnsIps: [
 *         "8.8.8.8",
 *         "8.8.4.4",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directoryservice.ConditionalForwader("example",
 *     directory_id=ad["id"],
 *     remote_domain_name="example.com",
 *     dns_ips=[
 *         "8.8.8.8",
 *         "8.8.4.4",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectoryService.ConditionalForwader("example", new()
 *     {
 *         DirectoryId = ad.Id,
 *         RemoteDomainName = "example.com",
 *         DnsIps = new[]
 *         {
 *             "8.8.8.8",
 *             "8.8.4.4",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directoryservice.NewConditionalForwader(ctx, "example", &directoryservice.ConditionalForwaderArgs{
 * 			DirectoryId:      pulumi.Any(ad.Id),
 * 			RemoteDomainName: pulumi.String("example.com"),
 * 			DnsIps: pulumi.StringArray{
 * 				pulumi.String("8.8.8.8"),
 * 				pulumi.String("8.8.4.4"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.ConditionalForwader;
 * import com.pulumi.aws.directoryservice.ConditionalForwaderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConditionalForwader("example", ConditionalForwaderArgs.builder()
 *             .directoryId(ad.id())
 *             .remoteDomainName("example.com")
 *             .dnsIps(
 *                 "8.8.8.8",
 *                 "8.8.4.4")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directoryservice:ConditionalForwader
 *     properties:
 *       directoryId: ${ad.id}
 *       remoteDomainName: example.com
 *       dnsIps:
 *         - 8.8.8.8
 *         - 8.8.4.4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import conditional forwarders using the directory id and remote_domain_name. For example:
 * ```sh
 * $ pulumi import aws:directoryservice/conditionalForwader:ConditionalForwader example d-1234567890:example.com
 * ```
 * @property directoryId ID of directory.
 * @property dnsIps A list of forwarder IP addresses.
 * @property remoteDomainName The fully qualified domain name of the remote domain for which forwarders will be used.
 */
public data class ConditionalForwaderArgs(
    public val directoryId: Output<String>? = null,
    public val dnsIps: Output<List<String>>? = null,
    public val remoteDomainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.ConditionalForwaderArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.ConditionalForwaderArgs =
        com.pulumi.aws.directoryservice.ConditionalForwaderArgs.builder()
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .dnsIps(dnsIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .remoteDomainName(remoteDomainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConditionalForwaderArgs].
 */
@PulumiTagMarker
public class ConditionalForwaderArgsBuilder internal constructor() {
    private var directoryId: Output<String>? = null

    private var dnsIps: Output<List<String>>? = null

    private var remoteDomainName: Output<String>? = null

    /**
     * @param value ID of directory.
     */
    @JvmName("pnuwxubcxlaftemq")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value A list of forwarder IP addresses.
     */
    @JvmName("dgtscxoxonvtnuqj")
    public suspend fun dnsIps(`value`: Output<List<String>>) {
        this.dnsIps = value
    }

    @JvmName("ddqcnkfggtkiocko")
    public suspend fun dnsIps(vararg values: Output<String>) {
        this.dnsIps = Output.all(values.asList())
    }

    /**
     * @param values A list of forwarder IP addresses.
     */
    @JvmName("ljbkmqjhhaominje")
    public suspend fun dnsIps(values: List<Output<String>>) {
        this.dnsIps = Output.all(values)
    }

    /**
     * @param value The fully qualified domain name of the remote domain for which forwarders will be used.
     */
    @JvmName("okmmyhyoxwlqpbvc")
    public suspend fun remoteDomainName(`value`: Output<String>) {
        this.remoteDomainName = value
    }

    /**
     * @param value ID of directory.
     */
    @JvmName("omdsmcgismwsorxn")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value A list of forwarder IP addresses.
     */
    @JvmName("nugqqfhamvcvotoa")
    public suspend fun dnsIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsIps = mapped
    }

    /**
     * @param values A list of forwarder IP addresses.
     */
    @JvmName("yjnmyhfotcaqddlo")
    public suspend fun dnsIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsIps = mapped
    }

    /**
     * @param value The fully qualified domain name of the remote domain for which forwarders will be used.
     */
    @JvmName("eoobmynhfdsctctc")
    public suspend fun remoteDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDomainName = mapped
    }

    internal fun build(): ConditionalForwaderArgs = ConditionalForwaderArgs(
        directoryId = directoryId,
        dnsIps = dnsIps,
        remoteDomainName = remoteDomainName,
    )
}
