@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.kotlin.outputs.DirectoryConnectSettings
import com.pulumi.aws.directoryservice.kotlin.outputs.DirectoryVpcSettings
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.directoryservice.kotlin.outputs.DirectoryConnectSettings.Companion.toKotlin as directoryConnectSettingsToKotlin
import com.pulumi.aws.directoryservice.kotlin.outputs.DirectoryVpcSettings.Companion.toKotlin as directoryVpcSettingsToKotlin

/**
 * Builder for [Directory].
 */
@PulumiTagMarker
public class DirectoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DirectoryArgs = DirectoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DirectoryArgsBuilder.() -> Unit) {
        val builder = DirectoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Directory {
        val builtJavaResource = com.pulumi.aws.directoryservice.Directory(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Directory(builtJavaResource)
    }
}

/**
 * Provides a Simple or Managed Microsoft directory in AWS Directory Service.
 * ## Example Usage
 * ### SimpleAD
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * const foo = new aws.ec2.Subnet("foo", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2a",
 *     cidrBlock: "10.0.1.0/24",
 * });
 * const barSubnet = new aws.ec2.Subnet("bar", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2b",
 *     cidrBlock: "10.0.2.0/24",
 * });
 * const bar = new aws.directoryservice.Directory("bar", {
 *     name: "corp.notexample.com",
 *     password: "SuperSecretPassw0rd",
 *     size: "Small",
 *     vpcSettings: {
 *         vpcId: main.id,
 *         subnetIds: [
 *             foo.id,
 *             barSubnet.id,
 *         ],
 *     },
 *     tags: {
 *         Project: "foo",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * foo = aws.ec2.Subnet("foo",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2a",
 *     cidr_block="10.0.1.0/24")
 * bar_subnet = aws.ec2.Subnet("bar",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2b",
 *     cidr_block="10.0.2.0/24")
 * bar = aws.directoryservice.Directory("bar",
 *     name="corp.notexample.com",
 *     password="SuperSecretPassw0rd",
 *     size="Small",
 *     vpc_settings={
 *         "vpc_id": main.id,
 *         "subnet_ids": [
 *             foo.id,
 *             bar_subnet.id,
 *         ],
 *     },
 *     tags={
 *         "Project": "foo",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var foo = new Aws.Ec2.Subnet("foo", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2a",
 *         CidrBlock = "10.0.1.0/24",
 *     });
 *     var barSubnet = new Aws.Ec2.Subnet("bar", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2b",
 *         CidrBlock = "10.0.2.0/24",
 *     });
 *     var bar = new Aws.DirectoryService.Directory("bar", new()
 *     {
 *         Name = "corp.notexample.com",
 *         Password = "SuperSecretPassw0rd",
 *         Size = "Small",
 *         VpcSettings = new Aws.DirectoryService.Inputs.DirectoryVpcSettingsArgs
 *         {
 *             VpcId = main.Id,
 *             SubnetIds = new[]
 *             {
 *                 foo.Id,
 *                 barSubnet.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Project", "foo" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		foo, err := ec2.NewSubnet(ctx, "foo", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			CidrBlock:        pulumi.String("10.0.1.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		barSubnet, err := ec2.NewSubnet(ctx, "bar", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2b"),
 * 			CidrBlock:        pulumi.String("10.0.2.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewDirectory(ctx, "bar", &directoryservice.DirectoryArgs{
 * 			Name:     pulumi.String("corp.notexample.com"),
 * 			Password: pulumi.String("SuperSecretPassw0rd"),
 * 			Size:     pulumi.String("Small"),
 * 			VpcSettings: &directoryservice.DirectoryVpcSettingsArgs{
 * 				VpcId: main.ID(),
 * 				SubnetIds: pulumi.StringArray{
 * 					foo.ID(),
 * 					barSubnet.ID(),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Project": pulumi.String("foo"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var foo = new Subnet("foo", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var barSubnet = new Subnet("barSubnet", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2b")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var bar = new Directory("bar", DirectoryArgs.builder()
 *             .name("corp.notexample.com")
 *             .password("SuperSecretPassw0rd")
 *             .size("Small")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(main.id())
 *                 .subnetIds(
 *                     foo.id(),
 *                     barSubnet.id())
 *                 .build())
 *             .tags(Map.of("Project", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:directoryservice:Directory
 *     properties:
 *       name: corp.notexample.com
 *       password: SuperSecretPassw0rd
 *       size: Small
 *       vpcSettings:
 *         vpcId: ${main.id}
 *         subnetIds:
 *           - ${foo.id}
 *           - ${barSubnet.id}
 *       tags:
 *         Project: foo
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   foo:
 *     type: aws:ec2:Subnet
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2a
 *       cidrBlock: 10.0.1.0/24
 *   barSubnet:
 *     type: aws:ec2:Subnet
 *     name: bar
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2b
 *       cidrBlock: 10.0.2.0/24
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Microsoft Active Directory (MicrosoftAD)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * const foo = new aws.ec2.Subnet("foo", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2a",
 *     cidrBlock: "10.0.1.0/24",
 * });
 * const barSubnet = new aws.ec2.Subnet("bar", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2b",
 *     cidrBlock: "10.0.2.0/24",
 * });
 * const bar = new aws.directoryservice.Directory("bar", {
 *     name: "corp.notexample.com",
 *     password: "SuperSecretPassw0rd",
 *     edition: "Standard",
 *     type: "MicrosoftAD",
 *     vpcSettings: {
 *         vpcId: main.id,
 *         subnetIds: [
 *             foo.id,
 *             barSubnet.id,
 *         ],
 *     },
 *     tags: {
 *         Project: "foo",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * foo = aws.ec2.Subnet("foo",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2a",
 *     cidr_block="10.0.1.0/24")
 * bar_subnet = aws.ec2.Subnet("bar",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2b",
 *     cidr_block="10.0.2.0/24")
 * bar = aws.directoryservice.Directory("bar",
 *     name="corp.notexample.com",
 *     password="SuperSecretPassw0rd",
 *     edition="Standard",
 *     type="MicrosoftAD",
 *     vpc_settings={
 *         "vpc_id": main.id,
 *         "subnet_ids": [
 *             foo.id,
 *             bar_subnet.id,
 *         ],
 *     },
 *     tags={
 *         "Project": "foo",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var foo = new Aws.Ec2.Subnet("foo", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2a",
 *         CidrBlock = "10.0.1.0/24",
 *     });
 *     var barSubnet = new Aws.Ec2.Subnet("bar", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2b",
 *         CidrBlock = "10.0.2.0/24",
 *     });
 *     var bar = new Aws.DirectoryService.Directory("bar", new()
 *     {
 *         Name = "corp.notexample.com",
 *         Password = "SuperSecretPassw0rd",
 *         Edition = "Standard",
 *         Type = "MicrosoftAD",
 *         VpcSettings = new Aws.DirectoryService.Inputs.DirectoryVpcSettingsArgs
 *         {
 *             VpcId = main.Id,
 *             SubnetIds = new[]
 *             {
 *                 foo.Id,
 *                 barSubnet.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Project", "foo" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		foo, err := ec2.NewSubnet(ctx, "foo", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			CidrBlock:        pulumi.String("10.0.1.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		barSubnet, err := ec2.NewSubnet(ctx, "bar", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2b"),
 * 			CidrBlock:        pulumi.String("10.0.2.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewDirectory(ctx, "bar", &directoryservice.DirectoryArgs{
 * 			Name:     pulumi.String("corp.notexample.com"),
 * 			Password: pulumi.String("SuperSecretPassw0rd"),
 * 			Edition:  pulumi.String("Standard"),
 * 			Type:     pulumi.String("MicrosoftAD"),
 * 			VpcSettings: &directoryservice.DirectoryVpcSettingsArgs{
 * 				VpcId: main.ID(),
 * 				SubnetIds: pulumi.StringArray{
 * 					foo.ID(),
 * 					barSubnet.ID(),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Project": pulumi.String("foo"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var foo = new Subnet("foo", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var barSubnet = new Subnet("barSubnet", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2b")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var bar = new Directory("bar", DirectoryArgs.builder()
 *             .name("corp.notexample.com")
 *             .password("SuperSecretPassw0rd")
 *             .edition("Standard")
 *             .type("MicrosoftAD")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(main.id())
 *                 .subnetIds(
 *                     foo.id(),
 *                     barSubnet.id())
 *                 .build())
 *             .tags(Map.of("Project", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:directoryservice:Directory
 *     properties:
 *       name: corp.notexample.com
 *       password: SuperSecretPassw0rd
 *       edition: Standard
 *       type: MicrosoftAD
 *       vpcSettings:
 *         vpcId: ${main.id}
 *         subnetIds:
 *           - ${foo.id}
 *           - ${barSubnet.id}
 *       tags:
 *         Project: foo
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   foo:
 *     type: aws:ec2:Subnet
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2a
 *       cidrBlock: 10.0.1.0/24
 *   barSubnet:
 *     type: aws:ec2:Subnet
 *     name: bar
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2b
 *       cidrBlock: 10.0.2.0/24
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Microsoft Active Directory Connector (ADConnector)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * const foo = new aws.ec2.Subnet("foo", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2a",
 *     cidrBlock: "10.0.1.0/24",
 * });
 * const bar = new aws.ec2.Subnet("bar", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2b",
 *     cidrBlock: "10.0.2.0/24",
 * });
 * const connector = new aws.directoryservice.Directory("connector", {
 *     name: "corp.notexample.com",
 *     password: "SuperSecretPassw0rd",
 *     size: "Small",
 *     type: "ADConnector",
 *     connectSettings: {
 *         customerDnsIps: ["A&#46;B&#46;C&#46;D"],
 *         customerUsername: "Admin",
 *         subnetIds: [
 *             foo.id,
 *             bar.id,
 *         ],
 *         vpcId: main.id,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * foo = aws.ec2.Subnet("foo",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2a",
 *     cidr_block="10.0.1.0/24")
 * bar = aws.ec2.Subnet("bar",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2b",
 *     cidr_block="10.0.2.0/24")
 * connector = aws.directoryservice.Directory("connector",
 *     name="corp.notexample.com",
 *     password="SuperSecretPassw0rd",
 *     size="Small",
 *     type="ADConnector",
 *     connect_settings={
 *         "customer_dns_ips": ["A&#46;B&#46;C&#46;D"],
 *         "customer_username": "Admin",
 *         "subnet_ids": [
 *             foo.id,
 *             bar.id,
 *         ],
 *         "vpc_id": main.id,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var foo = new Aws.Ec2.Subnet("foo", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2a",
 *         CidrBlock = "10.0.1.0/24",
 *     });
 *     var bar = new Aws.Ec2.Subnet("bar", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2b",
 *         CidrBlock = "10.0.2.0/24",
 *     });
 *     var connector = new Aws.DirectoryService.Directory("connector", new()
 *     {
 *         Name = "corp.notexample.com",
 *         Password = "SuperSecretPassw0rd",
 *         Size = "Small",
 *         Type = "ADConnector",
 *         ConnectSettings = new Aws.DirectoryService.Inputs.DirectoryConnectSettingsArgs
 *         {
 *             CustomerDnsIps = new[]
 *             {
 *                 "A.B.C.D",
 *             },
 *             CustomerUsername = "Admin",
 *             SubnetIds = new[]
 *             {
 *                 foo.Id,
 *                 bar.Id,
 *             },
 *             VpcId = main.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		foo, err := ec2.NewSubnet(ctx, "foo", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			CidrBlock:        pulumi.String("10.0.1.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bar, err := ec2.NewSubnet(ctx, "bar", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2b"),
 * 			CidrBlock:        pulumi.String("10.0.2.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewDirectory(ctx, "connector", &directoryservice.DirectoryArgs{
 * 			Name:     pulumi.String("corp.notexample.com"),
 * 			Password: pulumi.String("SuperSecretPassw0rd"),
 * 			Size:     pulumi.String("Small"),
 * 			Type:     pulumi.String("ADConnector"),
 * 			ConnectSettings: &directoryservice.DirectoryConnectSettingsArgs{
 * 				CustomerDnsIps: pulumi.StringArray{
 * 					pulumi.String("A.B.C.D"),
 * 				},
 * 				CustomerUsername: pulumi.String("Admin"),
 * 				SubnetIds: pulumi.StringArray{
 * 					foo.ID(),
 * 					bar.ID(),
 * 				},
 * 				VpcId: main.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryConnectSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var foo = new Subnet("foo", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var bar = new Subnet("bar", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2b")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var connector = new Directory("connector", DirectoryArgs.builder()
 *             .name("corp.notexample.com")
 *             .password("SuperSecretPassw0rd")
 *             .size("Small")
 *             .type("ADConnector")
 *             .connectSettings(DirectoryConnectSettingsArgs.builder()
 *                 .customerDnsIps("A.B.C.D")
 *                 .customerUsername("Admin")
 *                 .subnetIds(
 *                     foo.id(),
 *                     bar.id())
 *                 .vpcId(main.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   connector:
 *     type: aws:directoryservice:Directory
 *     properties:
 *       name: corp.notexample.com
 *       password: SuperSecretPassw0rd
 *       size: Small
 *       type: ADConnector
 *       connectSettings:
 *         customerDnsIps:
 *           - A.B.C.D
 *         customerUsername: Admin
 *         subnetIds:
 *           - ${foo.id}
 *           - ${bar.id}
 *         vpcId: ${main.id}
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   foo:
 *     type: aws:ec2:Subnet
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2a
 *       cidrBlock: 10.0.1.0/24
 *   bar:
 *     type: aws:ec2:Subnet
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2b
 *       cidrBlock: 10.0.2.0/24
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DirectoryService directories using the directory `id`. For example:
 * ```sh
 * $ pulumi import aws:directoryservice/directory:Directory sample d-926724cf57
 * ```
 */
public class Directory internal constructor(
    override val javaResource: com.pulumi.aws.directoryservice.Directory,
) : KotlinCustomResource(javaResource, DirectoryMapper) {
    /**
     * The access URL for the directory, such as `http://alias.awsapps.com`.
     */
    public val accessUrl: Output<String>
        get() = javaResource.accessUrl().applyValue({ args0 -> args0 })

    /**
     * The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
     */
    public val alias: Output<String>
        get() = javaResource.alias().applyValue({ args0 -> args0 })

    /**
     * Connector related information about the directory. Fields documented below.
     */
    public val connectSettings: Output<DirectoryConnectSettings>?
        get() = javaResource.connectSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> directoryConnectSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A textual description for the directory.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
     */
    public val desiredNumberOfDomainControllers: Output<Int>
        get() = javaResource.desiredNumberOfDomainControllers().applyValue({ args0 -> args0 })

    /**
     * A list of IP addresses of the DNS servers for the directory or connector.
     */
    public val dnsIpAddresses: Output<List<String>>
        get() = javaResource.dnsIpAddresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
     */
    public val edition: Output<String>
        get() = javaResource.edition().applyValue({ args0 -> args0 })

    /**
     * Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
     */
    public val enableSso: Output<Boolean>?
        get() = javaResource.enableSso().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The fully qualified name for the directory, such as `corp.example.com`
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The password for the directory administrator or connector user.
     */
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * The ID of the security group created by the directory.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * The short name of the directory, such as `CORP`.
     */
    public val shortName: Output<String>
        get() = javaResource.shortName().applyValue({ args0 -> args0 })

    /**
     * (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
     */
    public val size: Output<String>
        get() = javaResource.size().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * VPC related information about the directory. Fields documented below.
     */
    public val vpcSettings: Output<DirectoryVpcSettings>?
        get() = javaResource.vpcSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    directoryVpcSettingsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DirectoryMapper : ResourceMapper<Directory> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directoryservice.Directory::class == javaResource::class

    override fun map(javaResource: Resource): Directory = Directory(
        javaResource as
            com.pulumi.aws.directoryservice.Directory,
    )
}

/**
 * @see [Directory].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Directory].
 */
public suspend fun directory(name: String, block: suspend DirectoryResourceBuilder.() -> Unit): Directory {
    val builder = DirectoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Directory].
 * @param name The _unique_ name of the resulting resource.
 */
public fun directory(name: String): Directory {
    val builder = DirectoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
