@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.DirectoryArgs.builder
import com.pulumi.aws.directoryservice.kotlin.inputs.DirectoryConnectSettingsArgs
import com.pulumi.aws.directoryservice.kotlin.inputs.DirectoryConnectSettingsArgsBuilder
import com.pulumi.aws.directoryservice.kotlin.inputs.DirectoryVpcSettingsArgs
import com.pulumi.aws.directoryservice.kotlin.inputs.DirectoryVpcSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Simple or Managed Microsoft directory in AWS Directory Service.
 * ## Example Usage
 * ### SimpleAD
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * const foo = new aws.ec2.Subnet("foo", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2a",
 *     cidrBlock: "10.0.1.0/24",
 * });
 * const barSubnet = new aws.ec2.Subnet("bar", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2b",
 *     cidrBlock: "10.0.2.0/24",
 * });
 * const bar = new aws.directoryservice.Directory("bar", {
 *     name: "corp.notexample.com",
 *     password: "SuperSecretPassw0rd",
 *     size: "Small",
 *     vpcSettings: {
 *         vpcId: main.id,
 *         subnetIds: [
 *             foo.id,
 *             barSubnet.id,
 *         ],
 *     },
 *     tags: {
 *         Project: "foo",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * foo = aws.ec2.Subnet("foo",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2a",
 *     cidr_block="10.0.1.0/24")
 * bar_subnet = aws.ec2.Subnet("bar",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2b",
 *     cidr_block="10.0.2.0/24")
 * bar = aws.directoryservice.Directory("bar",
 *     name="corp.notexample.com",
 *     password="SuperSecretPassw0rd",
 *     size="Small",
 *     vpc_settings={
 *         "vpc_id": main.id,
 *         "subnet_ids": [
 *             foo.id,
 *             bar_subnet.id,
 *         ],
 *     },
 *     tags={
 *         "Project": "foo",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var foo = new Aws.Ec2.Subnet("foo", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2a",
 *         CidrBlock = "10.0.1.0/24",
 *     });
 *     var barSubnet = new Aws.Ec2.Subnet("bar", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2b",
 *         CidrBlock = "10.0.2.0/24",
 *     });
 *     var bar = new Aws.DirectoryService.Directory("bar", new()
 *     {
 *         Name = "corp.notexample.com",
 *         Password = "SuperSecretPassw0rd",
 *         Size = "Small",
 *         VpcSettings = new Aws.DirectoryService.Inputs.DirectoryVpcSettingsArgs
 *         {
 *             VpcId = main.Id,
 *             SubnetIds = new[]
 *             {
 *                 foo.Id,
 *                 barSubnet.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Project", "foo" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		foo, err := ec2.NewSubnet(ctx, "foo", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			CidrBlock:        pulumi.String("10.0.1.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		barSubnet, err := ec2.NewSubnet(ctx, "bar", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2b"),
 * 			CidrBlock:        pulumi.String("10.0.2.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewDirectory(ctx, "bar", &directoryservice.DirectoryArgs{
 * 			Name:     pulumi.String("corp.notexample.com"),
 * 			Password: pulumi.String("SuperSecretPassw0rd"),
 * 			Size:     pulumi.String("Small"),
 * 			VpcSettings: &directoryservice.DirectoryVpcSettingsArgs{
 * 				VpcId: main.ID(),
 * 				SubnetIds: pulumi.StringArray{
 * 					foo.ID(),
 * 					barSubnet.ID(),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Project": pulumi.String("foo"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var foo = new Subnet("foo", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var barSubnet = new Subnet("barSubnet", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2b")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var bar = new Directory("bar", DirectoryArgs.builder()
 *             .name("corp.notexample.com")
 *             .password("SuperSecretPassw0rd")
 *             .size("Small")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(main.id())
 *                 .subnetIds(
 *                     foo.id(),
 *                     barSubnet.id())
 *                 .build())
 *             .tags(Map.of("Project", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:directoryservice:Directory
 *     properties:
 *       name: corp.notexample.com
 *       password: SuperSecretPassw0rd
 *       size: Small
 *       vpcSettings:
 *         vpcId: ${main.id}
 *         subnetIds:
 *           - ${foo.id}
 *           - ${barSubnet.id}
 *       tags:
 *         Project: foo
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   foo:
 *     type: aws:ec2:Subnet
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2a
 *       cidrBlock: 10.0.1.0/24
 *   barSubnet:
 *     type: aws:ec2:Subnet
 *     name: bar
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2b
 *       cidrBlock: 10.0.2.0/24
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Microsoft Active Directory (MicrosoftAD)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * const foo = new aws.ec2.Subnet("foo", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2a",
 *     cidrBlock: "10.0.1.0/24",
 * });
 * const barSubnet = new aws.ec2.Subnet("bar", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2b",
 *     cidrBlock: "10.0.2.0/24",
 * });
 * const bar = new aws.directoryservice.Directory("bar", {
 *     name: "corp.notexample.com",
 *     password: "SuperSecretPassw0rd",
 *     edition: "Standard",
 *     type: "MicrosoftAD",
 *     vpcSettings: {
 *         vpcId: main.id,
 *         subnetIds: [
 *             foo.id,
 *             barSubnet.id,
 *         ],
 *     },
 *     tags: {
 *         Project: "foo",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * foo = aws.ec2.Subnet("foo",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2a",
 *     cidr_block="10.0.1.0/24")
 * bar_subnet = aws.ec2.Subnet("bar",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2b",
 *     cidr_block="10.0.2.0/24")
 * bar = aws.directoryservice.Directory("bar",
 *     name="corp.notexample.com",
 *     password="SuperSecretPassw0rd",
 *     edition="Standard",
 *     type="MicrosoftAD",
 *     vpc_settings={
 *         "vpc_id": main.id,
 *         "subnet_ids": [
 *             foo.id,
 *             bar_subnet.id,
 *         ],
 *     },
 *     tags={
 *         "Project": "foo",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var foo = new Aws.Ec2.Subnet("foo", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2a",
 *         CidrBlock = "10.0.1.0/24",
 *     });
 *     var barSubnet = new Aws.Ec2.Subnet("bar", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2b",
 *         CidrBlock = "10.0.2.0/24",
 *     });
 *     var bar = new Aws.DirectoryService.Directory("bar", new()
 *     {
 *         Name = "corp.notexample.com",
 *         Password = "SuperSecretPassw0rd",
 *         Edition = "Standard",
 *         Type = "MicrosoftAD",
 *         VpcSettings = new Aws.DirectoryService.Inputs.DirectoryVpcSettingsArgs
 *         {
 *             VpcId = main.Id,
 *             SubnetIds = new[]
 *             {
 *                 foo.Id,
 *                 barSubnet.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Project", "foo" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		foo, err := ec2.NewSubnet(ctx, "foo", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			CidrBlock:        pulumi.String("10.0.1.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		barSubnet, err := ec2.NewSubnet(ctx, "bar", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2b"),
 * 			CidrBlock:        pulumi.String("10.0.2.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewDirectory(ctx, "bar", &directoryservice.DirectoryArgs{
 * 			Name:     pulumi.String("corp.notexample.com"),
 * 			Password: pulumi.String("SuperSecretPassw0rd"),
 * 			Edition:  pulumi.String("Standard"),
 * 			Type:     pulumi.String("MicrosoftAD"),
 * 			VpcSettings: &directoryservice.DirectoryVpcSettingsArgs{
 * 				VpcId: main.ID(),
 * 				SubnetIds: pulumi.StringArray{
 * 					foo.ID(),
 * 					barSubnet.ID(),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Project": pulumi.String("foo"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var foo = new Subnet("foo", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var barSubnet = new Subnet("barSubnet", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2b")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var bar = new Directory("bar", DirectoryArgs.builder()
 *             .name("corp.notexample.com")
 *             .password("SuperSecretPassw0rd")
 *             .edition("Standard")
 *             .type("MicrosoftAD")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(main.id())
 *                 .subnetIds(
 *                     foo.id(),
 *                     barSubnet.id())
 *                 .build())
 *             .tags(Map.of("Project", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:directoryservice:Directory
 *     properties:
 *       name: corp.notexample.com
 *       password: SuperSecretPassw0rd
 *       edition: Standard
 *       type: MicrosoftAD
 *       vpcSettings:
 *         vpcId: ${main.id}
 *         subnetIds:
 *           - ${foo.id}
 *           - ${barSubnet.id}
 *       tags:
 *         Project: foo
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   foo:
 *     type: aws:ec2:Subnet
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2a
 *       cidrBlock: 10.0.1.0/24
 *   barSubnet:
 *     type: aws:ec2:Subnet
 *     name: bar
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2b
 *       cidrBlock: 10.0.2.0/24
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Microsoft Active Directory Connector (ADConnector)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * const foo = new aws.ec2.Subnet("foo", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2a",
 *     cidrBlock: "10.0.1.0/24",
 * });
 * const bar = new aws.ec2.Subnet("bar", {
 *     vpcId: main.id,
 *     availabilityZone: "us-west-2b",
 *     cidrBlock: "10.0.2.0/24",
 * });
 * const connector = new aws.directoryservice.Directory("connector", {
 *     name: "corp.notexample.com",
 *     password: "SuperSecretPassw0rd",
 *     size: "Small",
 *     type: "ADConnector",
 *     connectSettings: {
 *         customerDnsIps: ["A&#46;B&#46;C&#46;D"],
 *         customerUsername: "Admin",
 *         subnetIds: [
 *             foo.id,
 *             bar.id,
 *         ],
 *         vpcId: main.id,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * foo = aws.ec2.Subnet("foo",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2a",
 *     cidr_block="10.0.1.0/24")
 * bar = aws.ec2.Subnet("bar",
 *     vpc_id=main.id,
 *     availability_zone="us-west-2b",
 *     cidr_block="10.0.2.0/24")
 * connector = aws.directoryservice.Directory("connector",
 *     name="corp.notexample.com",
 *     password="SuperSecretPassw0rd",
 *     size="Small",
 *     type="ADConnector",
 *     connect_settings={
 *         "customer_dns_ips": ["A&#46;B&#46;C&#46;D"],
 *         "customer_username": "Admin",
 *         "subnet_ids": [
 *             foo.id,
 *             bar.id,
 *         ],
 *         "vpc_id": main.id,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var foo = new Aws.Ec2.Subnet("foo", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2a",
 *         CidrBlock = "10.0.1.0/24",
 *     });
 *     var bar = new Aws.Ec2.Subnet("bar", new()
 *     {
 *         VpcId = main.Id,
 *         AvailabilityZone = "us-west-2b",
 *         CidrBlock = "10.0.2.0/24",
 *     });
 *     var connector = new Aws.DirectoryService.Directory("connector", new()
 *     {
 *         Name = "corp.notexample.com",
 *         Password = "SuperSecretPassw0rd",
 *         Size = "Small",
 *         Type = "ADConnector",
 *         ConnectSettings = new Aws.DirectoryService.Inputs.DirectoryConnectSettingsArgs
 *         {
 *             CustomerDnsIps = new[]
 *             {
 *                 "A.B.C.D",
 *             },
 *             CustomerUsername = "Admin",
 *             SubnetIds = new[]
 *             {
 *                 foo.Id,
 *                 bar.Id,
 *             },
 *             VpcId = main.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		foo, err := ec2.NewSubnet(ctx, "foo", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			CidrBlock:        pulumi.String("10.0.1.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bar, err := ec2.NewSubnet(ctx, "bar", &ec2.SubnetArgs{
 * 			VpcId:            main.ID(),
 * 			AvailabilityZone: pulumi.String("us-west-2b"),
 * 			CidrBlock:        pulumi.String("10.0.2.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewDirectory(ctx, "connector", &directoryservice.DirectoryArgs{
 * 			Name:     pulumi.String("corp.notexample.com"),
 * 			Password: pulumi.String("SuperSecretPassw0rd"),
 * 			Size:     pulumi.String("Small"),
 * 			Type:     pulumi.String("ADConnector"),
 * 			ConnectSettings: &directoryservice.DirectoryConnectSettingsArgs{
 * 				CustomerDnsIps: pulumi.StringArray{
 * 					pulumi.String("A.B.C.D"),
 * 				},
 * 				CustomerUsername: pulumi.String("Admin"),
 * 				SubnetIds: pulumi.StringArray{
 * 					foo.ID(),
 * 					bar.ID(),
 * 				},
 * 				VpcId: main.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryConnectSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var foo = new Subnet("foo", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var bar = new Subnet("bar", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2b")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var connector = new Directory("connector", DirectoryArgs.builder()
 *             .name("corp.notexample.com")
 *             .password("SuperSecretPassw0rd")
 *             .size("Small")
 *             .type("ADConnector")
 *             .connectSettings(DirectoryConnectSettingsArgs.builder()
 *                 .customerDnsIps("A.B.C.D")
 *                 .customerUsername("Admin")
 *                 .subnetIds(
 *                     foo.id(),
 *                     bar.id())
 *                 .vpcId(main.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   connector:
 *     type: aws:directoryservice:Directory
 *     properties:
 *       name: corp.notexample.com
 *       password: SuperSecretPassw0rd
 *       size: Small
 *       type: ADConnector
 *       connectSettings:
 *         customerDnsIps:
 *           - A.B.C.D
 *         customerUsername: Admin
 *         subnetIds:
 *           - ${foo.id}
 *           - ${bar.id}
 *         vpcId: ${main.id}
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   foo:
 *     type: aws:ec2:Subnet
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2a
 *       cidrBlock: 10.0.1.0/24
 *   bar:
 *     type: aws:ec2:Subnet
 *     properties:
 *       vpcId: ${main.id}
 *       availabilityZone: us-west-2b
 *       cidrBlock: 10.0.2.0/24
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DirectoryService directories using the directory `id`. For example:
 * ```sh
 * $ pulumi import aws:directoryservice/directory:Directory sample d-926724cf57
 * ```
 * @property alias The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
 * @property connectSettings Connector related information about the directory. Fields documented below.
 * @property description A textual description for the directory.
 * @property desiredNumberOfDomainControllers The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
 * @property edition The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
 * @property enableSso Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
 * @property name The fully qualified name for the directory, such as `corp.example.com`
 * @property password The password for the directory administrator or connector user.
 * @property shortName The short name of the directory, such as `CORP`.
 * @property size (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
 * @property vpcSettings VPC related information about the directory. Fields documented below.
 */
public data class DirectoryArgs(
    public val alias: Output<String>? = null,
    public val connectSettings: Output<DirectoryConnectSettingsArgs>? = null,
    public val description: Output<String>? = null,
    public val desiredNumberOfDomainControllers: Output<Int>? = null,
    public val edition: Output<String>? = null,
    public val enableSso: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val password: Output<String>? = null,
    public val shortName: Output<String>? = null,
    public val size: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val vpcSettings: Output<DirectoryVpcSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.DirectoryArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.DirectoryArgs =
        com.pulumi.aws.directoryservice.DirectoryArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .connectSettings(connectSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .desiredNumberOfDomainControllers(desiredNumberOfDomainControllers?.applyValue({ args0 -> args0 }))
            .edition(edition?.applyValue({ args0 -> args0 }))
            .enableSso(enableSso?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .shortName(shortName?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .vpcSettings(vpcSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DirectoryArgs].
 */
@PulumiTagMarker
public class DirectoryArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var connectSettings: Output<DirectoryConnectSettingsArgs>? = null

    private var description: Output<String>? = null

    private var desiredNumberOfDomainControllers: Output<Int>? = null

    private var edition: Output<String>? = null

    private var enableSso: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var shortName: Output<String>? = null

    private var size: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var vpcSettings: Output<DirectoryVpcSettingsArgs>? = null

    /**
     * @param value The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
     */
    @JvmName("gnemwbriddmhefno")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Connector related information about the directory. Fields documented below.
     */
    @JvmName("nnxysntrefpdmsip")
    public suspend fun connectSettings(`value`: Output<DirectoryConnectSettingsArgs>) {
        this.connectSettings = value
    }

    /**
     * @param value A textual description for the directory.
     */
    @JvmName("hsfbdyivgvulbamb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
     */
    @JvmName("hnafxtsbpxebikvf")
    public suspend fun desiredNumberOfDomainControllers(`value`: Output<Int>) {
        this.desiredNumberOfDomainControllers = value
    }

    /**
     * @param value The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
     */
    @JvmName("xowktdjtyenslnfa")
    public suspend fun edition(`value`: Output<String>) {
        this.edition = value
    }

    /**
     * @param value Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
     */
    @JvmName("magnlgvhtnbaowir")
    public suspend fun enableSso(`value`: Output<Boolean>) {
        this.enableSso = value
    }

    /**
     * @param value The fully qualified name for the directory, such as `corp.example.com`
     */
    @JvmName("mombamdeupdeuiqx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The password for the directory administrator or connector user.
     */
    @JvmName("servuggwixclojtx")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The short name of the directory, such as `CORP`.
     */
    @JvmName("uyuawebkjeutylso")
    public suspend fun shortName(`value`: Output<String>) {
        this.shortName = value
    }

    /**
     * @param value (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
     */
    @JvmName("jonuvqibcgxosvgj")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ddgoncesrqxpswtl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
     */
    @JvmName("fktemavdcgpfxwhm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value VPC related information about the directory. Fields documented below.
     */
    @JvmName("pftpdejokpmhruby")
    public suspend fun vpcSettings(`value`: Output<DirectoryVpcSettingsArgs>) {
        this.vpcSettings = value
    }

    /**
     * @param value The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
     */
    @JvmName("qkvupmqsbikfwlnc")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Connector related information about the directory. Fields documented below.
     */
    @JvmName("alvutvfgnugkouqn")
    public suspend fun connectSettings(`value`: DirectoryConnectSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectSettings = mapped
    }

    /**
     * @param argument Connector related information about the directory. Fields documented below.
     */
    @JvmName("ukgunsvydckjrqfs")
    public suspend fun connectSettings(argument: suspend DirectoryConnectSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryConnectSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectSettings = mapped
    }

    /**
     * @param value A textual description for the directory.
     */
    @JvmName("kjptsrfxvxdewquo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
     */
    @JvmName("hnahtmljickbjstm")
    public suspend fun desiredNumberOfDomainControllers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredNumberOfDomainControllers = mapped
    }

    /**
     * @param value The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
     */
    @JvmName("lbdhqrjnfsuwtqcu")
    public suspend fun edition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
     */
    @JvmName("uirjyviygvkyyuco")
    public suspend fun enableSso(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSso = mapped
    }

    /**
     * @param value The fully qualified name for the directory, such as `corp.example.com`
     */
    @JvmName("jevlabytkvbbhbei")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The password for the directory administrator or connector user.
     */
    @JvmName("wjegvtxdleotmomg")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The short name of the directory, such as `CORP`.
     */
    @JvmName("hdikdhnrkfpexeic")
    public suspend fun shortName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shortName = mapped
    }

    /**
     * @param value (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
     */
    @JvmName("sonnakhpfnwvxcer")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pohnjrkdxagihvxj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qbfpmsmhxugferax")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
     */
    @JvmName("nmwkttfxlvcklfvg")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value VPC related information about the directory. Fields documented below.
     */
    @JvmName("qsloihuuetcxpinp")
    public suspend fun vpcSettings(`value`: DirectoryVpcSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSettings = mapped
    }

    /**
     * @param argument VPC related information about the directory. Fields documented below.
     */
    @JvmName("odwbixjrsitmfsns")
    public suspend fun vpcSettings(argument: suspend DirectoryVpcSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryVpcSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcSettings = mapped
    }

    internal fun build(): DirectoryArgs = DirectoryArgs(
        alias = alias,
        connectSettings = connectSettings,
        description = description,
        desiredNumberOfDomainControllers = desiredNumberOfDomainControllers,
        edition = edition,
        enableSso = enableSso,
        name = name,
        password = password,
        shortName = shortName,
        size = size,
        tags = tags,
        type = type,
        vpcSettings = vpcSettings,
    )
}
