@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.DirectoryserviceFunctions.getDirectoryPlain
import com.pulumi.aws.directoryservice.kotlin.inputs.GetDirectoryPlainArgs
import com.pulumi.aws.directoryservice.kotlin.inputs.GetDirectoryPlainArgsBuilder
import com.pulumi.aws.directoryservice.kotlin.outputs.GetDirectoryResult
import com.pulumi.aws.directoryservice.kotlin.outputs.GetDirectoryResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

public object DirectoryserviceFunctions {
    /**
     * Get attributes of AWS Directory Service directory (SimpleAD, Managed AD, AD Connector). It's especially useful to refer AWS Managed AD or on-premise AD in AD Connector configuration.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.directoryservice.getDirectory({
     *     directoryId: main.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.directoryservice.get_directory(directory_id=main["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.DirectoryService.GetDirectory.Invoke(new()
     *     {
     *         DirectoryId = main.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := directoryservice.LookupDirectory(ctx, &directoryservice.LookupDirectoryArgs{
     * 			DirectoryId: main.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.directoryservice.DirectoryserviceFunctions;
     * import com.pulumi.aws.directoryservice.inputs.GetDirectoryArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DirectoryserviceFunctions.getDirectory(GetDirectoryArgs.builder()
     *             .directoryId(main.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:directoryservice:getDirectory
     *       Arguments:
     *         directoryId: ${main.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDirectory.
     * @return A collection of values returned by getDirectory.
     */
    public suspend fun getDirectory(argument: GetDirectoryPlainArgs): GetDirectoryResult =
        toKotlin(getDirectoryPlain(argument.toJava()).await())

    /**
     * @see [getDirectory].
     * @param directoryId ID of the directory.
     * @param tags A map of tags assigned to the directory/connector.
     * @return A collection of values returned by getDirectory.
     */
    public suspend fun getDirectory(directoryId: String, tags: Map<String, String>? = null): GetDirectoryResult {
        val argument = GetDirectoryPlainArgs(
            directoryId = directoryId,
            tags = tags,
        )
        return toKotlin(getDirectoryPlain(argument.toJava()).await())
    }

    /**
     * @see [getDirectory].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;directoryservice&#46;kotlin&#46;inputs&#46;GetDirectoryPlainArgs].
     * @return A collection of values returned by getDirectory.
     */
    public suspend fun getDirectory(argument: suspend GetDirectoryPlainArgsBuilder.() -> Unit): GetDirectoryResult {
        val builder = GetDirectoryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getDirectoryPlain(builtArgument.toJava()).await())
    }
}
