@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.RadiusSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a directory's multi-factor authentication (MFA) using a Remote Authentication Dial In User Service (RADIUS) server.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directoryservice.RadiusSettings("example", {
 *     directoryId: exampleAwsDirectoryServiceDirectory.id,
 *     authenticationProtocol: "PAP",
 *     displayLabel: "example",
 *     radiusPort: 1812,
 *     radiusRetries: 4,
 *     radiusServers: ["10&#46;0&#46;1&#46;5"],
 *     radiusTimeout: 1,
 *     sharedSecret: "12345678",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directoryservice.RadiusSettings("example",
 *     directory_id=example_aws_directory_service_directory["id"],
 *     authentication_protocol="PAP",
 *     display_label="example",
 *     radius_port=1812,
 *     radius_retries=4,
 *     radius_servers=["10&#46;0&#46;1&#46;5"],
 *     radius_timeout=1,
 *     shared_secret="12345678")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectoryService.RadiusSettings("example", new()
 *     {
 *         DirectoryId = exampleAwsDirectoryServiceDirectory.Id,
 *         AuthenticationProtocol = "PAP",
 *         DisplayLabel = "example",
 *         RadiusPort = 1812,
 *         RadiusRetries = 4,
 *         RadiusServers = new[]
 *         {
 *             "10.0.1.5",
 *         },
 *         RadiusTimeout = 1,
 *         SharedSecret = "12345678",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directoryservice.NewRadiusSettings(ctx, "example", &directoryservice.RadiusSettingsArgs{
 * 			DirectoryId:            pulumi.Any(exampleAwsDirectoryServiceDirectory.Id),
 * 			AuthenticationProtocol: pulumi.String("PAP"),
 * 			DisplayLabel:           pulumi.String("example"),
 * 			RadiusPort:             pulumi.Int(1812),
 * 			RadiusRetries:          pulumi.Int(4),
 * 			RadiusServers: pulumi.StringArray{
 * 				pulumi.String("10.0.1.5"),
 * 			},
 * 			RadiusTimeout: pulumi.Int(1),
 * 			SharedSecret:  pulumi.String("12345678"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.RadiusSettings;
 * import com.pulumi.aws.directoryservice.RadiusSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RadiusSettings("example", RadiusSettingsArgs.builder()
 *             .directoryId(exampleAwsDirectoryServiceDirectory.id())
 *             .authenticationProtocol("PAP")
 *             .displayLabel("example")
 *             .radiusPort(1812)
 *             .radiusRetries(4)
 *             .radiusServers("10.0.1.5")
 *             .radiusTimeout(1)
 *             .sharedSecret("12345678")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directoryservice:RadiusSettings
 *     properties:
 *       directoryId: ${exampleAwsDirectoryServiceDirectory.id}
 *       authenticationProtocol: PAP
 *       displayLabel: example
 *       radiusPort: 1812
 *       radiusRetries: 4
 *       radiusServers:
 *         - 10.0.1.5
 *       radiusTimeout: 1
 *       sharedSecret: '12345678'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import RADIUS settings using the directory ID. For example:
 * ```sh
 * $ pulumi import aws:directoryservice/radiusSettings:RadiusSettings example d-926724cf57
 * ```
 * @property authenticationProtocol The protocol specified for your RADIUS endpoints. Valid values: `PAP`, `CHAP`, `MS-CHAPv1`, `MS-CHAPv2`.
 * @property directoryId The identifier of the directory for which you want to manager RADIUS settings.
 * @property displayLabel Display label.
 * @property radiusPort The port that your RADIUS server is using for communications. Your self-managed network must allow inbound traffic over this port from the AWS Directory Service servers.
 * @property radiusRetries The maximum number of times that communication with the RADIUS server is attempted. Minimum value of `0`. Maximum value of `10`.
 * @property radiusServers An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
 * @property radiusTimeout The amount of time, in seconds, to wait for the RADIUS server to respond. Minimum value of `1`. Maximum value of `50`.
 * @property sharedSecret Required for enabling RADIUS on the directory.
 * @property useSameUsername Not currently used.
 */
public data class RadiusSettingsArgs(
    public val authenticationProtocol: Output<String>? = null,
    public val directoryId: Output<String>? = null,
    public val displayLabel: Output<String>? = null,
    public val radiusPort: Output<Int>? = null,
    public val radiusRetries: Output<Int>? = null,
    public val radiusServers: Output<List<String>>? = null,
    public val radiusTimeout: Output<Int>? = null,
    public val sharedSecret: Output<String>? = null,
    public val useSameUsername: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.RadiusSettingsArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.RadiusSettingsArgs =
        com.pulumi.aws.directoryservice.RadiusSettingsArgs.builder()
            .authenticationProtocol(authenticationProtocol?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .displayLabel(displayLabel?.applyValue({ args0 -> args0 }))
            .radiusPort(radiusPort?.applyValue({ args0 -> args0 }))
            .radiusRetries(radiusRetries?.applyValue({ args0 -> args0 }))
            .radiusServers(radiusServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .radiusTimeout(radiusTimeout?.applyValue({ args0 -> args0 }))
            .sharedSecret(sharedSecret?.applyValue({ args0 -> args0 }))
            .useSameUsername(useSameUsername?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RadiusSettingsArgs].
 */
@PulumiTagMarker
public class RadiusSettingsArgsBuilder internal constructor() {
    private var authenticationProtocol: Output<String>? = null

    private var directoryId: Output<String>? = null

    private var displayLabel: Output<String>? = null

    private var radiusPort: Output<Int>? = null

    private var radiusRetries: Output<Int>? = null

    private var radiusServers: Output<List<String>>? = null

    private var radiusTimeout: Output<Int>? = null

    private var sharedSecret: Output<String>? = null

    private var useSameUsername: Output<Boolean>? = null

    /**
     * @param value The protocol specified for your RADIUS endpoints. Valid values: `PAP`, `CHAP`, `MS-CHAPv1`, `MS-CHAPv2`.
     */
    @JvmName("qpqmbybibkwuakkf")
    public suspend fun authenticationProtocol(`value`: Output<String>) {
        this.authenticationProtocol = value
    }

    /**
     * @param value The identifier of the directory for which you want to manager RADIUS settings.
     */
    @JvmName("byavnqccswsdvlie")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value Display label.
     */
    @JvmName("bxrrprddqkqcaait")
    public suspend fun displayLabel(`value`: Output<String>) {
        this.displayLabel = value
    }

    /**
     * @param value The port that your RADIUS server is using for communications. Your self-managed network must allow inbound traffic over this port from the AWS Directory Service servers.
     */
    @JvmName("dptpsrphjphbfrcj")
    public suspend fun radiusPort(`value`: Output<Int>) {
        this.radiusPort = value
    }

    /**
     * @param value The maximum number of times that communication with the RADIUS server is attempted. Minimum value of `0`. Maximum value of `10`.
     */
    @JvmName("mwbivdvfcuqfvsik")
    public suspend fun radiusRetries(`value`: Output<Int>) {
        this.radiusRetries = value
    }

    /**
     * @param value An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
     */
    @JvmName("knyqhsbnwxedaqql")
    public suspend fun radiusServers(`value`: Output<List<String>>) {
        this.radiusServers = value
    }

    @JvmName("mlbriiixhnbtbius")
    public suspend fun radiusServers(vararg values: Output<String>) {
        this.radiusServers = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
     */
    @JvmName("wcvoxlbrydjkdktr")
    public suspend fun radiusServers(values: List<Output<String>>) {
        this.radiusServers = Output.all(values)
    }

    /**
     * @param value The amount of time, in seconds, to wait for the RADIUS server to respond. Minimum value of `1`. Maximum value of `50`.
     */
    @JvmName("klwvgxogfcursxnn")
    public suspend fun radiusTimeout(`value`: Output<Int>) {
        this.radiusTimeout = value
    }

    /**
     * @param value Required for enabling RADIUS on the directory.
     */
    @JvmName("qikoxvbuxlyjiggb")
    public suspend fun sharedSecret(`value`: Output<String>) {
        this.sharedSecret = value
    }

    /**
     * @param value Not currently used.
     */
    @JvmName("rwfmmjhhxfsdylkv")
    public suspend fun useSameUsername(`value`: Output<Boolean>) {
        this.useSameUsername = value
    }

    /**
     * @param value The protocol specified for your RADIUS endpoints. Valid values: `PAP`, `CHAP`, `MS-CHAPv1`, `MS-CHAPv2`.
     */
    @JvmName("yieqpmtfcfscwsgq")
    public suspend fun authenticationProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationProtocol = mapped
    }

    /**
     * @param value The identifier of the directory for which you want to manager RADIUS settings.
     */
    @JvmName("eaopwwbafmkqkcts")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value Display label.
     */
    @JvmName("igcdmwwbufgmetwn")
    public suspend fun displayLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayLabel = mapped
    }

    /**
     * @param value The port that your RADIUS server is using for communications. Your self-managed network must allow inbound traffic over this port from the AWS Directory Service servers.
     */
    @JvmName("vdmmnxccsldcxvip")
    public suspend fun radiusPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusPort = mapped
    }

    /**
     * @param value The maximum number of times that communication with the RADIUS server is attempted. Minimum value of `0`. Maximum value of `10`.
     */
    @JvmName("xobmtfjhlflyabyv")
    public suspend fun radiusRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusRetries = mapped
    }

    /**
     * @param value An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
     */
    @JvmName("bhbscmgpjpebedvi")
    public suspend fun radiusServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param values An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
     */
    @JvmName("esqxegsembofiljr")
    public suspend fun radiusServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param value The amount of time, in seconds, to wait for the RADIUS server to respond. Minimum value of `1`. Maximum value of `50`.
     */
    @JvmName("upiuhoyxbgiwfqfh")
    public suspend fun radiusTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusTimeout = mapped
    }

    /**
     * @param value Required for enabling RADIUS on the directory.
     */
    @JvmName("gjcrahibopxdgmkv")
    public suspend fun sharedSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedSecret = mapped
    }

    /**
     * @param value Not currently used.
     */
    @JvmName("jlureltwoekrgkxm")
    public suspend fun useSameUsername(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSameUsername = mapped
    }

    internal fun build(): RadiusSettingsArgs = RadiusSettingsArgs(
        authenticationProtocol = authenticationProtocol,
        directoryId = directoryId,
        displayLabel = displayLabel,
        radiusPort = radiusPort,
        radiusRetries = radiusRetries,
        radiusServers = radiusServers,
        radiusTimeout = radiusTimeout,
        sharedSecret = sharedSecret,
        useSameUsername = useSameUsername,
    )
}
