@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.kotlin.outputs.ServiceRegionVpcSettings
import com.pulumi.aws.directoryservice.kotlin.outputs.ServiceRegionVpcSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServiceRegion].
 */
@PulumiTagMarker
public class ServiceRegionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceRegionArgs = ServiceRegionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceRegionArgsBuilder.() -> Unit) {
        val builder = ServiceRegionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceRegion {
        val builtJavaResource = com.pulumi.aws.directoryservice.ServiceRegion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceRegion(builtJavaResource)
    }
}

/**
 * Manages a replicated Region and directory for Multi-Region replication.
 * Multi-Region replication is only supported for the Enterprise Edition of AWS Managed Microsoft AD.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = aws.getRegion({});
 * const available = aws.getAvailabilityZones({
 *     state: "available",
 *     filters: [{
 *         name: "opt-in-status",
 *         values: ["opt-in-not-required"],
 *     }],
 * });
 * const exampleVpc = new aws.ec2.Vpc("example", {
 *     cidrBlock: "10.0.0.0/16",
 *     tags: {
 *         Name: "Primary",
 *     },
 * });
 * const exampleSubnet: aws.ec2.Subnet[] = [];
 * for (const range = {value: 0}; range.value < 2; range.value++) {
 *     exampleSubnet.push(new aws.ec2.Subnet(`example-${range.value}`, {
 *         vpcId: exampleVpc.id,
 *         availabilityZone: available.then(available => available.names[range&#46;value]),
 *         cidrBlock: exampleVpc.cidrBlock.apply(cidrBlock => std.cidrsubnetOutput({
 *             input: cidrBlock,
 *             newbits: 8,
 *             netnum: range.value,
 *         })).apply(invoke => invoke.result),
 *         tags: {
 *             Name: "Primary",
 *         },
 *     }));
 * }
 * const exampleDirectory = new aws.directoryservice.Directory("example", {
 *     name: "example.com",
 *     password: "SuperSecretPassw0rd",
 *     type: "MicrosoftAD",
 *     vpcSettings: {
 *         vpcId: exampleVpc.id,
 *         subnetIds: exampleSubnet.map(__item => __item.id),
 *     },
 * });
 * const available-secondary = aws.getAvailabilityZones({
 *     state: "available",
 *     filters: [{
 *         name: "opt-in-status",
 *         values: ["opt-in-not-required"],
 *     }],
 * });
 * const example_secondary = new aws.ec2.Vpc("example-secondary", {
 *     cidrBlock: "10.1.0.0/16",
 *     tags: {
 *         Name: "Secondary",
 *     },
 * });
 * const example_secondarySubnet: aws.ec2.Subnet[] = [];
 * for (const range = {value: 0}; range.value < 2; range.value++) {
 *     example_secondarySubnet.push(new aws.ec2.Subnet(`example-secondary-${range.value}`, {
 *         vpcId: example_secondary.id,
 *         availabilityZone: available_secondary.then(available_secondary => available_secondary.names[range&#46;value]),
 *         cidrBlock: example_secondary.cidrBlock.apply(cidrBlock => std.cidrsubnetOutput({
 *             input: cidrBlock,
 *             newbits: 8,
 *             netnum: range.value,
 *         })).apply(invoke => invoke.result),
 *         tags: {
 *             Name: "Secondary",
 *         },
 *     }));
 * }
 * const exampleServiceRegion = new aws.directoryservice.ServiceRegion("example", {
 *     directoryId: exampleDirectory.id,
 *     regionName: example.then(example => example.name),
 *     vpcSettings: {
 *         vpcId: example_secondary.id,
 *         subnetIds: example_secondarySubnet.map(__item => __item.id),
 *     },
 *     tags: {
 *         Name: "Secondary",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.get_region()
 * available = aws.get_availability_zones(state="available",
 *     filters=[{
 *         "name": "opt-in-status",
 *         "values": ["opt-in-not-required"],
 *     }])
 * example_vpc = aws.ec2.Vpc("example",
 *     cidr_block="10.0.0.0/16",
 *     tags={
 *         "Name": "Primary",
 *     })
 * example_subnet = []
 * for range in [{"value": i} for i in range(0, 2)]:
 *     example_subnet.append(aws.ec2.Subnet(f"example-{range['value']}",
 *         vpc_id=example_vpc.id,
 *         availability_zone=available.names[range["value"]],
 *         cidr_block=example_vpc.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
 *             newbits=8,
 *             netnum=range["value"])).apply(lambda invoke: invoke.result),
 *         tags={
 *             "Name": "Primary",
 *         }))
 * example_directory = aws.directoryservice.Directory("example",
 *     name="example.com",
 *     password="SuperSecretPassw0rd",
 *     type="MicrosoftAD",
 *     vpc_settings={
 *         "vpc_id": example_vpc.id,
 *         "subnet_ids": [__item&#46;id for __item in example_subnet],
 *     })
 * available_secondary = aws.get_availability_zones(state="available",
 *     filters=[{
 *         "name": "opt-in-status",
 *         "values": ["opt-in-not-required"],
 *     }])
 * example_secondary = aws.ec2.Vpc("example-secondary",
 *     cidr_block="10.1.0.0/16",
 *     tags={
 *         "Name": "Secondary",
 *     })
 * example_secondary_subnet = []
 * for range in [{"value": i} for i in range(0, 2)]:
 *     example_secondary_subnet.append(aws.ec2.Subnet(f"example-secondary-{range['value']}",
 *         vpc_id=example_secondary.id,
 *         availability_zone=available_secondary.names[range["value"]],
 *         cidr_block=example_secondary.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
 *             newbits=8,
 *             netnum=range["value"])).apply(lambda invoke: invoke.result),
 *         tags={
 *             "Name": "Secondary",
 *         }))
 * example_service_region = aws.directoryservice.ServiceRegion("example",
 *     directory_id=example_directory.id,
 *     region_name=example.name,
 *     vpc_settings={
 *         "vpc_id": example_secondary.id,
 *         "subnet_ids": [__item&#46;id for __item in example_secondary_subnet],
 *     },
 *     tags={
 *         "Name": "Secondary",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.GetRegion.Invoke();
 *     var available = Aws.GetAvailabilityZones.Invoke(new()
 *     {
 *         State = "available",
 *         Filters = new[]
 *         {
 *             new Aws.Inputs.GetAvailabilityZonesFilterInputArgs
 *             {
 *                 Name = "opt-in-status",
 *                 Values = new[]
 *                 {
 *                     "opt-in-not-required",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleVpc = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *         Tags =
 *         {
 *             { "Name", "Primary" },
 *         },
 *     });
 *     var exampleSubnet = new List<Aws.Ec2.Subnet>();
 *     for (var rangeIndex = 0; rangeIndex < 2; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         exampleSubnet.Add(new Aws.Ec2.Subnet($"example-{range.Value}", new()
 *         {
 *             VpcId = exampleVpc.Id,
 *             AvailabilityZone = available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names)[range&#46;Value],
 *             CidrBlock = exampleVpc.CidrBlock.Apply(cidrBlock => Std.Cidrsubnet.Invoke(new()
 *             {
 *                 Input = cidrBlock,
 *                 Newbits = 8,
 *                 Netnum = range.Value,
 *             })).Apply(invoke => invoke.Result),
 *             Tags =
 *             {
 *                 { "Name", "Primary" },
 *             },
 *         }));
 *     }
 *     var exampleDirectory = new Aws.DirectoryService.Directory("example", new()
 *     {
 *         Name = "example.com",
 *         Password = "SuperSecretPassw0rd",
 *         Type = "MicrosoftAD",
 *         VpcSettings = new Aws.DirectoryService.Inputs.DirectoryVpcSettingsArgs
 *         {
 *             VpcId = exampleVpc.Id,
 *             SubnetIds = exampleSubnet.Select(__item => __item.Id).ToList(),
 *         },
 *     });
 *     var available_secondary = Aws.GetAvailabilityZones.Invoke(new()
 *     {
 *         State = "available",
 *         Filters = new[]
 *         {
 *             new Aws.Inputs.GetAvailabilityZonesFilterInputArgs
 *             {
 *                 Name = "opt-in-status",
 *                 Values = new[]
 *                 {
 *                     "opt-in-not-required",
 *                 },
 *             },
 *         },
 *     });
 *     var example_secondary = new Aws.Ec2.Vpc("example-secondary", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *         Tags =
 *         {
 *             { "Name", "Secondary" },
 *         },
 *     });
 *     var example_secondarySubnet = new List<Aws.Ec2.Subnet>();
 *     for (var rangeIndex = 0; rangeIndex < 2; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         example_secondarySubnet.Add(new Aws.Ec2.Subnet($"example-secondary-{range.Value}", new()
 *         {
 *             VpcId = example_secondary.Id,
 *             AvailabilityZone = available_secondary.Apply(available_secondary => available_secondary.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names)[range&#46;Value]),
 *             CidrBlock = example_secondary.CidrBlock.Apply(cidrBlock => Std.Cidrsubnet.Invoke(new()
 *             {
 *                 Input = cidrBlock,
 *                 Newbits = 8,
 *                 Netnum = range.Value,
 *             })).Apply(invoke => invoke.Result),
 *             Tags =
 *             {
 *                 { "Name", "Secondary" },
 *             },
 *         }));
 *     }
 *     var exampleServiceRegion = new Aws.DirectoryService.ServiceRegion("example", new()
 *     {
 *         DirectoryId = exampleDirectory.Id,
 *         RegionName = example.Apply(getRegionResult => getRegionResult.Name),
 *         VpcSettings = new Aws.DirectoryService.Inputs.ServiceRegionVpcSettingsArgs
 *         {
 *             VpcId = example_secondary.Id,
 *             SubnetIds = example_secondarySubnet.Select(__item => __item.Id).ToList(),
 *         },
 *         Tags =
 *         {
 *             { "Name", "Secondary" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * example, err := aws.GetRegion(ctx, nil, nil);
 * if err != nil {
 * return err
 * }
 * available, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
 * State: pulumi.StringRef("available"),
 * Filters: []aws.GetAvailabilityZonesFilter{
 * {
 * Name: "opt-in-status",
 * Values: []string{
 * "opt-in-not-required",
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * exampleVpc, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * CidrBlock: pulumi.String("10.0.0.0/16"),
 * Tags: pulumi.StringMap{
 * "Name": pulumi.String("Primary"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * var exampleSubnet []*ec2.Subnet
 * for index := 0; index < 2; index++ {
 *     key0 := index
 *     val0 := index
 * __res, err := ec2.NewSubnet(ctx, fmt.Sprintf("example-%v", key0), &ec2.SubnetArgs{
 * VpcId: exampleVpc.ID(),
 * AvailabilityZone: pulumi.String(available.Names[val0]),
 * CidrBlock: pulumi.String(exampleVpc.CidrBlock.ApplyT(func(cidrBlock string) (std.CidrsubnetResult, error) {
 * return std.CidrsubnetResult(interface{}(std.CidrsubnetOutput(ctx, std.CidrsubnetOutputArgs{
 * Input: cidrBlock,
 * Newbits: 8,
 * Netnum: val0,
 * }, nil))), nil
 * }).(std.CidrsubnetResultOutput).ApplyT(func(invoke std.CidrsubnetResult) (*string, error) {
 * return invoke.Result, nil
 * }).(pulumi.StringPtrOutput)),
 * Tags: pulumi.StringMap{
 * "Name": pulumi.String("Primary"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * exampleSubnet = append(exampleSubnet, __res)
 * }
 * exampleDirectory, err := directoryservice.NewDirectory(ctx, "example", &directoryservice.DirectoryArgs{
 * Name: pulumi.String("example.com"),
 * Password: pulumi.String("SuperSecretPassw0rd"),
 * Type: pulumi.String("MicrosoftAD"),
 * VpcSettings: &directoryservice.DirectoryVpcSettingsArgs{
 * VpcId: exampleVpc.ID(),
 * SubnetIds: %!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:44,17-36),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * available_secondary, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
 * State: pulumi.StringRef("available"),
 * Filters: []aws.GetAvailabilityZonesFilter{
 * {
 * Name: "opt-in-status",
 * Values: []string{
 * "opt-in-not-required",
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * _, err = ec2.NewVpc(ctx, "example-secondary", &ec2.VpcArgs{
 * CidrBlock: pulumi.String("10.1.0.0/16"),
 * Tags: pulumi.StringMap{
 * "Name": pulumi.String("Secondary"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * var example_secondarySubnet []*ec2.Subnet
 * for index := 0; index < 2; index++ {
 *     key0 := index
 *     val0 := index
 * __res, err := ec2.NewSubnet(ctx, fmt.Sprintf("example-secondary-%v", key0), &ec2.SubnetArgs{
 * VpcId: example_secondary.ID(),
 * AvailabilityZone: pulumi.String(available_secondary.Names[val0]),
 * CidrBlock: pulumi.String(example_secondary.CidrBlock.ApplyT(func(cidrBlock string) (std.CidrsubnetResult, error) {
 * return std.CidrsubnetResult(interface{}(std.CidrsubnetOutput(ctx, std.CidrsubnetOutputArgs{
 * Input: cidrBlock,
 * Newbits: 8,
 * Netnum: val0,
 * }, nil))), nil
 * }).(std.CidrsubnetResultOutput).ApplyT(func(invoke std.CidrsubnetResult) (*string, error) {
 * return invoke.Result, nil
 * }).(pulumi.StringPtrOutput)),
 * Tags: pulumi.StringMap{
 * "Name": pulumi.String("Secondary"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * example_secondarySubnet = append(example_secondarySubnet, __res)
 * }
 * _, err = directoryservice.NewServiceRegion(ctx, "example", &directoryservice.ServiceRegionArgs{
 * DirectoryId: exampleDirectory.ID(),
 * RegionName: pulumi.String(example.Name),
 * VpcSettings: &directoryservice.ServiceRegionVpcSettingsArgs{
 * VpcId: example_secondary.ID(),
 * SubnetIds: %!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:87,17-46),
 * },
 * Tags: pulumi.StringMap{
 * "Name": pulumi.String("Secondary"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import com.pulumi.aws.directoryservice.ServiceRegion;
 * import com.pulumi.aws.directoryservice.ServiceRegionArgs;
 * import com.pulumi.aws.directoryservice.inputs.ServiceRegionVpcSettingsArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = AwsFunctions.getRegion();
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .tags(Map.of("Name", "Primary"))
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new Subnet("exampleSubnet-" + i, SubnetArgs.builder()
 *                 .vpcId(exampleVpc.id())
 *                 .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names())[range&#46;value()])
 *                 .cidrBlock(exampleVpc.cidrBlock().applyValue(cidrBlock -> StdFunctions.cidrsubnet()).applyValue(invoke -> invoke.result()))
 *                 .tags(Map.of("Name", "Primary"))
 *                 .build());
 * }
 *         var exampleDirectory = new Directory("exampleDirectory", DirectoryArgs.builder()
 *             .name("example.com")
 *             .password("SuperSecretPassw0rd")
 *             .type("MicrosoftAD")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(exampleVpc.id())
 *                 .subnetIds(exampleSubnet.stream().map(element -> element.id()).collect(toList()))
 *                 .build())
 *             .build());
 *         final var available-secondary = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var example_secondary = new Vpc("example-secondary", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .tags(Map.of("Name", "Secondary"))
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new Subnet("example-secondarySubnet-" + i, SubnetArgs.builder()
 *                 .vpcId(example_secondary.id())
 *                 .availabilityZone(available_secondary.names()[range&#46;value()])
 *                 .cidrBlock(example_secondary.cidrBlock().applyValue(cidrBlock -> StdFunctions.cidrsubnet()).applyValue(invoke -> invoke.result()))
 *                 .tags(Map.of("Name", "Secondary"))
 *                 .build());
 * }
 *         var exampleServiceRegion = new ServiceRegion("exampleServiceRegion", ServiceRegionArgs.builder()
 *             .directoryId(exampleDirectory.id())
 *             .regionName(example.applyValue(getRegionResult -> getRegionResult.name()))
 *             .vpcSettings(ServiceRegionVpcSettingsArgs.builder()
 *                 .vpcId(example_secondary.id())
 *                 .subnetIds(example_secondarySubnet.stream().map(element -> element.id()).collect(toList()))
 *                 .build())
 *             .tags(Map.of("Name", "Secondary"))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Replicated Regions using directory ID,Region name. For example:
 * ```sh
 * $ pulumi import aws:directoryservice/serviceRegion:ServiceRegion example d-9267651497,us-east-2
 * ```
 */
public class ServiceRegion internal constructor(
    override val javaResource: com.pulumi.aws.directoryservice.ServiceRegion,
) : KotlinCustomResource(javaResource, ServiceRegionMapper) {
    /**
     * The number of domain controllers desired in the replicated directory. Minimum value of `2`.
     */
    public val desiredNumberOfDomainControllers: Output<Int>
        get() = javaResource.desiredNumberOfDomainControllers().applyValue({ args0 -> args0 })

    /**
     * The identifier of the directory to which you want to add Region replication.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * The name of the Region where you want to add domain controllers for replication.
     */
    public val regionName: Output<String>
        get() = javaResource.regionName().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * VPC information in the replicated Region. Detailed below.
     */
    public val vpcSettings: Output<ServiceRegionVpcSettings>
        get() = javaResource.vpcSettings().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object ServiceRegionMapper : ResourceMapper<ServiceRegion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directoryservice.ServiceRegion::class == javaResource::class

    override fun map(javaResource: Resource): ServiceRegion = ServiceRegion(
        javaResource as
            com.pulumi.aws.directoryservice.ServiceRegion,
    )
}

/**
 * @see [ServiceRegion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceRegion].
 */
public suspend fun serviceRegion(
    name: String,
    block: suspend ServiceRegionResourceBuilder.() -> Unit,
): ServiceRegion {
    val builder = ServiceRegionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceRegion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceRegion(name: String): ServiceRegion {
    val builder = ServiceRegionResourceBuilder()
    builder.name(name)
    return builder.build()
}
