@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Accepts a shared directory in a consumer account.
 * > **NOTE:** Destroying this resource removes the shared directory from the consumer account only.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directoryservice.SharedDirectory("example", {
 *     directoryId: exampleAwsDirectoryServiceDirectory.id,
 *     notes: "example",
 *     target: {
 *         id: receiver.accountId,
 *     },
 * });
 * const exampleSharedDirectoryAccepter = new aws.directoryservice.SharedDirectoryAccepter("example", {sharedDirectoryId: example.sharedDirectoryId});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directoryservice.SharedDirectory("example",
 *     directory_id=example_aws_directory_service_directory["id"],
 *     notes="example",
 *     target={
 *         "id": receiver["accountId"],
 *     })
 * example_shared_directory_accepter = aws.directoryservice.SharedDirectoryAccepter("example", shared_directory_id=example.shared_directory_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectoryService.SharedDirectory("example", new()
 *     {
 *         DirectoryId = exampleAwsDirectoryServiceDirectory.Id,
 *         Notes = "example",
 *         Target = new Aws.DirectoryService.Inputs.SharedDirectoryTargetArgs
 *         {
 *             Id = receiver.AccountId,
 *         },
 *     });
 *     var exampleSharedDirectoryAccepter = new Aws.DirectoryService.SharedDirectoryAccepter("example", new()
 *     {
 *         SharedDirectoryId = example.SharedDirectoryId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := directoryservice.NewSharedDirectory(ctx, "example", &directoryservice.SharedDirectoryArgs{
 * 			DirectoryId: pulumi.Any(exampleAwsDirectoryServiceDirectory.Id),
 * 			Notes:       pulumi.String("example"),
 * 			Target: &directoryservice.SharedDirectoryTargetArgs{
 * 				Id: pulumi.Any(receiver.AccountId),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewSharedDirectoryAccepter(ctx, "example", &directoryservice.SharedDirectoryAccepterArgs{
 * 			SharedDirectoryId: example.SharedDirectoryId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.SharedDirectory;
 * import com.pulumi.aws.directoryservice.SharedDirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.SharedDirectoryTargetArgs;
 * import com.pulumi.aws.directoryservice.SharedDirectoryAccepter;
 * import com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SharedDirectory("example", SharedDirectoryArgs.builder()
 *             .directoryId(exampleAwsDirectoryServiceDirectory.id())
 *             .notes("example")
 *             .target(SharedDirectoryTargetArgs.builder()
 *                 .id(receiver.accountId())
 *                 .build())
 *             .build());
 *         var exampleSharedDirectoryAccepter = new SharedDirectoryAccepter("exampleSharedDirectoryAccepter", SharedDirectoryAccepterArgs.builder()
 *             .sharedDirectoryId(example.sharedDirectoryId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directoryservice:SharedDirectory
 *     properties:
 *       directoryId: ${exampleAwsDirectoryServiceDirectory.id}
 *       notes: example
 *       target:
 *         id: ${receiver.accountId}
 *   exampleSharedDirectoryAccepter:
 *     type: aws:directoryservice:SharedDirectoryAccepter
 *     name: example
 *     properties:
 *       sharedDirectoryId: ${example.sharedDirectoryId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Directory Service Shared Directories using the shared directory ID. For example:
 * ```sh
 * $ pulumi import aws:directoryservice/sharedDirectoryAccepter:SharedDirectoryAccepter example d-9267633ece
 * ```
 * @property sharedDirectoryId Identifier of the directory that is stored in the directory consumer account that corresponds to the shared directory in the owner account.
 */
public data class SharedDirectoryAccepterArgs(
    public val sharedDirectoryId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs =
        com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs.builder()
            .sharedDirectoryId(sharedDirectoryId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SharedDirectoryAccepterArgs].
 */
@PulumiTagMarker
public class SharedDirectoryAccepterArgsBuilder internal constructor() {
    private var sharedDirectoryId: Output<String>? = null

    /**
     * @param value Identifier of the directory that is stored in the directory consumer account that corresponds to the shared directory in the owner account.
     */
    @JvmName("brovphwnwcdaagaa")
    public suspend fun sharedDirectoryId(`value`: Output<String>) {
        this.sharedDirectoryId = value
    }

    /**
     * @param value Identifier of the directory that is stored in the directory consumer account that corresponds to the shared directory in the owner account.
     */
    @JvmName("gcboqjbnyjqybrmi")
    public suspend fun sharedDirectoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedDirectoryId = mapped
    }

    internal fun build(): SharedDirectoryAccepterArgs = SharedDirectoryAccepterArgs(
        sharedDirectoryId = sharedDirectoryId,
    )
}
