@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.TrustArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a trust relationship between two Active Directory Directories.
 * The directories may either be both AWS Managed Microsoft AD domains or an AWS Managed Microsoft AD domain and a self-managed Active Directory Domain.
 * The Trust relationship must be configured on both sides of the relationship.
 * If a Trust has only been created on one side, it will be in the state `VerifyFailed`.
 * Once the second Trust is created, the first will update to the correct state.
 * ## Example Usage
 * ### Two-Way Trust
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const oneDirectory = new aws.directoryservice.Directory("one", {
 *     name: "one.example.com",
 *     type: "MicrosoftAD",
 * });
 * const twoDirectory = new aws.directoryservice.Directory("two", {
 *     name: "two.example.com",
 *     type: "MicrosoftAD",
 * });
 * const one = new aws.directoryservice.Trust("one", {
 *     directoryId: oneDirectory.id,
 *     remoteDomainName: twoDirectory.name,
 *     trustDirection: "Two-Way",
 *     trustPassword: "Some0therPassword",
 *     conditionalForwarderIpAddrs: twoDirectory.dnsIpAddresses,
 * });
 * const two = new aws.directoryservice.Trust("two", {
 *     directoryId: twoDirectory.id,
 *     remoteDomainName: oneDirectory.name,
 *     trustDirection: "Two-Way",
 *     trustPassword: "Some0therPassword",
 *     conditionalForwarderIpAddrs: oneDirectory.dnsIpAddresses,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * one_directory = aws.directoryservice.Directory("one",
 *     name="one.example.com",
 *     type="MicrosoftAD")
 * two_directory = aws.directoryservice.Directory("two",
 *     name="two.example.com",
 *     type="MicrosoftAD")
 * one = aws.directoryservice.Trust("one",
 *     directory_id=one_directory.id,
 *     remote_domain_name=two_directory.name,
 *     trust_direction="Two-Way",
 *     trust_password="Some0therPassword",
 *     conditional_forwarder_ip_addrs=two_directory.dns_ip_addresses)
 * two = aws.directoryservice.Trust("two",
 *     directory_id=two_directory.id,
 *     remote_domain_name=one_directory.name,
 *     trust_direction="Two-Way",
 *     trust_password="Some0therPassword",
 *     conditional_forwarder_ip_addrs=one_directory.dns_ip_addresses)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var oneDirectory = new Aws.DirectoryService.Directory("one", new()
 *     {
 *         Name = "one.example.com",
 *         Type = "MicrosoftAD",
 *     });
 *     var twoDirectory = new Aws.DirectoryService.Directory("two", new()
 *     {
 *         Name = "two.example.com",
 *         Type = "MicrosoftAD",
 *     });
 *     var one = new Aws.DirectoryService.Trust("one", new()
 *     {
 *         DirectoryId = oneDirectory.Id,
 *         RemoteDomainName = twoDirectory.Name,
 *         TrustDirection = "Two-Way",
 *         TrustPassword = "Some0therPassword",
 *         ConditionalForwarderIpAddrs = twoDirectory.DnsIpAddresses,
 *     });
 *     var two = new Aws.DirectoryService.Trust("two", new()
 *     {
 *         DirectoryId = twoDirectory.Id,
 *         RemoteDomainName = oneDirectory.Name,
 *         TrustDirection = "Two-Way",
 *         TrustPassword = "Some0therPassword",
 *         ConditionalForwarderIpAddrs = oneDirectory.DnsIpAddresses,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		oneDirectory, err := directoryservice.NewDirectory(ctx, "one", &directoryservice.DirectoryArgs{
 * 			Name: pulumi.String("one.example.com"),
 * 			Type: pulumi.String("MicrosoftAD"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		twoDirectory, err := directoryservice.NewDirectory(ctx, "two", &directoryservice.DirectoryArgs{
 * 			Name: pulumi.String("two.example.com"),
 * 			Type: pulumi.String("MicrosoftAD"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewTrust(ctx, "one", &directoryservice.TrustArgs{
 * 			DirectoryId:                 oneDirectory.ID(),
 * 			RemoteDomainName:            twoDirectory.Name,
 * 			TrustDirection:              pulumi.String("Two-Way"),
 * 			TrustPassword:               pulumi.String("Some0therPassword"),
 * 			ConditionalForwarderIpAddrs: twoDirectory.DnsIpAddresses,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewTrust(ctx, "two", &directoryservice.TrustArgs{
 * 			DirectoryId:                 twoDirectory.ID(),
 * 			RemoteDomainName:            oneDirectory.Name,
 * 			TrustDirection:              pulumi.String("Two-Way"),
 * 			TrustPassword:               pulumi.String("Some0therPassword"),
 * 			ConditionalForwarderIpAddrs: oneDirectory.DnsIpAddresses,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.Trust;
 * import com.pulumi.aws.directoryservice.TrustArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var oneDirectory = new Directory("oneDirectory", DirectoryArgs.builder()
 *             .name("one.example.com")
 *             .type("MicrosoftAD")
 *             .build());
 *         var twoDirectory = new Directory("twoDirectory", DirectoryArgs.builder()
 *             .name("two.example.com")
 *             .type("MicrosoftAD")
 *             .build());
 *         var one = new Trust("one", TrustArgs.builder()
 *             .directoryId(oneDirectory.id())
 *             .remoteDomainName(twoDirectory.name())
 *             .trustDirection("Two-Way")
 *             .trustPassword("Some0therPassword")
 *             .conditionalForwarderIpAddrs(twoDirectory.dnsIpAddresses())
 *             .build());
 *         var two = new Trust("two", TrustArgs.builder()
 *             .directoryId(twoDirectory.id())
 *             .remoteDomainName(oneDirectory.name())
 *             .trustDirection("Two-Way")
 *             .trustPassword("Some0therPassword")
 *             .conditionalForwarderIpAddrs(oneDirectory.dnsIpAddresses())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   one:
 *     type: aws:directoryservice:Trust
 *     properties:
 *       directoryId: ${oneDirectory.id}
 *       remoteDomainName: ${twoDirectory.name}
 *       trustDirection: Two-Way
 *       trustPassword: Some0therPassword
 *       conditionalForwarderIpAddrs: ${twoDirectory.dnsIpAddresses}
 *   two:
 *     type: aws:directoryservice:Trust
 *     properties:
 *       directoryId: ${twoDirectory.id}
 *       remoteDomainName: ${oneDirectory.name}
 *       trustDirection: Two-Way
 *       trustPassword: Some0therPassword
 *       conditionalForwarderIpAddrs: ${oneDirectory.dnsIpAddresses}
 *   oneDirectory:
 *     type: aws:directoryservice:Directory
 *     name: one
 *     properties:
 *       name: one.example.com
 *       type: MicrosoftAD
 *   twoDirectory:
 *     type: aws:directoryservice:Directory
 *     name: two
 *     properties:
 *       name: two.example.com
 *       type: MicrosoftAD
 * ```
 * <!--End PulumiCodeChooser -->
 * ### One-Way Trust
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const oneDirectory = new aws.directoryservice.Directory("one", {
 *     name: "one.example.com",
 *     type: "MicrosoftAD",
 * });
 * const twoDirectory = new aws.directoryservice.Directory("two", {
 *     name: "two.example.com",
 *     type: "MicrosoftAD",
 * });
 * const one = new aws.directoryservice.Trust("one", {
 *     directoryId: oneDirectory.id,
 *     remoteDomainName: twoDirectory.name,
 *     trustDirection: "One-Way: Incoming",
 *     trustPassword: "Some0therPassword",
 *     conditionalForwarderIpAddrs: twoDirectory.dnsIpAddresses,
 * });
 * const two = new aws.directoryservice.Trust("two", {
 *     directoryId: twoDirectory.id,
 *     remoteDomainName: oneDirectory.name,
 *     trustDirection: "One-Way: Outgoing",
 *     trustPassword: "Some0therPassword",
 *     conditionalForwarderIpAddrs: oneDirectory.dnsIpAddresses,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * one_directory = aws.directoryservice.Directory("one",
 *     name="one.example.com",
 *     type="MicrosoftAD")
 * two_directory = aws.directoryservice.Directory("two",
 *     name="two.example.com",
 *     type="MicrosoftAD")
 * one = aws.directoryservice.Trust("one",
 *     directory_id=one_directory.id,
 *     remote_domain_name=two_directory.name,
 *     trust_direction="One-Way: Incoming",
 *     trust_password="Some0therPassword",
 *     conditional_forwarder_ip_addrs=two_directory.dns_ip_addresses)
 * two = aws.directoryservice.Trust("two",
 *     directory_id=two_directory.id,
 *     remote_domain_name=one_directory.name,
 *     trust_direction="One-Way: Outgoing",
 *     trust_password="Some0therPassword",
 *     conditional_forwarder_ip_addrs=one_directory.dns_ip_addresses)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var oneDirectory = new Aws.DirectoryService.Directory("one", new()
 *     {
 *         Name = "one.example.com",
 *         Type = "MicrosoftAD",
 *     });
 *     var twoDirectory = new Aws.DirectoryService.Directory("two", new()
 *     {
 *         Name = "two.example.com",
 *         Type = "MicrosoftAD",
 *     });
 *     var one = new Aws.DirectoryService.Trust("one", new()
 *     {
 *         DirectoryId = oneDirectory.Id,
 *         RemoteDomainName = twoDirectory.Name,
 *         TrustDirection = "One-Way: Incoming",
 *         TrustPassword = "Some0therPassword",
 *         ConditionalForwarderIpAddrs = twoDirectory.DnsIpAddresses,
 *     });
 *     var two = new Aws.DirectoryService.Trust("two", new()
 *     {
 *         DirectoryId = twoDirectory.Id,
 *         RemoteDomainName = oneDirectory.Name,
 *         TrustDirection = "One-Way: Outgoing",
 *         TrustPassword = "Some0therPassword",
 *         ConditionalForwarderIpAddrs = oneDirectory.DnsIpAddresses,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		oneDirectory, err := directoryservice.NewDirectory(ctx, "one", &directoryservice.DirectoryArgs{
 * 			Name: pulumi.String("one.example.com"),
 * 			Type: pulumi.String("MicrosoftAD"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		twoDirectory, err := directoryservice.NewDirectory(ctx, "two", &directoryservice.DirectoryArgs{
 * 			Name: pulumi.String("two.example.com"),
 * 			Type: pulumi.String("MicrosoftAD"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewTrust(ctx, "one", &directoryservice.TrustArgs{
 * 			DirectoryId:                 oneDirectory.ID(),
 * 			RemoteDomainName:            twoDirectory.Name,
 * 			TrustDirection:              pulumi.String("One-Way: Incoming"),
 * 			TrustPassword:               pulumi.String("Some0therPassword"),
 * 			ConditionalForwarderIpAddrs: twoDirectory.DnsIpAddresses,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directoryservice.NewTrust(ctx, "two", &directoryservice.TrustArgs{
 * 			DirectoryId:                 twoDirectory.ID(),
 * 			RemoteDomainName:            oneDirectory.Name,
 * 			TrustDirection:              pulumi.String("One-Way: Outgoing"),
 * 			TrustPassword:               pulumi.String("Some0therPassword"),
 * 			ConditionalForwarderIpAddrs: oneDirectory.DnsIpAddresses,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.Trust;
 * import com.pulumi.aws.directoryservice.TrustArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var oneDirectory = new Directory("oneDirectory", DirectoryArgs.builder()
 *             .name("one.example.com")
 *             .type("MicrosoftAD")
 *             .build());
 *         var twoDirectory = new Directory("twoDirectory", DirectoryArgs.builder()
 *             .name("two.example.com")
 *             .type("MicrosoftAD")
 *             .build());
 *         var one = new Trust("one", TrustArgs.builder()
 *             .directoryId(oneDirectory.id())
 *             .remoteDomainName(twoDirectory.name())
 *             .trustDirection("One-Way: Incoming")
 *             .trustPassword("Some0therPassword")
 *             .conditionalForwarderIpAddrs(twoDirectory.dnsIpAddresses())
 *             .build());
 *         var two = new Trust("two", TrustArgs.builder()
 *             .directoryId(twoDirectory.id())
 *             .remoteDomainName(oneDirectory.name())
 *             .trustDirection("One-Way: Outgoing")
 *             .trustPassword("Some0therPassword")
 *             .conditionalForwarderIpAddrs(oneDirectory.dnsIpAddresses())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   one:
 *     type: aws:directoryservice:Trust
 *     properties:
 *       directoryId: ${oneDirectory.id}
 *       remoteDomainName: ${twoDirectory.name}
 *       trustDirection: 'One-Way: Incoming'
 *       trustPassword: Some0therPassword
 *       conditionalForwarderIpAddrs: ${twoDirectory.dnsIpAddresses}
 *   two:
 *     type: aws:directoryservice:Trust
 *     properties:
 *       directoryId: ${twoDirectory.id}
 *       remoteDomainName: ${oneDirectory.name}
 *       trustDirection: 'One-Way: Outgoing'
 *       trustPassword: Some0therPassword
 *       conditionalForwarderIpAddrs: ${oneDirectory.dnsIpAddresses}
 *   oneDirectory:
 *     type: aws:directoryservice:Directory
 *     name: one
 *     properties:
 *       name: one.example.com
 *       type: MicrosoftAD
 *   twoDirectory:
 *     type: aws:directoryservice:Directory
 *     name: two
 *     properties:
 *       name: two.example.com
 *       type: MicrosoftAD
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the Trust relationship using the directory ID and remote domain name, separated by a `/`. For example:
 * ```sh
 * $ pulumi import aws:directoryservice/trust:Trust example d-926724cf57/directory.example.com
 * ```
 * @property conditionalForwarderIpAddrs Set of IPv4 addresses for the DNS server associated with the remote Directory.
 * Can contain between 1 and 4 values.
 * @property deleteAssociatedConditionalForwarder Whether to delete the conditional forwarder when deleting the Trust relationship.
 * @property directoryId ID of the Directory.
 * @property remoteDomainName Fully qualified domain name of the remote Directory.
 * @property selectiveAuth Whether to enable selective authentication.
 * Valid values are `Enabled` and `Disabled`.
 * Default value is `Disabled`.
 * @property trustDirection The direction of the Trust relationship.
 * Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
 * @property trustPassword Password for the Trust.
 * Does not need to match the passwords for either Directory.
 * Can contain upper- and lower-case letters, numbers, and punctuation characters.
 * May be up to 128 characters long.
 * @property trustType Type of the Trust relationship.
 * Valid values are `Forest` and `External`.
 * Default value is `Forest`.
 */
public data class TrustArgs(
    public val conditionalForwarderIpAddrs: Output<List<String>>? = null,
    public val deleteAssociatedConditionalForwarder: Output<Boolean>? = null,
    public val directoryId: Output<String>? = null,
    public val remoteDomainName: Output<String>? = null,
    public val selectiveAuth: Output<String>? = null,
    public val trustDirection: Output<String>? = null,
    public val trustPassword: Output<String>? = null,
    public val trustType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.TrustArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.TrustArgs =
        com.pulumi.aws.directoryservice.TrustArgs.builder()
            .conditionalForwarderIpAddrs(
                conditionalForwarderIpAddrs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .deleteAssociatedConditionalForwarder(
                deleteAssociatedConditionalForwarder?.applyValue({ args0 ->
                    args0
                }),
            )
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .remoteDomainName(remoteDomainName?.applyValue({ args0 -> args0 }))
            .selectiveAuth(selectiveAuth?.applyValue({ args0 -> args0 }))
            .trustDirection(trustDirection?.applyValue({ args0 -> args0 }))
            .trustPassword(trustPassword?.applyValue({ args0 -> args0 }))
            .trustType(trustType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustArgs].
 */
@PulumiTagMarker
public class TrustArgsBuilder internal constructor() {
    private var conditionalForwarderIpAddrs: Output<List<String>>? = null

    private var deleteAssociatedConditionalForwarder: Output<Boolean>? = null

    private var directoryId: Output<String>? = null

    private var remoteDomainName: Output<String>? = null

    private var selectiveAuth: Output<String>? = null

    private var trustDirection: Output<String>? = null

    private var trustPassword: Output<String>? = null

    private var trustType: Output<String>? = null

    /**
     * @param value Set of IPv4 addresses for the DNS server associated with the remote Directory.
     * Can contain between 1 and 4 values.
     */
    @JvmName("iktixkpbkvnfoqqv")
    public suspend fun conditionalForwarderIpAddrs(`value`: Output<List<String>>) {
        this.conditionalForwarderIpAddrs = value
    }

    @JvmName("xcomdwmlidyjripm")
    public suspend fun conditionalForwarderIpAddrs(vararg values: Output<String>) {
        this.conditionalForwarderIpAddrs = Output.all(values.asList())
    }

    /**
     * @param values Set of IPv4 addresses for the DNS server associated with the remote Directory.
     * Can contain between 1 and 4 values.
     */
    @JvmName("mcrsoggbeefovawp")
    public suspend fun conditionalForwarderIpAddrs(values: List<Output<String>>) {
        this.conditionalForwarderIpAddrs = Output.all(values)
    }

    /**
     * @param value Whether to delete the conditional forwarder when deleting the Trust relationship.
     */
    @JvmName("vimnbvvjbikanuop")
    public suspend fun deleteAssociatedConditionalForwarder(`value`: Output<Boolean>) {
        this.deleteAssociatedConditionalForwarder = value
    }

    /**
     * @param value ID of the Directory.
     */
    @JvmName("nkabiunftwytqqdx")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value Fully qualified domain name of the remote Directory.
     */
    @JvmName("pllsltftttxrgmat")
    public suspend fun remoteDomainName(`value`: Output<String>) {
        this.remoteDomainName = value
    }

    /**
     * @param value Whether to enable selective authentication.
     * Valid values are `Enabled` and `Disabled`.
     * Default value is `Disabled`.
     */
    @JvmName("goelblyltwdcerfi")
    public suspend fun selectiveAuth(`value`: Output<String>) {
        this.selectiveAuth = value
    }

    /**
     * @param value The direction of the Trust relationship.
     * Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
     */
    @JvmName("rsdndgtedkbvnwgp")
    public suspend fun trustDirection(`value`: Output<String>) {
        this.trustDirection = value
    }

    /**
     * @param value Password for the Trust.
     * Does not need to match the passwords for either Directory.
     * Can contain upper- and lower-case letters, numbers, and punctuation characters.
     * May be up to 128 characters long.
     */
    @JvmName("tugjwnfkbcbbatym")
    public suspend fun trustPassword(`value`: Output<String>) {
        this.trustPassword = value
    }

    /**
     * @param value Type of the Trust relationship.
     * Valid values are `Forest` and `External`.
     * Default value is `Forest`.
     */
    @JvmName("fhqqlniwwrjniqxq")
    public suspend fun trustType(`value`: Output<String>) {
        this.trustType = value
    }

    /**
     * @param value Set of IPv4 addresses for the DNS server associated with the remote Directory.
     * Can contain between 1 and 4 values.
     */
    @JvmName("kodeeoimriakekod")
    public suspend fun conditionalForwarderIpAddrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditionalForwarderIpAddrs = mapped
    }

    /**
     * @param values Set of IPv4 addresses for the DNS server associated with the remote Directory.
     * Can contain between 1 and 4 values.
     */
    @JvmName("aswkypuipvchrbqy")
    public suspend fun conditionalForwarderIpAddrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditionalForwarderIpAddrs = mapped
    }

    /**
     * @param value Whether to delete the conditional forwarder when deleting the Trust relationship.
     */
    @JvmName("xnkifrhjltimenro")
    public suspend fun deleteAssociatedConditionalForwarder(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteAssociatedConditionalForwarder = mapped
    }

    /**
     * @param value ID of the Directory.
     */
    @JvmName("womxrjqyvxojhvbl")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value Fully qualified domain name of the remote Directory.
     */
    @JvmName("tfejipqurcqyassj")
    public suspend fun remoteDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDomainName = mapped
    }

    /**
     * @param value Whether to enable selective authentication.
     * Valid values are `Enabled` and `Disabled`.
     * Default value is `Disabled`.
     */
    @JvmName("fcjxihibimelwuuq")
    public suspend fun selectiveAuth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectiveAuth = mapped
    }

    /**
     * @param value The direction of the Trust relationship.
     * Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
     */
    @JvmName("mdvkxpjiugmcsajm")
    public suspend fun trustDirection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustDirection = mapped
    }

    /**
     * @param value Password for the Trust.
     * Does not need to match the passwords for either Directory.
     * Can contain upper- and lower-case letters, numbers, and punctuation characters.
     * May be up to 128 characters long.
     */
    @JvmName("vhrryfnlpjprhnjc")
    public suspend fun trustPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustPassword = mapped
    }

    /**
     * @param value Type of the Trust relationship.
     * Valid values are `Forest` and `External`.
     * Default value is `Forest`.
     */
    @JvmName("cwpgoneldcjcdoyo")
    public suspend fun trustType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustType = mapped
    }

    internal fun build(): TrustArgs = TrustArgs(
        conditionalForwarderIpAddrs = conditionalForwarderIpAddrs,
        deleteAssociatedConditionalForwarder = deleteAssociatedConditionalForwarder,
        directoryId = directoryId,
        remoteDomainName = remoteDomainName,
        selectiveAuth = selectiveAuth,
        trustDirection = trustDirection,
        trustPassword = trustPassword,
        trustType = trustType,
    )
}
