@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.inputs

import com.pulumi.aws.directoryservice.inputs.ServiceRegionVpcSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property subnetIds The identifiers of the subnets for the directory servers.
 * @property vpcId The identifier of the VPC in which to create the directory.
 */
public data class ServiceRegionVpcSettingsArgs(
    public val subnetIds: Output<List<String>>,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.inputs.ServiceRegionVpcSettingsArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.inputs.ServiceRegionVpcSettingsArgs =
        com.pulumi.aws.directoryservice.inputs.ServiceRegionVpcSettingsArgs.builder()
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceRegionVpcSettingsArgs].
 */
@PulumiTagMarker
public class ServiceRegionVpcSettingsArgsBuilder internal constructor() {
    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The identifiers of the subnets for the directory servers.
     */
    @JvmName("yvyosqjpvnqwgtai")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("ppwgiyabqfaqscsg")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The identifiers of the subnets for the directory servers.
     */
    @JvmName("ejtjpbwsfieumitr")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The identifier of the VPC in which to create the directory.
     */
    @JvmName("bowdrvkielcyyens")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The identifiers of the subnets for the directory servers.
     */
    @JvmName("nsfabahvqtkvgsmp")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The identifiers of the subnets for the directory servers.
     */
    @JvmName("dxtnqrhttehwebeg")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value The identifier of the VPC in which to create the directory.
     */
    @JvmName("vtyvmvdhpekvkuss")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ServiceRegionVpcSettingsArgs = ServiceRegionVpcSettingsArgs(
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
