@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.inputs

import com.pulumi.aws.directoryservice.inputs.SharedDirectoryTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Identifier of the directory consumer account.
 * @property type Type of identifier to be used in the `id` field. Valid value is `ACCOUNT`. Default is `ACCOUNT`.
 */
public data class SharedDirectoryTargetArgs(
    public val id: Output<String>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.inputs.SharedDirectoryTargetArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.inputs.SharedDirectoryTargetArgs =
        com.pulumi.aws.directoryservice.inputs.SharedDirectoryTargetArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SharedDirectoryTargetArgs].
 */
@PulumiTagMarker
public class SharedDirectoryTargetArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Identifier of the directory consumer account.
     */
    @JvmName("kmoqqegcquyxsjfs")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Type of identifier to be used in the `id` field. Valid value is `ACCOUNT`. Default is `ACCOUNT`.
     */
    @JvmName("kiobisqlbnwxgdds")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Identifier of the directory consumer account.
     */
    @JvmName("cqmqghjrrtjptmox")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Type of identifier to be used in the `id` field. Valid value is `ACCOUNT`. Default is `ACCOUNT`.
     */
    @JvmName("smunastkxysmefff")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SharedDirectoryTargetArgs = SharedDirectoryTargetArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        type = type,
    )
}
