@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones
 * @property connectIps The IP addresses of the AD Connector servers.
 * @property customerDnsIps The DNS IP addresses of the domain to connect to.
 * @property customerUsername The username corresponding to the password provided.
 * @property subnetIds The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
 * @property vpcId The identifier of the VPC that the directory is in.
 */
public data class DirectoryConnectSettings(
    public val availabilityZones: List<String>? = null,
    public val connectIps: List<String>? = null,
    public val customerDnsIps: List<String>,
    public val customerUsername: String,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directoryservice.outputs.DirectoryConnectSettings): DirectoryConnectSettings = DirectoryConnectSettings(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            connectIps = javaType.connectIps().map({ args0 -> args0 }),
            customerDnsIps = javaType.customerDnsIps().map({ args0 -> args0 }),
            customerUsername = javaType.customerUsername(),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
