@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones
 * @property subnetIds The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
 * @property vpcId The identifier of the VPC that the directory is in.
 */
public data class DirectoryVpcSettings(
    public val availabilityZones: List<String>? = null,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directoryservice.outputs.DirectoryVpcSettings): DirectoryVpcSettings = DirectoryVpcSettings(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
