@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones
 * @property connectIps IP addresses of the AD Connector servers.
 * @property customerDnsIps DNS IP addresses of the domain to connect to.
 * @property customerUsername Username corresponding to the password provided.
 * @property subnetIds Identifiers of the subnets for the connector servers (2 subnets in 2 different AZs).
 * @property vpcId ID of the VPC that the connector is in.
 */
public data class GetDirectoryConnectSetting(
    public val availabilityZones: List<String>,
    public val connectIps: List<String>,
    public val customerDnsIps: List<String>,
    public val customerUsername: String,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directoryservice.outputs.GetDirectoryConnectSetting): GetDirectoryConnectSetting = GetDirectoryConnectSetting(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            connectIps = javaType.connectIps().map({ args0 -> args0 }),
            customerDnsIps = javaType.customerDnsIps().map({ args0 -> args0 }),
            customerUsername = javaType.customerUsername(),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
