@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property subnetIds The identifiers of the subnets for the directory servers.
 * @property vpcId The identifier of the VPC in which to create the directory.
 */
public data class ServiceRegionVpcSettings(
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directoryservice.outputs.ServiceRegionVpcSettings): ServiceRegionVpcSettings = ServiceRegionVpcSettings(
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
