@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin

import com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetails
import com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetails.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LifecyclePolicy].
 */
@PulumiTagMarker
public class LifecyclePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LifecyclePolicyArgs = LifecyclePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LifecyclePolicyArgsBuilder.() -> Unit) {
        val builder = LifecyclePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LifecyclePolicy {
        val builtJavaResource = com.pulumi.aws.dlm.LifecyclePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LifecyclePolicy(builtJavaResource)
    }
}

/**
 * Provides a [Data Lifecycle Manager (DLM) lifecycle policy](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-lifecycle.html) for managing snapshots.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["dlm&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const dlmLifecycleRole = new aws.iam.Role("dlm_lifecycle_role", {
 *     name: "dlm-lifecycle-role",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const dlmLifecycle = aws.iam.getPolicyDocument({
 *     statements: [
 *         {
 *             effect: "Allow",
 *             actions: [
 *                 "ec2:CreateSnapshot",
 *                 "ec2:CreateSnapshots",
 *                 "ec2:DeleteSnapshot",
 *                 "ec2:DescribeInstances",
 *                 "ec2:DescribeVolumes",
 *                 "ec2:DescribeSnapshots",
 *             ],
 *             resources: ["*"],
 *         },
 *         {
 *             effect: "Allow",
 *             actions: ["ec2:CreateTags"],
 *             resources: ["arn:aws:ec2:*::snapshot/*"],
 *         },
 *     ],
 * });
 * const dlmLifecycleRolePolicy = new aws.iam.RolePolicy("dlm_lifecycle", {
 *     name: "dlm-lifecycle-policy",
 *     role: dlmLifecycleRole.id,
 *     policy: dlmLifecycle.then(dlmLifecycle => dlmLifecycle.json),
 * });
 * const example = new aws.dlm.LifecyclePolicy("example", {
 *     description: "example DLM lifecycle policy",
 *     executionRoleArn: dlmLifecycleRole.arn,
 *     state: "ENABLED",
 *     policyDetails: {
 *         resourceTypes: "VOLUME",
 *         schedules: [{
 *             name: "2 weeks of daily snapshots",
 *             createRule: {
 *                 interval: 24,
 *                 intervalUnit: "HOURS",
 *                 times: "23:45",
 *             },
 *             retainRule: {
 *                 count: 14,
 *             },
 *             tagsToAdd: {
 *                 SnapshotCreator: "DLM",
 *             },
 *             copyTags: false,
 *         }],
 *         targetTags: {
 *             Snapshot: "true",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["dlm&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * dlm_lifecycle_role = aws.iam.Role("dlm_lifecycle_role",
 *     name="dlm-lifecycle-role",
 *     assume_role_policy=assume_role.json)
 * dlm_lifecycle = aws.iam.get_policy_document(statements=[
 *     {
 *         "effect": "Allow",
 *         "actions": [
 *             "ec2:CreateSnapshot",
 *             "ec2:CreateSnapshots",
 *             "ec2:DeleteSnapshot",
 *             "ec2:DescribeInstances",
 *             "ec2:DescribeVolumes",
 *             "ec2:DescribeSnapshots",
 *         ],
 *         "resources": ["*"],
 *     },
 *     {
 *         "effect": "Allow",
 *         "actions": ["ec2:CreateTags"],
 *         "resources": ["arn:aws:ec2:*::snapshot/*"],
 *     },
 * ])
 * dlm_lifecycle_role_policy = aws.iam.RolePolicy("dlm_lifecycle",
 *     name="dlm-lifecycle-policy",
 *     role=dlm_lifecycle_role.id,
 *     policy=dlm_lifecycle.json)
 * example = aws.dlm.LifecyclePolicy("example",
 *     description="example DLM lifecycle policy",
 *     execution_role_arn=dlm_lifecycle_role.arn,
 *     state="ENABLED",
 *     policy_details={
 *         "resource_types": "VOLUME",
 *         "schedules": [{
 *             "name": "2 weeks of daily snapshots",
 *             "create_rule": {
 *                 "interval": 24,
 *                 "interval_unit": "HOURS",
 *                 "times": "23:45",
 *             },
 *             "retain_rule": {
 *                 "count": 14,
 *             },
 *             "tags_to_add": {
 *                 "snapshot_creator": "DLM",
 *             },
 *             "copy_tags": False,
 *         }],
 *         "target_tags": {
 *             "snapshot": "true",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "dlm.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var dlmLifecycleRole = new Aws.Iam.Role("dlm_lifecycle_role", new()
 *     {
 *         Name = "dlm-lifecycle-role",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var dlmLifecycle = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "ec2:CreateSnapshot",
 *                     "ec2:CreateSnapshots",
 *                     "ec2:DeleteSnapshot",
 *                     "ec2:DescribeInstances",
 *                     "ec2:DescribeVolumes",
 *                     "ec2:DescribeSnapshots",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "ec2:CreateTags",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:ec2:*::snapshot/*",
 *                 },
 *             },
 *         },
 *     });
 *     var dlmLifecycleRolePolicy = new Aws.Iam.RolePolicy("dlm_lifecycle", new()
 *     {
 *         Name = "dlm-lifecycle-policy",
 *         Role = dlmLifecycleRole.Id,
 *         Policy = dlmLifecycle.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var example = new Aws.Dlm.LifecyclePolicy("example", new()
 *     {
 *         Description = "example DLM lifecycle policy",
 *         ExecutionRoleArn = dlmLifecycleRole.Arn,
 *         State = "ENABLED",
 *         PolicyDetails = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsArgs
 *         {
 *             ResourceTypes = "VOLUME",
 *             Schedules = new[]
 *             {
 *                 new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsScheduleArgs
 *                 {
 *                     Name = "2 weeks of daily snapshots",
 *                     CreateRule = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs
 *                     {
 *                         Interval = 24,
 *                         IntervalUnit = "HOURS",
 *                         Times = "23:45",
 *                     },
 *                     RetainRule = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs
 *                     {
 *                         Count = 14,
 *                     },
 *                     TagsToAdd =
 *                     {
 *                         { "SnapshotCreator", "DLM" },
 *                     },
 *                     CopyTags = false,
 *                 },
 *             },
 *             TargetTags =
 *             {
 *                 { "Snapshot", "true" },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dlm"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"dlm.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		dlmLifecycleRole, err := iam.NewRole(ctx, "dlm_lifecycle_role", &iam.RoleArgs{
 * 			Name:             pulumi.String("dlm-lifecycle-role"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		dlmLifecycle, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"ec2:CreateSnapshot",
 * 						"ec2:CreateSnapshots",
 * 						"ec2:DeleteSnapshot",
 * 						"ec2:DescribeInstances",
 * 						"ec2:DescribeVolumes",
 * 						"ec2:DescribeSnapshots",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"ec2:CreateTags",
 * 					},
 * 					Resources: []string{
 * 						"arn:aws:ec2:*::snapshot/*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicy(ctx, "dlm_lifecycle", &iam.RolePolicyArgs{
 * 			Name:   pulumi.String("dlm-lifecycle-policy"),
 * 			Role:   dlmLifecycleRole.ID(),
 * 			Policy: pulumi.String(dlmLifecycle.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dlm.NewLifecyclePolicy(ctx, "example", &dlm.LifecyclePolicyArgs{
 * 			Description:      pulumi.String("example DLM lifecycle policy"),
 * 			ExecutionRoleArn: dlmLifecycleRole.Arn,
 * 			State:            pulumi.String("ENABLED"),
 * 			PolicyDetails: &dlm.LifecyclePolicyPolicyDetailsArgs{
 * 				ResourceTypes: pulumi.StringArray("VOLUME"),
 * 				Schedules: dlm.LifecyclePolicyPolicyDetailsScheduleArray{
 * 					&dlm.LifecyclePolicyPolicyDetailsScheduleArgs{
 * 						Name: pulumi.String("2 weeks of daily snapshots"),
 * 						CreateRule: &dlm.LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs{
 * 							Interval:     pulumi.Int(24),
 * 							IntervalUnit: pulumi.String("HOURS"),
 * 							Times:        pulumi.String("23:45"),
 * 						},
 * 						RetainRule: &dlm.LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs{
 * 							Count: pulumi.Int(14),
 * 						},
 * 						TagsToAdd: pulumi.StringMap{
 * 							"SnapshotCreator": pulumi.String("DLM"),
 * 						},
 * 						CopyTags: pulumi.Bool(false),
 * 					},
 * 				},
 * 				TargetTags: pulumi.StringMap{
 * 					"Snapshot": pulumi.String("true"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.dlm.LifecyclePolicy;
 * import com.pulumi.aws.dlm.LifecyclePolicyArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("dlm.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var dlmLifecycleRole = new Role("dlmLifecycleRole", RoleArgs.builder()
 *             .name("dlm-lifecycle-role")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var dlmLifecycle = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "ec2:CreateSnapshot",
 *                         "ec2:CreateSnapshots",
 *                         "ec2:DeleteSnapshot",
 *                         "ec2:DescribeInstances",
 *                         "ec2:DescribeVolumes",
 *                         "ec2:DescribeSnapshots")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("ec2:CreateTags")
 *                     .resources("arn:aws:ec2:*::snapshot/*")
 *                     .build())
 *             .build());
 *         var dlmLifecycleRolePolicy = new RolePolicy("dlmLifecycleRolePolicy", RolePolicyArgs.builder()
 *             .name("dlm-lifecycle-policy")
 *             .role(dlmLifecycleRole.id())
 *             .policy(dlmLifecycle.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var example = new LifecyclePolicy("example", LifecyclePolicyArgs.builder()
 *             .description("example DLM lifecycle policy")
 *             .executionRoleArn(dlmLifecycleRole.arn())
 *             .state("ENABLED")
 *             .policyDetails(LifecyclePolicyPolicyDetailsArgs.builder()
 *                 .resourceTypes("VOLUME")
 *                 .schedules(LifecyclePolicyPolicyDetailsScheduleArgs.builder()
 *                     .name("2 weeks of daily snapshots")
 *                     .createRule(LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs.builder()
 *                         .interval(24)
 *                         .intervalUnit("HOURS")
 *                         .times("23:45")
 *                         .build())
 *                     .retainRule(LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs.builder()
 *                         .count(14)
 *                         .build())
 *                     .tagsToAdd(Map.of("SnapshotCreator", "DLM"))
 *                     .copyTags(false)
 *                     .build())
 *                 .targetTags(Map.of("Snapshot", "true"))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dlmLifecycleRole:
 *     type: aws:iam:Role
 *     name: dlm_lifecycle_role
 *     properties:
 *       name: dlm-lifecycle-role
 *       assumeRolePolicy: ${assumeRole.json}
 *   dlmLifecycleRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: dlm_lifecycle
 *     properties:
 *       name: dlm-lifecycle-policy
 *       role: ${dlmLifecycleRole.id}
 *       policy: ${dlmLifecycle.json}
 *   example:
 *     type: aws:dlm:LifecyclePolicy
 *     properties:
 *       description: example DLM lifecycle policy
 *       executionRoleArn: ${dlmLifecycleRole.arn}
 *       state: ENABLED
 *       policyDetails:
 *         resourceTypes: VOLUME
 *         schedules:
 *           - name: 2 weeks of daily snapshots
 *             createRule:
 *               interval: 24
 *               intervalUnit: HOURS
 *               times: 23:45
 *             retainRule:
 *               count: 14
 *             tagsToAdd:
 *               SnapshotCreator: DLM
 *             copyTags: false
 *         targetTags:
 *           Snapshot: 'true'
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - dlm.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   dlmLifecycle:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - ec2:CreateSnapshot
 *               - ec2:CreateSnapshots
 *               - ec2:DeleteSnapshot
 *               - ec2:DescribeInstances
 *               - ec2:DescribeVolumes
 *               - ec2:DescribeSnapshots
 *             resources:
 *               - '*'
 *           - effect: Allow
 *             actions:
 *               - ec2:CreateTags
 *             resources:
 *               - arn:aws:ec2:*::snapshot/*
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example Cross-Region Snapshot Copy Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // ...other configuration...
 * const current = aws.getCallerIdentity({});
 * const key = current.then(current => aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "Enable IAM User Permissions",
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: [`arn:aws:iam::${current&#46;accountId}:root`],
 *         }],
 *         actions: ["kms:*"],
 *         resources: ["*"],
 *     }],
 * }));
 * const dlmCrossRegionCopyCmk = new aws.kms.Key("dlm_cross_region_copy_cmk", {
 *     description: "Example Alternate Region KMS Key",
 *     policy: key.then(key => key.json),
 * });
 * const example = new aws.dlm.LifecyclePolicy("example", {
 *     description: "example DLM lifecycle policy",
 *     executionRoleArn: dlmLifecycleRole.arn,
 *     state: "ENABLED",
 *     policyDetails: {
 *         resourceTypes: "VOLUME",
 *         schedules: [{
 *             name: "2 weeks of daily snapshots",
 *             createRule: {
 *                 interval: 24,
 *                 intervalUnit: "HOURS",
 *                 times: "23:45",
 *             },
 *             retainRule: {
 *                 count: 14,
 *             },
 *             tagsToAdd: {
 *                 SnapshotCreator: "DLM",
 *             },
 *             copyTags: false,
 *             crossRegionCopyRules: [{
 *                 target: "us-west-2",
 *                 encrypted: true,
 *                 cmkArn: dlmCrossRegionCopyCmk.arn,
 *                 copyTags: true,
 *                 retainRule: {
 *                     interval: 30,
 *                     intervalUnit: "DAYS",
 *                 },
 *             }],
 *         }],
 *         targetTags: {
 *             Snapshot: "true",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # ...other configuration...
 * current = aws.get_caller_identity()
 * key = aws.iam.get_policy_document(statements=[{
 *     "sid": "Enable IAM User Permissions",
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": [f"arn:aws:iam::{current&#46;account_id}:root"],
 *     }],
 *     "actions": ["kms:*"],
 *     "resources": ["*"],
 * }])
 * dlm_cross_region_copy_cmk = aws.kms.Key("dlm_cross_region_copy_cmk",
 *     description="Example Alternate Region KMS Key",
 *     policy=key.json)
 * example = aws.dlm.LifecyclePolicy("example",
 *     description="example DLM lifecycle policy",
 *     execution_role_arn=dlm_lifecycle_role["arn"],
 *     state="ENABLED",
 *     policy_details={
 *         "resource_types": "VOLUME",
 *         "schedules": [{
 *             "name": "2 weeks of daily snapshots",
 *             "create_rule": {
 *                 "interval": 24,
 *                 "interval_unit": "HOURS",
 *                 "times": "23:45",
 *             },
 *             "retain_rule": {
 *                 "count": 14,
 *             },
 *             "tags_to_add": {
 *                 "snapshot_creator": "DLM",
 *             },
 *             "copy_tags": False,
 *             "cross_region_copy_rules": [{
 *                 "target": "us-west-2",
 *                 "encrypted": True,
 *                 "cmk_arn": dlm_cross_region_copy_cmk.arn,
 *                 "copy_tags": True,
 *                 "retain_rule": {
 *                     "interval": 30,
 *                     "interval_unit": "DAYS",
 *                 },
 *             }],
 *         }],
 *         "target_tags": {
 *             "snapshot": "true",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // ...other configuration...
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var key = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "Enable IAM User Permissions",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             $"arn:aws:iam::{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:root",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "kms:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var dlmCrossRegionCopyCmk = new Aws.Kms.Key("dlm_cross_region_copy_cmk", new()
 *     {
 *         Description = "Example Alternate Region KMS Key",
 *         Policy = key.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var example = new Aws.Dlm.LifecyclePolicy("example", new()
 *     {
 *         Description = "example DLM lifecycle policy",
 *         ExecutionRoleArn = dlmLifecycleRole.Arn,
 *         State = "ENABLED",
 *         PolicyDetails = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsArgs
 *         {
 *             ResourceTypes = "VOLUME",
 *             Schedules = new[]
 *             {
 *                 new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsScheduleArgs
 *                 {
 *                     Name = "2 weeks of daily snapshots",
 *                     CreateRule = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs
 *                     {
 *                         Interval = 24,
 *                         IntervalUnit = "HOURS",
 *                         Times = "23:45",
 *                     },
 *                     RetainRule = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs
 *                     {
 *                         Count = 14,
 *                     },
 *                     TagsToAdd =
 *                     {
 *                         { "SnapshotCreator", "DLM" },
 *                     },
 *                     CopyTags = false,
 *                     CrossRegionCopyRules = new[]
 *                     {
 *                         new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs
 *                         {
 *                             Target = "us-west-2",
 *                             Encrypted = true,
 *                             CmkArn = dlmCrossRegionCopyCmk.Arn,
 *                             CopyTags = true,
 *                             RetainRule = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs
 *                             {
 *                                 Interval = 30,
 *                                 IntervalUnit = "DAYS",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             TargetTags =
 *             {
 *                 { "Snapshot", "true" },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dlm"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// ...other configuration...
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		key, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("Enable IAM User Permissions"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								fmt.Sprintf("arn:aws:iam::%v:root", current.AccountId),
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"kms:*",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		dlmCrossRegionCopyCmk, err := kms.NewKey(ctx, "dlm_cross_region_copy_cmk", &kms.KeyArgs{
 * 			Description: pulumi.String("Example Alternate Region KMS Key"),
 * 			Policy:      pulumi.String(key.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dlm.NewLifecyclePolicy(ctx, "example", &dlm.LifecyclePolicyArgs{
 * 			Description:      pulumi.String("example DLM lifecycle policy"),
 * 			ExecutionRoleArn: pulumi.Any(dlmLifecycleRole.Arn),
 * 			State:            pulumi.String("ENABLED"),
 * 			PolicyDetails: &dlm.LifecyclePolicyPolicyDetailsArgs{
 * 				ResourceTypes: pulumi.StringArray("VOLUME"),
 * 				Schedules: dlm.LifecyclePolicyPolicyDetailsScheduleArray{
 * 					&dlm.LifecyclePolicyPolicyDetailsScheduleArgs{
 * 						Name: pulumi.String("2 weeks of daily snapshots"),
 * 						CreateRule: &dlm.LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs{
 * 							Interval:     pulumi.Int(24),
 * 							IntervalUnit: pulumi.String("HOURS"),
 * 							Times:        pulumi.String("23:45"),
 * 						},
 * 						RetainRule: &dlm.LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs{
 * 							Count: pulumi.Int(14),
 * 						},
 * 						TagsToAdd: pulumi.StringMap{
 * 							"SnapshotCreator": pulumi.String("DLM"),
 * 						},
 * 						CopyTags: pulumi.Bool(false),
 * 						CrossRegionCopyRules: dlm.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArray{
 * 							&dlm.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs{
 * 								Target:    pulumi.String("us-west-2"),
 * 								Encrypted: pulumi.Bool(true),
 * 								CmkArn:    dlmCrossRegionCopyCmk.Arn,
 * 								CopyTags:  pulumi.Bool(true),
 * 								RetainRule: &dlm.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs{
 * 									Interval:     pulumi.Int(30),
 * 									IntervalUnit: pulumi.String("DAYS"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				TargetTags: pulumi.StringMap{
 * 					"Snapshot": pulumi.String("true"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.dlm.LifecyclePolicy;
 * import com.pulumi.aws.dlm.LifecyclePolicyArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // ...other configuration...
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var key = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("Enable IAM User Permissions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("kms:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var dlmCrossRegionCopyCmk = new Key("dlmCrossRegionCopyCmk", KeyArgs.builder()
 *             .description("Example Alternate Region KMS Key")
 *             .policy(key.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var example = new LifecyclePolicy("example", LifecyclePolicyArgs.builder()
 *             .description("example DLM lifecycle policy")
 *             .executionRoleArn(dlmLifecycleRole.arn())
 *             .state("ENABLED")
 *             .policyDetails(LifecyclePolicyPolicyDetailsArgs.builder()
 *                 .resourceTypes("VOLUME")
 *                 .schedules(LifecyclePolicyPolicyDetailsScheduleArgs.builder()
 *                     .name("2 weeks of daily snapshots")
 *                     .createRule(LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs.builder()
 *                         .interval(24)
 *                         .intervalUnit("HOURS")
 *                         .times("23:45")
 *                         .build())
 *                     .retainRule(LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs.builder()
 *                         .count(14)
 *                         .build())
 *                     .tagsToAdd(Map.of("SnapshotCreator", "DLM"))
 *                     .copyTags(false)
 *                     .crossRegionCopyRules(LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs.builder()
 *                         .target("us-west-2")
 *                         .encrypted(true)
 *                         .cmkArn(dlmCrossRegionCopyCmk.arn())
 *                         .copyTags(true)
 *                         .retainRule(LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs.builder()
 *                             .interval(30)
 *                             .intervalUnit("DAYS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .targetTags(Map.of("Snapshot", "true"))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dlmCrossRegionCopyCmk:
 *     type: aws:kms:Key
 *     name: dlm_cross_region_copy_cmk
 *     properties:
 *       description: Example Alternate Region KMS Key
 *       policy: ${key.json}
 *   example:
 *     type: aws:dlm:LifecyclePolicy
 *     properties:
 *       description: example DLM lifecycle policy
 *       executionRoleArn: ${dlmLifecycleRole.arn}
 *       state: ENABLED
 *       policyDetails:
 *         resourceTypes: VOLUME
 *         schedules:
 *           - name: 2 weeks of daily snapshots
 *             createRule:
 *               interval: 24
 *               intervalUnit: HOURS
 *               times: 23:45
 *             retainRule:
 *               count: 14
 *             tagsToAdd:
 *               SnapshotCreator: DLM
 *             copyTags: false
 *             crossRegionCopyRules:
 *               - target: us-west-2
 *                 encrypted: true
 *                 cmkArn: ${dlmCrossRegionCopyCmk.arn}
 *                 copyTags: true
 *                 retainRule:
 *                   interval: 30
 *                   intervalUnit: DAYS
 *         targetTags:
 *           Snapshot: 'true'
 * variables:
 *   # ...other configuration...
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   key:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: Enable IAM User Permissions
 *             effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - arn:aws:iam::${current.accountId}:root
 *             actions:
 *               - kms:*
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example Event Based Policy Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const exampleLifecyclePolicy = new aws.dlm.LifecyclePolicy("example", {
 *     description: "tf-acc-basic",
 *     executionRoleArn: exampleAwsIamRole.arn,
 *     policyDetails: {
 *         policyType: "EVENT_BASED_POLICY",
 *         action: {
 *             name: "tf-acc-basic",
 *             crossRegionCopies: [{
 *                 encryptionConfiguration: {},
 *                 retainRule: {
 *                     interval: 15,
 *                     intervalUnit: "MONTHS",
 *                 },
 *                 target: "us-east-1",
 *             }],
 *         },
 *         eventSource: {
 *             type: "MANAGED_CWE",
 *             parameters: {
 *                 descriptionRegex: "^.*Created for policy: policy-1234567890abcdef0.*$",
 *                 eventType: "shareSnapshot",
 *                 snapshotOwners: [current&#46;then(current => current&#46;accountId)],
 *             },
 *         },
 *     },
 * });
 * const example = aws.iam.getPolicy({
 *     name: "AWSDataLifecycleManagerServiceRole",
 * });
 * const exampleRolePolicyAttachment = new aws.iam.RolePolicyAttachment("example", {
 *     role: exampleAwsIamRole.id,
 *     policyArn: example.then(example => example.arn),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example_lifecycle_policy = aws.dlm.LifecyclePolicy("example",
 *     description="tf-acc-basic",
 *     execution_role_arn=example_aws_iam_role["arn"],
 *     policy_details={
 *         "policy_type": "EVENT_BASED_POLICY",
 *         "action": {
 *             "name": "tf-acc-basic",
 *             "cross_region_copies": [{
 *                 "encryption_configuration": {},
 *                 "retain_rule": {
 *                     "interval": 15,
 *                     "interval_unit": "MONTHS",
 *                 },
 *                 "target": "us-east-1",
 *             }],
 *         },
 *         "event_source": {
 *             "type": "MANAGED_CWE",
 *             "parameters": {
 *                 "description_regex": "^.*Created for policy: policy-1234567890abcdef0.*$",
 *                 "event_type": "shareSnapshot",
 *                 "snapshot_owners": [current&#46;account_id],
 *             },
 *         },
 *     })
 * example = aws.iam.get_policy(name="AWSDataLifecycleManagerServiceRole")
 * example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
 *     role=example_aws_iam_role["id"],
 *     policy_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var exampleLifecyclePolicy = new Aws.Dlm.LifecyclePolicy("example", new()
 *     {
 *         Description = "tf-acc-basic",
 *         ExecutionRoleArn = exampleAwsIamRole.Arn,
 *         PolicyDetails = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsArgs
 *         {
 *             PolicyType = "EVENT_BASED_POLICY",
 *             Action = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsActionArgs
 *             {
 *                 Name = "tf-acc-basic",
 *                 CrossRegionCopies = new[]
 *                 {
 *                     new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs
 *                     {
 *                         EncryptionConfiguration = null,
 *                         RetainRule = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgs
 *                         {
 *                             Interval = 15,
 *                             IntervalUnit = "MONTHS",
 *                         },
 *                         Target = "us-east-1",
 *                     },
 *                 },
 *             },
 *             EventSource = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsEventSourceArgs
 *             {
 *                 Type = "MANAGED_CWE",
 *                 Parameters = new Aws.Dlm.Inputs.LifecyclePolicyPolicyDetailsEventSourceParametersArgs
 *                 {
 *                     DescriptionRegex = "^.*Created for policy: policy-1234567890abcdef0.*$",
 *                     EventType = "shareSnapshot",
 *                     SnapshotOwners = new[]
 *                     {
 *                         current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var example = Aws.Iam.GetPolicy.Invoke(new()
 *     {
 *         Name = "AWSDataLifecycleManagerServiceRole",
 *     });
 *     var exampleRolePolicyAttachment = new Aws.Iam.RolePolicyAttachment("example", new()
 *     {
 *         Role = exampleAwsIamRole.Id,
 *         PolicyArn = example.Apply(getPolicyResult => getPolicyResult.Arn),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dlm"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dlm.NewLifecyclePolicy(ctx, "example", &dlm.LifecyclePolicyArgs{
 * 			Description:      pulumi.String("tf-acc-basic"),
 * 			ExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			PolicyDetails: &dlm.LifecyclePolicyPolicyDetailsArgs{
 * 				PolicyType: pulumi.String("EVENT_BASED_POLICY"),
 * 				Action: &dlm.LifecyclePolicyPolicyDetailsActionArgs{
 * 					Name: pulumi.String("tf-acc-basic"),
 * 					CrossRegionCopies: dlm.LifecyclePolicyPolicyDetailsActionCrossRegionCopyArray{
 * 						&dlm.LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs{
 * 							EncryptionConfiguration: nil,
 * 							RetainRule: &dlm.LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgs{
 * 								Interval:     pulumi.Int(15),
 * 								IntervalUnit: pulumi.String("MONTHS"),
 * 							},
 * 							Target: pulumi.String("us-east-1"),
 * 						},
 * 					},
 * 				},
 * 				EventSource: &dlm.LifecyclePolicyPolicyDetailsEventSourceArgs{
 * 					Type: pulumi.String("MANAGED_CWE"),
 * 					Parameters: &dlm.LifecyclePolicyPolicyDetailsEventSourceParametersArgs{
 * 						DescriptionRegex: pulumi.String("^.*Created for policy: policy-1234567890abcdef0.*$"),
 * 						EventType:        pulumi.String("shareSnapshot"),
 * 						SnapshotOwners: pulumi.StringArray{
 * 							pulumi.String(current.AccountId),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.LookupPolicy(ctx, &iam.LookupPolicyArgs{
 * 			Name: pulumi.StringRef("AWSDataLifecycleManagerServiceRole"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "example", &iam.RolePolicyAttachmentArgs{
 * 			Role:      pulumi.Any(exampleAwsIamRole.Id),
 * 			PolicyArn: pulumi.String(example.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.dlm.LifecyclePolicy;
 * import com.pulumi.aws.dlm.LifecyclePolicyArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsActionArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceParametersArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var exampleLifecyclePolicy = new LifecyclePolicy("exampleLifecyclePolicy", LifecyclePolicyArgs.builder()
 *             .description("tf-acc-basic")
 *             .executionRoleArn(exampleAwsIamRole.arn())
 *             .policyDetails(LifecyclePolicyPolicyDetailsArgs.builder()
 *                 .policyType("EVENT_BASED_POLICY")
 *                 .action(LifecyclePolicyPolicyDetailsActionArgs.builder()
 *                     .name("tf-acc-basic")
 *                     .crossRegionCopies(LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs.builder()
 *                         .encryptionConfiguration()
 *                         .retainRule(LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgs.builder()
 *                             .interval(15)
 *                             .intervalUnit("MONTHS")
 *                             .build())
 *                         .target("us-east-1")
 *                         .build())
 *                     .build())
 *                 .eventSource(LifecyclePolicyPolicyDetailsEventSourceArgs.builder()
 *                     .type("MANAGED_CWE")
 *                     .parameters(LifecyclePolicyPolicyDetailsEventSourceParametersArgs.builder()
 *                         .descriptionRegex("^.*Created for policy: policy-1234567890abcdef0.*$")
 *                         .eventType("shareSnapshot")
 *                         .snapshotOwners(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         final var example = IamFunctions.getPolicy(GetPolicyArgs.builder()
 *             .name("AWSDataLifecycleManagerServiceRole")
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(exampleAwsIamRole.id())
 *             .policyArn(example.applyValue(getPolicyResult -> getPolicyResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleLifecyclePolicy:
 *     type: aws:dlm:LifecyclePolicy
 *     name: example
 *     properties:
 *       description: tf-acc-basic
 *       executionRoleArn: ${exampleAwsIamRole.arn}
 *       policyDetails:
 *         policyType: EVENT_BASED_POLICY
 *         action:
 *           name: tf-acc-basic
 *           crossRegionCopies:
 *             - encryptionConfiguration: {}
 *               retainRule:
 *                 interval: 15
 *                 intervalUnit: MONTHS
 *               target: us-east-1
 *         eventSource:
 *           type: MANAGED_CWE
 *           parameters:
 *             descriptionRegex: '^.*Created for policy: policy-1234567890abcdef0.*$'
 *             eventType: shareSnapshot
 *             snapshotOwners:
 *               - ${current.accountId}
 *   exampleRolePolicyAttachment:
 *     type: aws:iam:RolePolicyAttachment
 *     name: example
 *     properties:
 *       role: ${exampleAwsIamRole.id}
 *       policyArn: ${example.arn}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicy
 *       Arguments:
 *         name: AWSDataLifecycleManagerServiceRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DLM lifecycle policies using their policy ID. For example:
 * ```sh
 * $ pulumi import aws:dlm/lifecyclePolicy:LifecyclePolicy example policy-abcdef12345678901
 * ```
 * */*/*/*/*/*/
 */
public class LifecyclePolicy internal constructor(
    override val javaResource: com.pulumi.aws.dlm.LifecyclePolicy,
) : KotlinCustomResource(javaResource, LifecyclePolicyMapper) {
    /**
     * Amazon Resource Name (ARN) of the DLM Lifecycle Policy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description for the DLM lifecycle policy.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The ARN of an IAM role that is able to be assumed by the DLM service.
     */
    public val executionRoleArn: Output<String>
        get() = javaResource.executionRoleArn().applyValue({ args0 -> args0 })

    /**
     * See the `policy_details` configuration block. Max of 1.
     */
    public val policyDetails: Output<LifecyclePolicyPolicyDetails>
        get() = javaResource.policyDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Whether the lifecycle policy should be enabled or disabled. `ENABLED` or `DISABLED` are valid values. Defaults to `ENABLED`.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LifecyclePolicyMapper : ResourceMapper<LifecyclePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dlm.LifecyclePolicy::class == javaResource::class

    override fun map(javaResource: Resource): LifecyclePolicy = LifecyclePolicy(
        javaResource as
            com.pulumi.aws.dlm.LifecyclePolicy,
    )
}

/**
 * @see [LifecyclePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LifecyclePolicy].
 */
public suspend fun lifecyclePolicy(
    name: String,
    block: suspend LifecyclePolicyResourceBuilder.() -> Unit,
): LifecyclePolicy {
    val builder = LifecyclePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LifecyclePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lifecyclePolicy(name: String): LifecyclePolicy {
    val builder = LifecyclePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
