@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property crossRegionCopies The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
 * @property name
 */
public data class LifecyclePolicyPolicyDetailsActionArgs(
    public val crossRegionCopies: Output<List<LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs>>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsActionArgs> {
    override fun toJava(): com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsActionArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsActionArgs.builder()
            .crossRegionCopies(
                crossRegionCopies.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsActionArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsActionArgsBuilder internal constructor() {
    private var crossRegionCopies:
        Output<List<LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
     */
    @JvmName("jkxckiyxcalgjnrk")
    public suspend fun crossRegionCopies(`value`: Output<List<LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs>>) {
        this.crossRegionCopies = value
    }

    @JvmName("rehvhtctjxgynjpp")
    public suspend fun crossRegionCopies(vararg values: Output<LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs>) {
        this.crossRegionCopies = Output.all(values.asList())
    }

    /**
     * @param values The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
     */
    @JvmName("lcxhcynticknuwsm")
    public suspend fun crossRegionCopies(values: List<Output<LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs>>) {
        this.crossRegionCopies = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xbiurwonynevyrnl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
     */
    @JvmName("xxqeyptltktnngfe")
    public suspend fun crossRegionCopies(`value`: List<LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.crossRegionCopies = mapped
    }

    /**
     * @param argument The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
     */
    @JvmName("kgqtkexcltdodrwg")
    public suspend fun crossRegionCopies(argument: List<suspend LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.crossRegionCopies = mapped
    }

    /**
     * @param argument The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
     */
    @JvmName("wtepbleobymacbaw")
    public suspend fun crossRegionCopies(vararg argument: suspend LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.crossRegionCopies = mapped
    }

    /**
     * @param argument The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
     */
    @JvmName("kdmcfwwuiwqlbbgd")
    public suspend fun crossRegionCopies(argument: suspend LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.crossRegionCopies = mapped
    }

    /**
     * @param values The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
     */
    @JvmName("qsvyjugocadipors")
    public suspend fun crossRegionCopies(vararg values: LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.crossRegionCopies = mapped
    }

    /**
     * @param value
     */
    @JvmName("lpwgoulfojjwuviw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsActionArgs =
        LifecyclePolicyPolicyDetailsActionArgs(
            crossRegionCopies = crossRegionCopies ?: throw PulumiNullFieldException("crossRegionCopies"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
