@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property action The actions to be performed when the event-based policy is triggered. You can specify only one action per policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `action` configuration block.
 * @property eventSource The event that triggers the event-based policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `event_source` configuration block.
 * @property parameters
 * @property policyType The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY` to create an event-based policy that performs specific actions when a defined event occurs in your AWS account. Default value is `EBS_SNAPSHOT_MANAGEMENT`.
 * @property resourceLocations The location of the resources to backup. If the source resources are located in an AWS Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`. If you specify `OUTPOST`, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account. Valid values are `CLOUD` and `OUTPOST`.
 * @property resourceTypes A list of resource types that should be targeted by the lifecycle policy. Valid values are `VOLUME` and `INSTANCE`.
 * @property schedules See the `schedule` configuration block.
 * @property targetTags A map of tag keys and their values. Any resources that match the `resource_types` and are tagged with _any_ of these tags will be targeted.
 * > Note: You cannot have overlapping lifecycle policies that share the same `target_tags`. Pulumi is unable to detect this at plan time but it will fail during apply.
 */
public data class LifecyclePolicyPolicyDetailsArgs(
    public val action: Output<LifecyclePolicyPolicyDetailsActionArgs>? = null,
    public val eventSource: Output<LifecyclePolicyPolicyDetailsEventSourceArgs>? = null,
    public val parameters: Output<LifecyclePolicyPolicyDetailsParametersArgs>? = null,
    public val policyType: Output<String>? = null,
    public val resourceLocations: Output<String>? = null,
    public val resourceTypes: Output<List<String>>? = null,
    public val schedules: Output<List<LifecyclePolicyPolicyDetailsScheduleArgs>>? = null,
    public val targetTags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsArgs> {
    override fun toJava(): com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventSource(eventSource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .policyType(policyType?.applyValue({ args0 -> args0 }))
            .resourceLocations(resourceLocations?.applyValue({ args0 -> args0 }))
            .resourceTypes(resourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .schedules(
                schedules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetTags(
                targetTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsArgsBuilder internal constructor() {
    private var action: Output<LifecyclePolicyPolicyDetailsActionArgs>? = null

    private var eventSource: Output<LifecyclePolicyPolicyDetailsEventSourceArgs>? = null

    private var parameters: Output<LifecyclePolicyPolicyDetailsParametersArgs>? = null

    private var policyType: Output<String>? = null

    private var resourceLocations: Output<String>? = null

    private var resourceTypes: Output<List<String>>? = null

    private var schedules: Output<List<LifecyclePolicyPolicyDetailsScheduleArgs>>? = null

    private var targetTags: Output<Map<String, String>>? = null

    /**
     * @param value The actions to be performed when the event-based policy is triggered. You can specify only one action per policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `action` configuration block.
     */
    @JvmName("rhvufejrtskdvpng")
    public suspend fun action(`value`: Output<LifecyclePolicyPolicyDetailsActionArgs>) {
        this.action = value
    }

    /**
     * @param value The event that triggers the event-based policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `event_source` configuration block.
     */
    @JvmName("wwwjuewqntxnhnfv")
    public suspend fun eventSource(`value`: Output<LifecyclePolicyPolicyDetailsEventSourceArgs>) {
        this.eventSource = value
    }

    /**
     * @param value
     */
    @JvmName("hdjycwgbgbqqnong")
    public suspend fun parameters(`value`: Output<LifecyclePolicyPolicyDetailsParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY` to create an event-based policy that performs specific actions when a defined event occurs in your AWS account. Default value is `EBS_SNAPSHOT_MANAGEMENT`.
     */
    @JvmName("rosmdmovplaadvig")
    public suspend fun policyType(`value`: Output<String>) {
        this.policyType = value
    }

    /**
     * @param value The location of the resources to backup. If the source resources are located in an AWS Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`. If you specify `OUTPOST`, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account. Valid values are `CLOUD` and `OUTPOST`.
     */
    @JvmName("txxvpakmoikxkpqa")
    public suspend fun resourceLocations(`value`: Output<String>) {
        this.resourceLocations = value
    }

    /**
     * @param value A list of resource types that should be targeted by the lifecycle policy. Valid values are `VOLUME` and `INSTANCE`.
     */
    @JvmName("ndgehnxqjtwemwvu")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("sygshcfjconurrix")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of resource types that should be targeted by the lifecycle policy. Valid values are `VOLUME` and `INSTANCE`.
     */
    @JvmName("cpruxtcqnawhqjak")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value See the `schedule` configuration block.
     */
    @JvmName("stxngacjxmvjhmfc")
    public suspend fun schedules(`value`: Output<List<LifecyclePolicyPolicyDetailsScheduleArgs>>) {
        this.schedules = value
    }

    @JvmName("vmbdqtoemfuusimq")
    public suspend fun schedules(vararg values: Output<LifecyclePolicyPolicyDetailsScheduleArgs>) {
        this.schedules = Output.all(values.asList())
    }

    /**
     * @param values See the `schedule` configuration block.
     */
    @JvmName("suumeiegruaennir")
    public suspend fun schedules(values: List<Output<LifecyclePolicyPolicyDetailsScheduleArgs>>) {
        this.schedules = Output.all(values)
    }

    /**
     * @param value A map of tag keys and their values. Any resources that match the `resource_types` and are tagged with _any_ of these tags will be targeted.
     * > Note: You cannot have overlapping lifecycle policies that share the same `target_tags`. Pulumi is unable to detect this at plan time but it will fail during apply.
     */
    @JvmName("tkbneprvqwwtdwym")
    public suspend fun targetTags(`value`: Output<Map<String, String>>) {
        this.targetTags = value
    }

    /**
     * @param value The actions to be performed when the event-based policy is triggered. You can specify only one action per policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `action` configuration block.
     */
    @JvmName("hgiqfraunaedvaki")
    public suspend fun action(`value`: LifecyclePolicyPolicyDetailsActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The actions to be performed when the event-based policy is triggered. You can specify only one action per policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `action` configuration block.
     */
    @JvmName("dvpthyosahxgyhfk")
    public suspend fun action(argument: suspend LifecyclePolicyPolicyDetailsActionArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsActionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value The event that triggers the event-based policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `event_source` configuration block.
     */
    @JvmName("wjpweveswwdocgwe")
    public suspend fun eventSource(`value`: LifecyclePolicyPolicyDetailsEventSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSource = mapped
    }

    /**
     * @param argument The event that triggers the event-based policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `event_source` configuration block.
     */
    @JvmName("iissntghtigastqx")
    public suspend fun eventSource(argument: suspend LifecyclePolicyPolicyDetailsEventSourceArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsEventSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.eventSource = mapped
    }

    /**
     * @param value
     */
    @JvmName("hwackrwlinaxbvih")
    public suspend fun parameters(`value`: LifecyclePolicyPolicyDetailsParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xqgqoiisxlxlknvg")
    public suspend fun parameters(argument: suspend LifecyclePolicyPolicyDetailsParametersArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY` to create an event-based policy that performs specific actions when a defined event occurs in your AWS account. Default value is `EBS_SNAPSHOT_MANAGEMENT`.
     */
    @JvmName("yatghfjfwkfrcdtc")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The location of the resources to backup. If the source resources are located in an AWS Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`. If you specify `OUTPOST`, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account. Valid values are `CLOUD` and `OUTPOST`.
     */
    @JvmName("relimhjbjblqhbtn")
    public suspend fun resourceLocations(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLocations = mapped
    }

    /**
     * @param value A list of resource types that should be targeted by the lifecycle policy. Valid values are `VOLUME` and `INSTANCE`.
     */
    @JvmName("xcfehiodkdgnaiod")
    public suspend fun resourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values A list of resource types that should be targeted by the lifecycle policy. Valid values are `VOLUME` and `INSTANCE`.
     */
    @JvmName("cgqljuuiqjyutmfo")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param value See the `schedule` configuration block.
     */
    @JvmName("qjtpvvqxycvhwdmb")
    public suspend fun schedules(`value`: List<LifecyclePolicyPolicyDetailsScheduleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    /**
     * @param argument See the `schedule` configuration block.
     */
    @JvmName("ysikacynctyqdtgn")
    public suspend fun schedules(argument: List<suspend LifecyclePolicyPolicyDetailsScheduleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LifecyclePolicyPolicyDetailsScheduleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param argument See the `schedule` configuration block.
     */
    @JvmName("vjwcigvgumhmjusl")
    public suspend fun schedules(vararg argument: suspend LifecyclePolicyPolicyDetailsScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LifecyclePolicyPolicyDetailsScheduleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param argument See the `schedule` configuration block.
     */
    @JvmName("vxvgfnareeighcgr")
    public suspend fun schedules(argument: suspend LifecyclePolicyPolicyDetailsScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LifecyclePolicyPolicyDetailsScheduleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param values See the `schedule` configuration block.
     */
    @JvmName("trjdyedogucopvhi")
    public suspend fun schedules(vararg values: LifecyclePolicyPolicyDetailsScheduleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    /**
     * @param value A map of tag keys and their values. Any resources that match the `resource_types` and are tagged with _any_ of these tags will be targeted.
     * > Note: You cannot have overlapping lifecycle policies that share the same `target_tags`. Pulumi is unable to detect this at plan time but it will fail during apply.
     */
    @JvmName("xobykkvptxatviwk")
    public suspend fun targetTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetTags = mapped
    }

    /**
     * @param values A map of tag keys and their values. Any resources that match the `resource_types` and are tagged with _any_ of these tags will be targeted.
     * > Note: You cannot have overlapping lifecycle policies that share the same `target_tags`. Pulumi is unable to detect this at plan time but it will fail during apply.
     */
    @JvmName("fcqyqibgnodjiuyb")
    public fun targetTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetTags = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsArgs = LifecyclePolicyPolicyDetailsArgs(
        action = action,
        eventSource = eventSource,
        parameters = parameters,
        policyType = policyType,
        resourceLocations = resourceLocations,
        resourceTypes = resourceTypes,
        schedules = schedules,
        targetTags = targetTags,
    )
}
