@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property parameters
 * @property type The source of the event. Currently only managed CloudWatch Events rules are supported. Valid values are `MANAGED_CWE`.
 */
public data class LifecyclePolicyPolicyDetailsEventSourceArgs(
    public val parameters: Output<LifecyclePolicyPolicyDetailsEventSourceParametersArgs>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceArgs> {
    override fun toJava(): com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceArgs.builder()
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsEventSourceArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsEventSourceArgsBuilder internal constructor() {
    private var parameters: Output<LifecyclePolicyPolicyDetailsEventSourceParametersArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("rktngicwnyndasyu")
    public suspend fun parameters(`value`: Output<LifecyclePolicyPolicyDetailsEventSourceParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The source of the event. Currently only managed CloudWatch Events rules are supported. Valid values are `MANAGED_CWE`.
     */
    @JvmName("nbuxwujtblcokdho")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("jwydbejsvlepglbc")
    public suspend fun parameters(`value`: LifecyclePolicyPolicyDetailsEventSourceParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ighpolaluiajbtny")
    public suspend fun parameters(argument: suspend LifecyclePolicyPolicyDetailsEventSourceParametersArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsEventSourceParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value The source of the event. Currently only managed CloudWatch Events rules are supported. Valid values are `MANAGED_CWE`.
     */
    @JvmName("kdgnvgqsujeafsmq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsEventSourceArgs =
        LifecyclePolicyPolicyDetailsEventSourceArgs(
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
