@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property descriptionRegex The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
 * @property eventType The type of event. Currently, only `shareSnapshot` events are supported.
 * @property snapshotOwners The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
 */
public data class LifecyclePolicyPolicyDetailsEventSourceParametersArgs(
    public val descriptionRegex: Output<String>,
    public val eventType: Output<String>,
    public val snapshotOwners: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceParametersArgs> {
    override fun toJava(): com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceParametersArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceParametersArgs.builder()
            .descriptionRegex(descriptionRegex.applyValue({ args0 -> args0 }))
            .eventType(eventType.applyValue({ args0 -> args0 }))
            .snapshotOwners(snapshotOwners.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsEventSourceParametersArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsEventSourceParametersArgsBuilder internal constructor() {
    private var descriptionRegex: Output<String>? = null

    private var eventType: Output<String>? = null

    private var snapshotOwners: Output<List<String>>? = null

    /**
     * @param value The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
     */
    @JvmName("iuprsmldxjkiwivv")
    public suspend fun descriptionRegex(`value`: Output<String>) {
        this.descriptionRegex = value
    }

    /**
     * @param value The type of event. Currently, only `shareSnapshot` events are supported.
     */
    @JvmName("sewujlscrmcnpiia")
    public suspend fun eventType(`value`: Output<String>) {
        this.eventType = value
    }

    /**
     * @param value The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
     */
    @JvmName("tehcfttuxxwtnfen")
    public suspend fun snapshotOwners(`value`: Output<List<String>>) {
        this.snapshotOwners = value
    }

    @JvmName("dyagvytgyxeoesdj")
    public suspend fun snapshotOwners(vararg values: Output<String>) {
        this.snapshotOwners = Output.all(values.asList())
    }

    /**
     * @param values The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
     */
    @JvmName("oopusvtepsjrqjpa")
    public suspend fun snapshotOwners(values: List<Output<String>>) {
        this.snapshotOwners = Output.all(values)
    }

    /**
     * @param value The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
     */
    @JvmName("wkpdlpfjqfoglcty")
    public suspend fun descriptionRegex(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.descriptionRegex = mapped
    }

    /**
     * @param value The type of event. Currently, only `shareSnapshot` events are supported.
     */
    @JvmName("fcnlynqsaxblarfy")
    public suspend fun eventType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventType = mapped
    }

    /**
     * @param value The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
     */
    @JvmName("uubaoodvgfndudhm")
    public suspend fun snapshotOwners(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotOwners = mapped
    }

    /**
     * @param values The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
     */
    @JvmName("ecyfryjtfxrlsnrj")
    public suspend fun snapshotOwners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotOwners = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsEventSourceParametersArgs =
        LifecyclePolicyPolicyDetailsEventSourceParametersArgs(
            descriptionRegex = descriptionRegex ?: throw PulumiNullFieldException("descriptionRegex"),
            eventType = eventType ?: throw PulumiNullFieldException("eventType"),
            snapshotOwners = snapshotOwners ?: throw PulumiNullFieldException("snapshotOwners"),
        )
}
