@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property excludeBootVolume Indicates whether to exclude the root volume from snapshots created using CreateSnapshots. The default is `false`.
 * @property noReboot Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle policy runs. `true` indicates that targeted instances are not rebooted when the policy runs. `false` indicates that target instances are rebooted when the policy runs. The default is `true` (instances are not rebooted).
 */
public data class LifecyclePolicyPolicyDetailsParametersArgs(
    public val excludeBootVolume: Output<Boolean>? = null,
    public val noReboot: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsParametersArgs> {
    override fun toJava(): com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsParametersArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsParametersArgs.builder()
            .excludeBootVolume(excludeBootVolume?.applyValue({ args0 -> args0 }))
            .noReboot(noReboot?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsParametersArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsParametersArgsBuilder internal constructor() {
    private var excludeBootVolume: Output<Boolean>? = null

    private var noReboot: Output<Boolean>? = null

    /**
     * @param value Indicates whether to exclude the root volume from snapshots created using CreateSnapshots. The default is `false`.
     */
    @JvmName("imipvfxiphtffsrk")
    public suspend fun excludeBootVolume(`value`: Output<Boolean>) {
        this.excludeBootVolume = value
    }

    /**
     * @param value Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle policy runs. `true` indicates that targeted instances are not rebooted when the policy runs. `false` indicates that target instances are rebooted when the policy runs. The default is `true` (instances are not rebooted).
     */
    @JvmName("xeesfvmufxvqandc")
    public suspend fun noReboot(`value`: Output<Boolean>) {
        this.noReboot = value
    }

    /**
     * @param value Indicates whether to exclude the root volume from snapshots created using CreateSnapshots. The default is `false`.
     */
    @JvmName("pajauuosxcsdunev")
    public suspend fun excludeBootVolume(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeBootVolume = mapped
    }

    /**
     * @param value Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle policy runs. `true` indicates that targeted instances are not rebooted when the policy runs. `false` indicates that target instances are rebooted when the policy runs. The default is `true` (instances are not rebooted).
     */
    @JvmName("svbmvhsuhawwcsys")
    public suspend fun noReboot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noReboot = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsParametersArgs =
        LifecyclePolicyPolicyDetailsParametersArgs(
            excludeBootVolume = excludeBootVolume,
            noReboot = noReboot,
        )
}
