@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property copyTags
 * @property createRule See the `create_rule` block. Max of 1 per schedule.
 * @property crossRegionCopyRules See the `cross_region_copy_rule` block. Max of 3 per schedule.
 * @property deprecateRule
 * @property fastRestoreRule See the `fast_restore_rule` block. Max of 1 per schedule.
 * @property name
 * @property retainRule
 * @property shareRule See the `share_rule` block. Max of 1 per schedule.
 * @property tagsToAdd A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
 * @property variableTags A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
 */
public data class LifecyclePolicyPolicyDetailsScheduleArgs(
    public val copyTags: Output<Boolean>? = null,
    public val createRule: Output<LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs>,
    public val crossRegionCopyRules: Output<List<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>>? = null,
    public val deprecateRule: Output<LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs>? = null,
    public val fastRestoreRule: Output<LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs>? =
        null,
    public val name: Output<String>,
    public val retainRule: Output<LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs>,
    public val shareRule: Output<LifecyclePolicyPolicyDetailsScheduleShareRuleArgs>? = null,
    public val tagsToAdd: Output<Map<String, String>>? = null,
    public val variableTags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleArgs> {
    override fun toJava(): com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleArgs.builder()
            .copyTags(copyTags?.applyValue({ args0 -> args0 }))
            .createRule(createRule.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .crossRegionCopyRules(
                crossRegionCopyRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deprecateRule(deprecateRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fastRestoreRule(fastRestoreRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .retainRule(retainRule.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .shareRule(shareRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tagsToAdd(
                tagsToAdd?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .variableTags(
                variableTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsScheduleArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsScheduleArgsBuilder internal constructor() {
    private var copyTags: Output<Boolean>? = null

    private var createRule: Output<LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs>? = null

    private var crossRegionCopyRules:
        Output<List<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>>? = null

    private var deprecateRule: Output<LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs>? = null

    private var fastRestoreRule: Output<LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs>? =
        null

    private var name: Output<String>? = null

    private var retainRule: Output<LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs>? = null

    private var shareRule: Output<LifecyclePolicyPolicyDetailsScheduleShareRuleArgs>? = null

    private var tagsToAdd: Output<Map<String, String>>? = null

    private var variableTags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("quhuhibeyyjtonho")
    public suspend fun copyTags(`value`: Output<Boolean>) {
        this.copyTags = value
    }

    /**
     * @param value See the `create_rule` block. Max of 1 per schedule.
     */
    @JvmName("jxgssoephxfgjvla")
    public suspend fun createRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs>) {
        this.createRule = value
    }

    /**
     * @param value See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("cgiqbjjlkwesjrnu")
    public suspend fun crossRegionCopyRules(`value`: Output<List<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>>) {
        this.crossRegionCopyRules = value
    }

    @JvmName("jysettqvpygakton")
    public suspend fun crossRegionCopyRules(vararg values: Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>) {
        this.crossRegionCopyRules = Output.all(values.asList())
    }

    /**
     * @param values See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("nqssslgkrtdgiskh")
    public suspend fun crossRegionCopyRules(values: List<Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>>) {
        this.crossRegionCopyRules = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ncuhcybjxbvnwquc")
    public suspend fun deprecateRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs>) {
        this.deprecateRule = value
    }

    /**
     * @param value See the `fast_restore_rule` block. Max of 1 per schedule.
     */
    @JvmName("jmnxctdmehocwsfc")
    public suspend fun fastRestoreRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs>) {
        this.fastRestoreRule = value
    }

    /**
     * @param value
     */
    @JvmName("rrpimyriturdlrcs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("nyvetgymteicsrcv")
    public suspend fun retainRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs>) {
        this.retainRule = value
    }

    /**
     * @param value See the `share_rule` block. Max of 1 per schedule.
     */
    @JvmName("sqxcjafqdeeuandb")
    public suspend fun shareRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleShareRuleArgs>) {
        this.shareRule = value
    }

    /**
     * @param value A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
     */
    @JvmName("iiiarknlhbupmouu")
    public suspend fun tagsToAdd(`value`: Output<Map<String, String>>) {
        this.tagsToAdd = value
    }

    /**
     * @param value A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
     */
    @JvmName("jgudnsytwuntpppe")
    public suspend fun variableTags(`value`: Output<Map<String, String>>) {
        this.variableTags = value
    }

    /**
     * @param value
     */
    @JvmName("pbggsbshaqlaahix")
    public suspend fun copyTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTags = mapped
    }

    /**
     * @param value See the `create_rule` block. Max of 1 per schedule.
     */
    @JvmName("exjdwqgndaqierup")
    public suspend fun createRule(`value`: LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createRule = mapped
    }

    /**
     * @param argument See the `create_rule` block. Max of 1 per schedule.
     */
    @JvmName("tmiklxjqncpjeajp")
    public suspend fun createRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleCreateRuleArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsScheduleCreateRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.createRule = mapped
    }

    /**
     * @param value See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("vpngiqnokmxdriib")
    public suspend fun crossRegionCopyRules(`value`: List<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossRegionCopyRules = mapped
    }

    /**
     * @param argument See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("scqvenilvqesesgh")
    public suspend fun crossRegionCopyRules(argument: List<suspend LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.crossRegionCopyRules = mapped
    }

    /**
     * @param argument See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("qkqtodrwgfqvjdel")
    public suspend fun crossRegionCopyRules(vararg argument: suspend LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.crossRegionCopyRules = mapped
    }

    /**
     * @param argument See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("oqqbymcncwofhcjd")
    public suspend fun crossRegionCopyRules(argument: suspend LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.crossRegionCopyRules = mapped
    }

    /**
     * @param values See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("wiprsahilntpkebn")
    public suspend fun crossRegionCopyRules(vararg values: LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.crossRegionCopyRules = mapped
    }

    /**
     * @param value
     */
    @JvmName("aewxkvoawxurocyy")
    public suspend fun deprecateRule(`value`: LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprecateRule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qssigxkqiapnrfkr")
    public suspend fun deprecateRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deprecateRule = mapped
    }

    /**
     * @param value See the `fast_restore_rule` block. Max of 1 per schedule.
     */
    @JvmName("kcmhsttvkytkujmc")
    public suspend fun fastRestoreRule(`value`: LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fastRestoreRule = mapped
    }

    /**
     * @param argument See the `fast_restore_rule` block. Max of 1 per schedule.
     */
    @JvmName("fkhacbihqomyqaww")
    public suspend fun fastRestoreRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fastRestoreRule = mapped
    }

    /**
     * @param value
     */
    @JvmName("xtjhtughexbpsihs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("kxtctidgimokmtyl")
    public suspend fun retainRule(`value`: LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retainRule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pkgbylfoaoeefjue")
    public suspend fun retainRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleRetainRuleArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsScheduleRetainRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.retainRule = mapped
    }

    /**
     * @param value See the `share_rule` block. Max of 1 per schedule.
     */
    @JvmName("axekoxjtbakyjllm")
    public suspend fun shareRule(`value`: LifecyclePolicyPolicyDetailsScheduleShareRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareRule = mapped
    }

    /**
     * @param argument See the `share_rule` block. Max of 1 per schedule.
     */
    @JvmName("aeevkatricxqbhgk")
    public suspend fun shareRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleShareRuleArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsScheduleShareRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.shareRule = mapped
    }

    /**
     * @param value A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
     */
    @JvmName("qliuqbvquidiogux")
    public suspend fun tagsToAdd(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagsToAdd = mapped
    }

    /**
     * @param values A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
     */
    @JvmName("knrifpjnsapxhvgn")
    public fun tagsToAdd(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagsToAdd = mapped
    }

    /**
     * @param value A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
     */
    @JvmName("nxpixjmesekpibtv")
    public suspend fun variableTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableTags = mapped
    }

    /**
     * @param values A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
     */
    @JvmName("wrldvlutfkcmbiiu")
    public fun variableTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variableTags = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsScheduleArgs =
        LifecyclePolicyPolicyDetailsScheduleArgs(
            copyTags = copyTags,
            createRule = createRule ?: throw PulumiNullFieldException("createRule"),
            crossRegionCopyRules = crossRegionCopyRules,
            deprecateRule = deprecateRule,
            fastRestoreRule = fastRestoreRule,
            name = name ?: throw PulumiNullFieldException("name"),
            retainRule = retainRule ?: throw PulumiNullFieldException("retainRule"),
            shareRule = shareRule,
            tagsToAdd = tagsToAdd,
            variableTags = variableTags,
        )
}
