@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cmkArn
 * @property copyTags
 * @property deprecateRule
 * @property encrypted
 * @property retainRule
 * @property target
 */
public data class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs(
    public val cmkArn: Output<String>? = null,
    public val copyTags: Output<Boolean>? = null,
    public val deprecateRule: Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgs>? = null,
    public val encrypted: Output<Boolean>,
    public val retainRule: Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs>? = null,
    public val target: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs> {
    override fun toJava(): com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs.builder()
            .cmkArn(cmkArn?.applyValue({ args0 -> args0 }))
            .copyTags(copyTags?.applyValue({ args0 -> args0 }))
            .deprecateRule(deprecateRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encrypted(encrypted.applyValue({ args0 -> args0 }))
            .retainRule(retainRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder internal constructor() {
    private var cmkArn: Output<String>? = null

    private var copyTags: Output<Boolean>? = null

    private var deprecateRule:
        Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgs>? = null

    private var encrypted: Output<Boolean>? = null

    private var retainRule:
        Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs>? = null

    private var target: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("fngjdwwxlclyxdei")
    public suspend fun cmkArn(`value`: Output<String>) {
        this.cmkArn = value
    }

    /**
     * @param value
     */
    @JvmName("gjcgfqncorqeltrc")
    public suspend fun copyTags(`value`: Output<Boolean>) {
        this.copyTags = value
    }

    /**
     * @param value
     */
    @JvmName("cnrxxxgjmrhokmtf")
    public suspend fun deprecateRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgs>) {
        this.deprecateRule = value
    }

    /**
     * @param value
     */
    @JvmName("ajjmgcfcflbuejdv")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value
     */
    @JvmName("ldtrfaukvgpjrcuk")
    public suspend fun retainRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs>) {
        this.retainRule = value
    }

    /**
     * @param value
     */
    @JvmName("iwlwsjxiwrqdegqr")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value
     */
    @JvmName("irxgfxobeimmhmsn")
    public suspend fun cmkArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cmkArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("twfapbhthkyawobl")
    public suspend fun copyTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTags = mapped
    }

    /**
     * @param value
     */
    @JvmName("lqioybmsjfcfurdc")
    public suspend fun deprecateRule(`value`: LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprecateRule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wtxmxkquiibaahwu")
    public suspend fun deprecateRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.deprecateRule = mapped
    }

    /**
     * @param value
     */
    @JvmName("hcyertqxpcxlflht")
    public suspend fun encrypted(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value
     */
    @JvmName("xtcbalushviyphlo")
    public suspend fun retainRule(`value`: LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainRule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dwlruykebxjjtsvn")
    public suspend fun retainRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.retainRule = mapped
    }

    /**
     * @param value
     */
    @JvmName("dxqkrinxxfyrhscu")
    public suspend fun target(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs =
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs(
            cmkArn = cmkArn,
            copyTags = copyTags,
            deprecateRule = deprecateRule,
            encrypted = encrypted ?: throw PulumiNullFieldException("encrypted"),
            retainRule = retainRule,
            target = target ?: throw PulumiNullFieldException("target"),
        )
}
