@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property count
 * @property interval
 * @property intervalUnit
 */
public data class LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs(
    public val count: Output<Int>? = null,
    public val interval: Output<Int>? = null,
    public val intervalUnit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs> {
    override fun toJava(): com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .intervalUnit(intervalUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var interval: Output<Int>? = null

    private var intervalUnit: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("gdhflepfgpbbggvv")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value
     */
    @JvmName("amwutrrvaqfrajyh")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value
     */
    @JvmName("spvtgglmdhjukpyg")
    public suspend fun intervalUnit(`value`: Output<String>) {
        this.intervalUnit = value
    }

    /**
     * @param value
     */
    @JvmName("umrngktqqjhifwsk")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value
     */
    @JvmName("cnosgnbgiidhmrwv")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value
     */
    @JvmName("dnmxyqeekhdqiukg")
    public suspend fun intervalUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalUnit = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs =
        LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs(
            count = count,
            interval = interval,
            intervalUnit = intervalUnit,
        )
}
