@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleShareRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property targetAccounts The IDs of the AWS accounts with which to share the snapshots.
 * @property unshareInterval
 * @property unshareIntervalUnit
 */
public data class LifecyclePolicyPolicyDetailsScheduleShareRuleArgs(
    public val targetAccounts: Output<List<String>>,
    public val unshareInterval: Output<Int>? = null,
    public val unshareIntervalUnit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleShareRuleArgs> {
    override fun toJava(): com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleShareRuleArgs = com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleShareRuleArgs.builder()
        .targetAccounts(targetAccounts.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .unshareInterval(unshareInterval?.applyValue({ args0 -> args0 }))
        .unshareIntervalUnit(unshareIntervalUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsScheduleShareRuleArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsScheduleShareRuleArgsBuilder internal constructor() {
    private var targetAccounts: Output<List<String>>? = null

    private var unshareInterval: Output<Int>? = null

    private var unshareIntervalUnit: Output<String>? = null

    /**
     * @param value The IDs of the AWS accounts with which to share the snapshots.
     */
    @JvmName("eprmdlbupkyqwypv")
    public suspend fun targetAccounts(`value`: Output<List<String>>) {
        this.targetAccounts = value
    }

    @JvmName("oxgwrwskhkfmucah")
    public suspend fun targetAccounts(vararg values: Output<String>) {
        this.targetAccounts = Output.all(values.asList())
    }

    /**
     * @param values The IDs of the AWS accounts with which to share the snapshots.
     */
    @JvmName("uiagbdaueggrjfbq")
    public suspend fun targetAccounts(values: List<Output<String>>) {
        this.targetAccounts = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ahwpvgbixdugpdyt")
    public suspend fun unshareInterval(`value`: Output<Int>) {
        this.unshareInterval = value
    }

    /**
     * @param value
     */
    @JvmName("mdmiqewotpwfvkkd")
    public suspend fun unshareIntervalUnit(`value`: Output<String>) {
        this.unshareIntervalUnit = value
    }

    /**
     * @param value The IDs of the AWS accounts with which to share the snapshots.
     */
    @JvmName("rrxfxpafcwpomojl")
    public suspend fun targetAccounts(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetAccounts = mapped
    }

    /**
     * @param values The IDs of the AWS accounts with which to share the snapshots.
     */
    @JvmName("yhxqjybxopqywutq")
    public suspend fun targetAccounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetAccounts = mapped
    }

    /**
     * @param value
     */
    @JvmName("gdjhqqirqdmohtki")
    public suspend fun unshareInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unshareInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("swxbvvrvwoqmcjsd")
    public suspend fun unshareIntervalUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unshareIntervalUnit = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsScheduleShareRuleArgs =
        LifecyclePolicyPolicyDetailsScheduleShareRuleArgs(
            targetAccounts = targetAccounts ?: throw PulumiNullFieldException("targetAccounts"),
            unshareInterval = unshareInterval,
            unshareIntervalUnit = unshareIntervalUnit,
        )
}
