@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property action The actions to be performed when the event-based policy is triggered. You can specify only one action per policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `action` configuration block.
 * @property eventSource The event that triggers the event-based policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `event_source` configuration block.
 * @property parameters
 * @property policyType The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY` to create an event-based policy that performs specific actions when a defined event occurs in your AWS account. Default value is `EBS_SNAPSHOT_MANAGEMENT`.
 * @property resourceLocations The location of the resources to backup. If the source resources are located in an AWS Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`. If you specify `OUTPOST`, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account. Valid values are `CLOUD` and `OUTPOST`.
 * @property resourceTypes A list of resource types that should be targeted by the lifecycle policy. Valid values are `VOLUME` and `INSTANCE`.
 * @property schedules See the `schedule` configuration block.
 * @property targetTags A map of tag keys and their values. Any resources that match the `resource_types` and are tagged with _any_ of these tags will be targeted.
 * > Note: You cannot have overlapping lifecycle policies that share the same `target_tags`. Pulumi is unable to detect this at plan time but it will fail during apply.
 */
public data class LifecyclePolicyPolicyDetails(
    public val action: LifecyclePolicyPolicyDetailsAction? = null,
    public val eventSource: LifecyclePolicyPolicyDetailsEventSource? = null,
    public val parameters: LifecyclePolicyPolicyDetailsParameters? = null,
    public val policyType: String? = null,
    public val resourceLocations: String? = null,
    public val resourceTypes: List<String>? = null,
    public val schedules: List<LifecyclePolicyPolicyDetailsSchedule>? = null,
    public val targetTags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetails): LifecyclePolicyPolicyDetails = LifecyclePolicyPolicyDetails(
            action = javaType.action().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsAction.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventSource = javaType.eventSource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsEventSource.Companion.toKotlin(args0)
                })
            }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
            resourceLocations = javaType.resourceLocations().map({ args0 -> args0 }).orElse(null),
            resourceTypes = javaType.resourceTypes().map({ args0 -> args0 }),
            schedules = javaType.schedules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsSchedule.Companion.toKotlin(args0)
                })
            }),
            targetTags = javaType.targetTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
