@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property excludeBootVolume Indicates whether to exclude the root volume from snapshots created using CreateSnapshots. The default is `false`.
 * @property noReboot Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle policy runs. `true` indicates that targeted instances are not rebooted when the policy runs. `false` indicates that target instances are rebooted when the policy runs. The default is `true` (instances are not rebooted).
 */
public data class LifecyclePolicyPolicyDetailsParameters(
    public val excludeBootVolume: Boolean? = null,
    public val noReboot: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetailsParameters): LifecyclePolicyPolicyDetailsParameters = LifecyclePolicyPolicyDetailsParameters(
            excludeBootVolume = javaType.excludeBootVolume().map({ args0 -> args0 }).orElse(null),
            noReboot = javaType.noReboot().map({ args0 -> args0 }).orElse(null),
        )
    }
}
