@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property copyTags
 * @property createRule See the `create_rule` block. Max of 1 per schedule.
 * @property crossRegionCopyRules See the `cross_region_copy_rule` block. Max of 3 per schedule.
 * @property deprecateRule
 * @property fastRestoreRule See the `fast_restore_rule` block. Max of 1 per schedule.
 * @property name
 * @property retainRule
 * @property shareRule See the `share_rule` block. Max of 1 per schedule.
 * @property tagsToAdd A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
 * @property variableTags A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
 */
public data class LifecyclePolicyPolicyDetailsSchedule(
    public val copyTags: Boolean? = null,
    public val createRule: LifecyclePolicyPolicyDetailsScheduleCreateRule,
    public val crossRegionCopyRules: List<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule>? =
        null,
    public val deprecateRule: LifecyclePolicyPolicyDetailsScheduleDeprecateRule? = null,
    public val fastRestoreRule: LifecyclePolicyPolicyDetailsScheduleFastRestoreRule? = null,
    public val name: String,
    public val retainRule: LifecyclePolicyPolicyDetailsScheduleRetainRule,
    public val shareRule: LifecyclePolicyPolicyDetailsScheduleShareRule? = null,
    public val tagsToAdd: Map<String, String>? = null,
    public val variableTags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetailsSchedule): LifecyclePolicyPolicyDetailsSchedule = LifecyclePolicyPolicyDetailsSchedule(
            copyTags = javaType.copyTags().map({ args0 -> args0 }).orElse(null),
            createRule = javaType.createRule().let({ args0 ->
                com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsScheduleCreateRule.Companion.toKotlin(args0)
            }),
            crossRegionCopyRules = javaType.crossRegionCopyRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule.Companion.toKotlin(args0)
                })
            }),
            deprecateRule = javaType.deprecateRule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsScheduleDeprecateRule.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fastRestoreRule = javaType.fastRestoreRule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsScheduleFastRestoreRule.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            retainRule = javaType.retainRule().let({ args0 ->
                com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsScheduleRetainRule.Companion.toKotlin(args0)
            }),
            shareRule = javaType.shareRule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsScheduleShareRule.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tagsToAdd = javaType.tagsToAdd().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            variableTags = javaType.variableTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
