@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones The Availability Zones in which to enable fast snapshot restore.
 * @property count
 * @property interval
 * @property intervalUnit
 */
public data class LifecyclePolicyPolicyDetailsScheduleFastRestoreRule(
    public val availabilityZones: List<String>,
    public val count: Int? = null,
    public val interval: Int? = null,
    public val intervalUnit: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetailsScheduleFastRestoreRule): LifecyclePolicyPolicyDetailsScheduleFastRestoreRule =
            LifecyclePolicyPolicyDetailsScheduleFastRestoreRule(
                availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
                count = javaType.count().map({ args0 -> args0 }).orElse(null),
                interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
                intervalUnit = javaType.intervalUnit().map({ args0 -> args0 }).orElse(null),
            )
    }
}
