@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property targetAccounts The IDs of the AWS accounts with which to share the snapshots.
 * @property unshareInterval
 * @property unshareIntervalUnit
 */
public data class LifecyclePolicyPolicyDetailsScheduleShareRule(
    public val targetAccounts: List<String>,
    public val unshareInterval: Int? = null,
    public val unshareIntervalUnit: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetailsScheduleShareRule): LifecyclePolicyPolicyDetailsScheduleShareRule =
            LifecyclePolicyPolicyDetailsScheduleShareRule(
                targetAccounts = javaType.targetAccounts().map({ args0 -> args0 }),
                unshareInterval = javaType.unshareInterval().map({ args0 -> args0 }).orElse(null),
                unshareIntervalUnit = javaType.unshareIntervalUnit().map({ args0 -> args0 }).orElse(null),
            )
    }
}
