@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.CertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DMS (Data Migration Service) certificate resource. DMS certificates can be created, deleted, and imported.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new certificate
 * const test = new aws.dms.Certificate("test", {
 *     certificateId: "test-dms-certificate-tf",
 *     certificatePem: "...",
 *     tags: {
 *         Name: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new certificate
 * test = aws.dms.Certificate("test",
 *     certificate_id="test-dms-certificate-tf",
 *     certificate_pem="...",
 *     tags={
 *         "Name": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new certificate
 *     var test = new Aws.Dms.Certificate("test", new()
 *     {
 *         CertificateId = "test-dms-certificate-tf",
 *         CertificatePem = "...",
 *         Tags =
 *         {
 *             { "Name", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new certificate
 * 		_, err := dms.NewCertificate(ctx, "test", &dms.CertificateArgs{
 * 			CertificateId:  pulumi.String("test-dms-certificate-tf"),
 * 			CertificatePem: pulumi.String("..."),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.Certificate;
 * import com.pulumi.aws.dms.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new certificate
 *         var test = new Certificate("test", CertificateArgs.builder()
 *             .certificateId("test-dms-certificate-tf")
 *             .certificatePem("...")
 *             .tags(Map.of("Name", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new certificate
 *   test:
 *     type: aws:dms:Certificate
 *     properties:
 *       certificateId: test-dms-certificate-tf
 *       certificatePem: '...'
 *       tags:
 *         Name: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import certificates using the `certificate_id`. For example:
 * ```sh
 * $ pulumi import aws:dms/certificate:Certificate test test-dms-certificate-tf
 * ```
 * @property certificateId The certificate identifier.
 * - Must contain from 1 to 255 alphanumeric characters and hyphens.
 * @property certificatePem The contents of the .pem X.509 certificate file for the certificate. Either `certificate_pem` or `certificate_wallet` must be set.
 * @property certificateWallet The contents of the Oracle Wallet certificate for use with SSL, provided as a base64-encoded String. Either `certificate_pem` or `certificate_wallet` must be set.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CertificateArgs(
    public val certificateId: Output<String>? = null,
    public val certificatePem: Output<String>? = null,
    public val certificateWallet: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.CertificateArgs> {
    override fun toJava(): com.pulumi.aws.dms.CertificateArgs =
        com.pulumi.aws.dms.CertificateArgs.builder()
            .certificateId(certificateId?.applyValue({ args0 -> args0 }))
            .certificatePem(certificatePem?.applyValue({ args0 -> args0 }))
            .certificateWallet(certificateWallet?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var certificateId: Output<String>? = null

    private var certificatePem: Output<String>? = null

    private var certificateWallet: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The certificate identifier.
     * - Must contain from 1 to 255 alphanumeric characters and hyphens.
     */
    @JvmName("ktjifbdmwlbqunlo")
    public suspend fun certificateId(`value`: Output<String>) {
        this.certificateId = value
    }

    /**
     * @param value The contents of the .pem X.509 certificate file for the certificate. Either `certificate_pem` or `certificate_wallet` must be set.
     */
    @JvmName("qifnrawpqhyknlry")
    public suspend fun certificatePem(`value`: Output<String>) {
        this.certificatePem = value
    }

    /**
     * @param value The contents of the Oracle Wallet certificate for use with SSL, provided as a base64-encoded String. Either `certificate_pem` or `certificate_wallet` must be set.
     */
    @JvmName("spnlnsnpxypyaxwp")
    public suspend fun certificateWallet(`value`: Output<String>) {
        this.certificateWallet = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xdkslmyswwoluwlc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The certificate identifier.
     * - Must contain from 1 to 255 alphanumeric characters and hyphens.
     */
    @JvmName("giuopxqgmluqrfwj")
    public suspend fun certificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateId = mapped
    }

    /**
     * @param value The contents of the .pem X.509 certificate file for the certificate. Either `certificate_pem` or `certificate_wallet` must be set.
     */
    @JvmName("bvyviwutfmbgxqwb")
    public suspend fun certificatePem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificatePem = mapped
    }

    /**
     * @param value The contents of the Oracle Wallet certificate for use with SSL, provided as a base64-encoded String. Either `certificate_pem` or `certificate_wallet` must be set.
     */
    @JvmName("plfquriyehjbeyxs")
    public suspend fun certificateWallet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateWallet = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hpwonhgqumapcavm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("txtfxwyeomgbhaeh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        certificateId = certificateId,
        certificatePem = certificatePem,
        certificateWallet = certificateWallet,
        tags = tags,
    )
}
