@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.kotlin.outputs.EndpointElasticsearchSettings
import com.pulumi.aws.dms.kotlin.outputs.EndpointKafkaSettings
import com.pulumi.aws.dms.kotlin.outputs.EndpointKinesisSettings
import com.pulumi.aws.dms.kotlin.outputs.EndpointMongodbSettings
import com.pulumi.aws.dms.kotlin.outputs.EndpointPostgresSettings
import com.pulumi.aws.dms.kotlin.outputs.EndpointRedisSettings
import com.pulumi.aws.dms.kotlin.outputs.EndpointRedshiftSettings
import com.pulumi.aws.dms.kotlin.outputs.EndpointS3Settings
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.dms.kotlin.outputs.EndpointElasticsearchSettings.Companion.toKotlin as endpointElasticsearchSettingsToKotlin
import com.pulumi.aws.dms.kotlin.outputs.EndpointKafkaSettings.Companion.toKotlin as endpointKafkaSettingsToKotlin
import com.pulumi.aws.dms.kotlin.outputs.EndpointKinesisSettings.Companion.toKotlin as endpointKinesisSettingsToKotlin
import com.pulumi.aws.dms.kotlin.outputs.EndpointMongodbSettings.Companion.toKotlin as endpointMongodbSettingsToKotlin
import com.pulumi.aws.dms.kotlin.outputs.EndpointPostgresSettings.Companion.toKotlin as endpointPostgresSettingsToKotlin
import com.pulumi.aws.dms.kotlin.outputs.EndpointRedisSettings.Companion.toKotlin as endpointRedisSettingsToKotlin
import com.pulumi.aws.dms.kotlin.outputs.EndpointRedshiftSettings.Companion.toKotlin as endpointRedshiftSettingsToKotlin
import com.pulumi.aws.dms.kotlin.outputs.EndpointS3Settings.Companion.toKotlin as endpointS3SettingsToKotlin

/**
 * Builder for [Endpoint].
 */
@PulumiTagMarker
public class EndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointArgs = EndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointArgsBuilder.() -> Unit) {
        val builder = EndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Endpoint {
        val builtJavaResource = com.pulumi.aws.dms.Endpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Endpoint(builtJavaResource)
    }
}

/**
 * Provides a DMS (Data Migration Service) endpoint resource. DMS endpoints can be created, updated, deleted, and imported.
 * > **Note:** All arguments including the password will be stored in the raw state as plain-text. > **Note:** The `s3_settings` argument is deprecated, may not be maintained, and will be removed in a future version. Use the `aws.dms.S3Endpoint` resource instead.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new endpoint
 * const test = new aws.dms.Endpoint("test", {
 *     certificateArn: "arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012",
 *     databaseName: "test",
 *     endpointId: "test-dms-endpoint-tf",
 *     endpointType: "source",
 *     engineName: "aurora",
 *     extraConnectionAttributes: "",
 *     kmsKeyArn: "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 *     password: "test",
 *     port: 3306,
 *     serverName: "test",
 *     sslMode: "none",
 *     tags: {
 *         Name: "test",
 *     },
 *     username: "test",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new endpoint
 * test = aws.dms.Endpoint("test",
 *     certificate_arn="arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012",
 *     database_name="test",
 *     endpoint_id="test-dms-endpoint-tf",
 *     endpoint_type="source",
 *     engine_name="aurora",
 *     extra_connection_attributes="",
 *     kms_key_arn="arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 *     password="test",
 *     port=3306,
 *     server_name="test",
 *     ssl_mode="none",
 *     tags={
 *         "Name": "test",
 *     },
 *     username="test")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new endpoint
 *     var test = new Aws.Dms.Endpoint("test", new()
 *     {
 *         CertificateArn = "arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012",
 *         DatabaseName = "test",
 *         EndpointId = "test-dms-endpoint-tf",
 *         EndpointType = "source",
 *         EngineName = "aurora",
 *         ExtraConnectionAttributes = "",
 *         KmsKeyArn = "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 *         Password = "test",
 *         Port = 3306,
 *         ServerName = "test",
 *         SslMode = "none",
 *         Tags =
 *         {
 *             { "Name", "test" },
 *         },
 *         Username = "test",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new endpoint
 * 		_, err := dms.NewEndpoint(ctx, "test", &dms.EndpointArgs{
 * 			CertificateArn:            pulumi.String("arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012"),
 * 			DatabaseName:              pulumi.String("test"),
 * 			EndpointId:                pulumi.String("test-dms-endpoint-tf"),
 * 			EndpointType:              pulumi.String("source"),
 * 			EngineName:                pulumi.String("aurora"),
 * 			ExtraConnectionAttributes: pulumi.String(""),
 * 			KmsKeyArn:                 pulumi.String("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012"),
 * 			Password:                  pulumi.String("test"),
 * 			Port:                      pulumi.Int(3306),
 * 			ServerName:                pulumi.String("test"),
 * 			SslMode:                   pulumi.String("none"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("test"),
 * 			},
 * 			Username: pulumi.String("test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.Endpoint;
 * import com.pulumi.aws.dms.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new endpoint
 *         var test = new Endpoint("test", EndpointArgs.builder()
 *             .certificateArn("arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012")
 *             .databaseName("test")
 *             .endpointId("test-dms-endpoint-tf")
 *             .endpointType("source")
 *             .engineName("aurora")
 *             .extraConnectionAttributes("")
 *             .kmsKeyArn("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012")
 *             .password("test")
 *             .port(3306)
 *             .serverName("test")
 *             .sslMode("none")
 *             .tags(Map.of("Name", "test"))
 *             .username("test")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new endpoint
 *   test:
 *     type: aws:dms:Endpoint
 *     properties:
 *       certificateArn: arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
 *       databaseName: test
 *       endpointId: test-dms-endpoint-tf
 *       endpointType: source
 *       engineName: aurora
 *       extraConnectionAttributes:
 *       kmsKeyArn: arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
 *       password: test
 *       port: 3306
 *       serverName: test
 *       sslMode: none
 *       tags:
 *         Name: test
 *       username: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import endpoints using the `endpoint_id`. For example:
 * ```sh
 * $ pulumi import aws:dms/endpoint:Endpoint test test-dms-endpoint-tf
 * ```
 */
public class Endpoint internal constructor(
    override val javaResource: com.pulumi.aws.dms.Endpoint,
) : KotlinCustomResource(javaResource, EndpointMapper) {
    /**
     * ARN for the certificate.
     */
    public val certificateArn: Output<String>
        get() = javaResource.certificateArn().applyValue({ args0 -> args0 })

    /**
     * Name of the endpoint database.
     */
    public val databaseName: Output<String>?
        get() = javaResource.databaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for OpenSearch settings. See below.
     */
    public val elasticsearchSettings: Output<EndpointElasticsearchSettings>?
        get() = javaResource.elasticsearchSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointElasticsearchSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ARN for the endpoint.
     */
    public val endpointArn: Output<String>
        get() = javaResource.endpointArn().applyValue({ args0 -> args0 })

    /**
     * Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     */
    public val endpointId: Output<String>
        get() = javaResource.endpointId().applyValue({ args0 -> args0 })

    /**
     * Type of endpoint. Valid values are `source`, `target`.
     */
    public val endpointType: Output<String>
        get() = javaResource.endpointType().applyValue({ args0 -> args0 })

    /**
     * Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`, `s3`, `sqlserver`, `sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
     */
    public val engineName: Output<String>
        get() = javaResource.engineName().applyValue({ args0 -> args0 })

    /**
     * Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs&#46;aws&#46;amazon&#46;com/dms/latest/userguide/CHAP_Source&#46;html)&#46; For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
     */
    public val extraConnectionAttributes: Output<String>
        get() = javaResource.extraConnectionAttributes().applyValue({ args0 -> args0 })

    /**
     * Configuration block for Kafka settings. See below.
     */
    public val kafkaSettings: Output<EndpointKafkaSettings>?
        get() = javaResource.kafkaSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointKafkaSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for Kinesis settings. See below.
     */
    public val kinesisSettings: Output<EndpointKinesisSettings>?
        get() = javaResource.kinesisSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointKinesisSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. To encrypt an S3 target with a KMS Key, use the parameter `s3_settings.server_side_encryption_kms_key_id`. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.
     * The following arguments are optional:
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })

    /**
     * Configuration block for MongoDB settings. See below.
     */
    public val mongodbSettings: Output<EndpointMongodbSettings>?
        get() = javaResource.mongodbSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointMongodbSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Password to be used to login to the endpoint database.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val pauseReplicationTasks: Output<Boolean>?
        get() = javaResource.pauseReplicationTasks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Port used by the endpoint database.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block for Postgres settings. See below.
     */
    public val postgresSettings: Output<EndpointPostgresSettings>?
        get() = javaResource.postgresSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointPostgresSettingsToKotlin(args0) })
            }).orElse(null)
        })

    public val redisSettings: Output<EndpointRedisSettings>?
        get() = javaResource.redisSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointRedisSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for Redshift settings. See below.
     */
    public val redshiftSettings: Output<EndpointRedshiftSettings>
        get() = javaResource.redshiftSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                endpointRedshiftSettingsToKotlin(args0)
            })
        })

    /**
     * (**Deprecated**, use the `aws.dms.S3Endpoint` resource instead) Configuration block for S3 settings. See below.
     */
    public val s3Settings: Output<EndpointS3Settings>?
        get() = javaResource.s3Settings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    endpointS3SettingsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.
     * > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
     */
    public val secretsManagerAccessRoleArn: Output<String>?
        get() = javaResource.secretsManagerAccessRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
     */
    public val secretsManagerArn: Output<String>?
        get() = javaResource.secretsManagerArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Host name of the server.
     */
    public val serverName: Output<String>?
        get() = javaResource.serverName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN used by the service access IAM role for dynamodb endpoints.
     */
    public val serviceAccessRole: Output<String>?
        get() = javaResource.serviceAccessRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
     */
    public val sslMode: Output<String>
        get() = javaResource.sslMode().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * User name to be used to login to the endpoint database.
     */
    public val username: Output<String>?
        get() = javaResource.username().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object EndpointMapper : ResourceMapper<Endpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dms.Endpoint::class == javaResource::class

    override fun map(javaResource: Resource): Endpoint = Endpoint(
        javaResource as
            com.pulumi.aws.dms.Endpoint,
    )
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Endpoint].
 */
public suspend fun endpoint(name: String, block: suspend EndpointResourceBuilder.() -> Unit): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpoint(name: String): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
