@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.EndpointArgs.builder
import com.pulumi.aws.dms.kotlin.inputs.EndpointElasticsearchSettingsArgs
import com.pulumi.aws.dms.kotlin.inputs.EndpointElasticsearchSettingsArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.EndpointKafkaSettingsArgs
import com.pulumi.aws.dms.kotlin.inputs.EndpointKafkaSettingsArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.EndpointKinesisSettingsArgs
import com.pulumi.aws.dms.kotlin.inputs.EndpointKinesisSettingsArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.EndpointMongodbSettingsArgs
import com.pulumi.aws.dms.kotlin.inputs.EndpointMongodbSettingsArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.EndpointPostgresSettingsArgs
import com.pulumi.aws.dms.kotlin.inputs.EndpointPostgresSettingsArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.EndpointRedisSettingsArgs
import com.pulumi.aws.dms.kotlin.inputs.EndpointRedisSettingsArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.EndpointRedshiftSettingsArgs
import com.pulumi.aws.dms.kotlin.inputs.EndpointRedshiftSettingsArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.EndpointS3SettingsArgs
import com.pulumi.aws.dms.kotlin.inputs.EndpointS3SettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DMS (Data Migration Service) endpoint resource. DMS endpoints can be created, updated, deleted, and imported.
 * > **Note:** All arguments including the password will be stored in the raw state as plain-text. > **Note:** The `s3_settings` argument is deprecated, may not be maintained, and will be removed in a future version. Use the `aws.dms.S3Endpoint` resource instead.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new endpoint
 * const test = new aws.dms.Endpoint("test", {
 *     certificateArn: "arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012",
 *     databaseName: "test",
 *     endpointId: "test-dms-endpoint-tf",
 *     endpointType: "source",
 *     engineName: "aurora",
 *     extraConnectionAttributes: "",
 *     kmsKeyArn: "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 *     password: "test",
 *     port: 3306,
 *     serverName: "test",
 *     sslMode: "none",
 *     tags: {
 *         Name: "test",
 *     },
 *     username: "test",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new endpoint
 * test = aws.dms.Endpoint("test",
 *     certificate_arn="arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012",
 *     database_name="test",
 *     endpoint_id="test-dms-endpoint-tf",
 *     endpoint_type="source",
 *     engine_name="aurora",
 *     extra_connection_attributes="",
 *     kms_key_arn="arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 *     password="test",
 *     port=3306,
 *     server_name="test",
 *     ssl_mode="none",
 *     tags={
 *         "Name": "test",
 *     },
 *     username="test")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new endpoint
 *     var test = new Aws.Dms.Endpoint("test", new()
 *     {
 *         CertificateArn = "arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012",
 *         DatabaseName = "test",
 *         EndpointId = "test-dms-endpoint-tf",
 *         EndpointType = "source",
 *         EngineName = "aurora",
 *         ExtraConnectionAttributes = "",
 *         KmsKeyArn = "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 *         Password = "test",
 *         Port = 3306,
 *         ServerName = "test",
 *         SslMode = "none",
 *         Tags =
 *         {
 *             { "Name", "test" },
 *         },
 *         Username = "test",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new endpoint
 * 		_, err := dms.NewEndpoint(ctx, "test", &dms.EndpointArgs{
 * 			CertificateArn:            pulumi.String("arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012"),
 * 			DatabaseName:              pulumi.String("test"),
 * 			EndpointId:                pulumi.String("test-dms-endpoint-tf"),
 * 			EndpointType:              pulumi.String("source"),
 * 			EngineName:                pulumi.String("aurora"),
 * 			ExtraConnectionAttributes: pulumi.String(""),
 * 			KmsKeyArn:                 pulumi.String("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012"),
 * 			Password:                  pulumi.String("test"),
 * 			Port:                      pulumi.Int(3306),
 * 			ServerName:                pulumi.String("test"),
 * 			SslMode:                   pulumi.String("none"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("test"),
 * 			},
 * 			Username: pulumi.String("test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.Endpoint;
 * import com.pulumi.aws.dms.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new endpoint
 *         var test = new Endpoint("test", EndpointArgs.builder()
 *             .certificateArn("arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012")
 *             .databaseName("test")
 *             .endpointId("test-dms-endpoint-tf")
 *             .endpointType("source")
 *             .engineName("aurora")
 *             .extraConnectionAttributes("")
 *             .kmsKeyArn("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012")
 *             .password("test")
 *             .port(3306)
 *             .serverName("test")
 *             .sslMode("none")
 *             .tags(Map.of("Name", "test"))
 *             .username("test")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new endpoint
 *   test:
 *     type: aws:dms:Endpoint
 *     properties:
 *       certificateArn: arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
 *       databaseName: test
 *       endpointId: test-dms-endpoint-tf
 *       endpointType: source
 *       engineName: aurora
 *       extraConnectionAttributes:
 *       kmsKeyArn: arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
 *       password: test
 *       port: 3306
 *       serverName: test
 *       sslMode: none
 *       tags:
 *         Name: test
 *       username: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import endpoints using the `endpoint_id`. For example:
 * ```sh
 * $ pulumi import aws:dms/endpoint:Endpoint test test-dms-endpoint-tf
 * ```
 * @property certificateArn ARN for the certificate.
 * @property databaseName Name of the endpoint database.
 * @property elasticsearchSettings Configuration block for OpenSearch settings. See below.
 * @property endpointId Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
 * @property endpointType Type of endpoint. Valid values are `source`, `target`.
 * @property engineName Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`, `s3`, `sqlserver`, `sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
 * @property extraConnectionAttributes Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs&#46;aws&#46;amazon&#46;com/dms/latest/userguide/CHAP_Source&#46;html)&#46; For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
 * @property kafkaSettings Configuration block for Kafka settings. See below.
 * @property kinesisSettings Configuration block for Kinesis settings. See below.
 * @property kmsKeyArn ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. To encrypt an S3 target with a KMS Key, use the parameter `s3_settings.server_side_encryption_kms_key_id`. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.
 * The following arguments are optional:
 * @property mongodbSettings Configuration block for MongoDB settings. See below.
 * @property password Password to be used to login to the endpoint database.
 * @property pauseReplicationTasks
 * @property port Port used by the endpoint database.
 * @property postgresSettings Configuration block for Postgres settings. See below.
 * @property redisSettings
 * @property redshiftSettings Configuration block for Redshift settings. See below.
 * @property s3Settings (**Deprecated**, use the `aws.dms.S3Endpoint` resource instead) Configuration block for S3 settings. See below.
 * @property secretsManagerAccessRoleArn ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.
 * > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
 * @property secretsManagerArn Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
 * @property serverName Host name of the server.
 * @property serviceAccessRole ARN used by the service access IAM role for dynamodb endpoints.
 * @property sslMode SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property username User name to be used to login to the endpoint database.
 */
public data class EndpointArgs(
    public val certificateArn: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val elasticsearchSettings: Output<EndpointElasticsearchSettingsArgs>? = null,
    public val endpointId: Output<String>? = null,
    public val endpointType: Output<String>? = null,
    public val engineName: Output<String>? = null,
    public val extraConnectionAttributes: Output<String>? = null,
    public val kafkaSettings: Output<EndpointKafkaSettingsArgs>? = null,
    public val kinesisSettings: Output<EndpointKinesisSettingsArgs>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val mongodbSettings: Output<EndpointMongodbSettingsArgs>? = null,
    public val password: Output<String>? = null,
    public val pauseReplicationTasks: Output<Boolean>? = null,
    public val port: Output<Int>? = null,
    public val postgresSettings: Output<EndpointPostgresSettingsArgs>? = null,
    public val redisSettings: Output<EndpointRedisSettingsArgs>? = null,
    public val redshiftSettings: Output<EndpointRedshiftSettingsArgs>? = null,
    public val s3Settings: Output<EndpointS3SettingsArgs>? = null,
    public val secretsManagerAccessRoleArn: Output<String>? = null,
    public val secretsManagerArn: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val serviceAccessRole: Output<String>? = null,
    public val sslMode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.EndpointArgs> {
    override fun toJava(): com.pulumi.aws.dms.EndpointArgs = com.pulumi.aws.dms.EndpointArgs.builder()
        .certificateArn(certificateArn?.applyValue({ args0 -> args0 }))
        .databaseName(databaseName?.applyValue({ args0 -> args0 }))
        .elasticsearchSettings(
            elasticsearchSettings?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .endpointId(endpointId?.applyValue({ args0 -> args0 }))
        .endpointType(endpointType?.applyValue({ args0 -> args0 }))
        .engineName(engineName?.applyValue({ args0 -> args0 }))
        .extraConnectionAttributes(extraConnectionAttributes?.applyValue({ args0 -> args0 }))
        .kafkaSettings(kafkaSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .kinesisSettings(kinesisSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
        .mongodbSettings(mongodbSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .password(password?.applyValue({ args0 -> args0 }))
        .pauseReplicationTasks(pauseReplicationTasks?.applyValue({ args0 -> args0 }))
        .port(port?.applyValue({ args0 -> args0 }))
        .postgresSettings(postgresSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .redisSettings(redisSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .redshiftSettings(redshiftSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .s3Settings(s3Settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .secretsManagerAccessRoleArn(secretsManagerAccessRoleArn?.applyValue({ args0 -> args0 }))
        .secretsManagerArn(secretsManagerArn?.applyValue({ args0 -> args0 }))
        .serverName(serverName?.applyValue({ args0 -> args0 }))
        .serviceAccessRole(serviceAccessRole?.applyValue({ args0 -> args0 }))
        .sslMode(sslMode?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var certificateArn: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var elasticsearchSettings: Output<EndpointElasticsearchSettingsArgs>? = null

    private var endpointId: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var engineName: Output<String>? = null

    private var extraConnectionAttributes: Output<String>? = null

    private var kafkaSettings: Output<EndpointKafkaSettingsArgs>? = null

    private var kinesisSettings: Output<EndpointKinesisSettingsArgs>? = null

    private var kmsKeyArn: Output<String>? = null

    private var mongodbSettings: Output<EndpointMongodbSettingsArgs>? = null

    private var password: Output<String>? = null

    private var pauseReplicationTasks: Output<Boolean>? = null

    private var port: Output<Int>? = null

    private var postgresSettings: Output<EndpointPostgresSettingsArgs>? = null

    private var redisSettings: Output<EndpointRedisSettingsArgs>? = null

    private var redshiftSettings: Output<EndpointRedshiftSettingsArgs>? = null

    private var s3Settings: Output<EndpointS3SettingsArgs>? = null

    private var secretsManagerAccessRoleArn: Output<String>? = null

    private var secretsManagerArn: Output<String>? = null

    private var serverName: Output<String>? = null

    private var serviceAccessRole: Output<String>? = null

    private var sslMode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var username: Output<String>? = null

    /**
     * @param value ARN for the certificate.
     */
    @JvmName("pidlgqjhncnecdxv")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value Name of the endpoint database.
     */
    @JvmName("sddrisjnktuvsfmu")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Configuration block for OpenSearch settings. See below.
     */
    @JvmName("dsayecrggvrbqbjx")
    public suspend fun elasticsearchSettings(`value`: Output<EndpointElasticsearchSettingsArgs>) {
        this.elasticsearchSettings = value
    }

    /**
     * @param value Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     */
    @JvmName("kseadjosxepykfxe")
    public suspend fun endpointId(`value`: Output<String>) {
        this.endpointId = value
    }

    /**
     * @param value Type of endpoint. Valid values are `source`, `target`.
     */
    @JvmName("edjxoujgoijjuucg")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`, `s3`, `sqlserver`, `sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
     */
    @JvmName("jaugdkkudxxrqpgs")
    public suspend fun engineName(`value`: Output<String>) {
        this.engineName = value
    }

    /**
     * @param value Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs&#46;aws&#46;amazon&#46;com/dms/latest/userguide/CHAP_Source&#46;html)&#46; For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
     */
    @JvmName("itthwfypwtkddlwm")
    public suspend fun extraConnectionAttributes(`value`: Output<String>) {
        this.extraConnectionAttributes = value
    }

    /**
     * @param value Configuration block for Kafka settings. See below.
     */
    @JvmName("qnustexmchlfssdl")
    public suspend fun kafkaSettings(`value`: Output<EndpointKafkaSettingsArgs>) {
        this.kafkaSettings = value
    }

    /**
     * @param value Configuration block for Kinesis settings. See below.
     */
    @JvmName("npghyihtjkbpikwr")
    public suspend fun kinesisSettings(`value`: Output<EndpointKinesisSettingsArgs>) {
        this.kinesisSettings = value
    }

    /**
     * @param value ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. To encrypt an S3 target with a KMS Key, use the parameter `s3_settings.server_side_encryption_kms_key_id`. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.
     * The following arguments are optional:
     */
    @JvmName("qiojiacrnrgstcjq")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Configuration block for MongoDB settings. See below.
     */
    @JvmName("bhbfctumuwikxrxi")
    public suspend fun mongodbSettings(`value`: Output<EndpointMongodbSettingsArgs>) {
        this.mongodbSettings = value
    }

    /**
     * @param value Password to be used to login to the endpoint database.
     */
    @JvmName("iirypqhaevlirxkr")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value
     */
    @JvmName("ukjfpvkokjfqitwg")
    public suspend fun pauseReplicationTasks(`value`: Output<Boolean>) {
        this.pauseReplicationTasks = value
    }

    /**
     * @param value Port used by the endpoint database.
     */
    @JvmName("eainqmxcfebnnfpj")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Configuration block for Postgres settings. See below.
     */
    @JvmName("hymybfdqnqawfdnp")
    public suspend fun postgresSettings(`value`: Output<EndpointPostgresSettingsArgs>) {
        this.postgresSettings = value
    }

    /**
     * @param value
     */
    @JvmName("pmlgcueeosmqqnvx")
    public suspend fun redisSettings(`value`: Output<EndpointRedisSettingsArgs>) {
        this.redisSettings = value
    }

    /**
     * @param value Configuration block for Redshift settings. See below.
     */
    @JvmName("vqmxstwhviwyqrce")
    public suspend fun redshiftSettings(`value`: Output<EndpointRedshiftSettingsArgs>) {
        this.redshiftSettings = value
    }

    /**
     * @param value (**Deprecated**, use the `aws.dms.S3Endpoint` resource instead) Configuration block for S3 settings. See below.
     */
    @JvmName("lmbknmhakunpechp")
    public suspend fun s3Settings(`value`: Output<EndpointS3SettingsArgs>) {
        this.s3Settings = value
    }

    /**
     * @param value ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.
     * > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
     */
    @JvmName("asmnvuvfncieblkk")
    public suspend fun secretsManagerAccessRoleArn(`value`: Output<String>) {
        this.secretsManagerAccessRoleArn = value
    }

    /**
     * @param value Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
     */
    @JvmName("pomdqlohtpmauvcu")
    public suspend fun secretsManagerArn(`value`: Output<String>) {
        this.secretsManagerArn = value
    }

    /**
     * @param value Host name of the server.
     */
    @JvmName("kirauinobndilbeq")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value ARN used by the service access IAM role for dynamodb endpoints.
     */
    @JvmName("yflvhqtcotnnfmme")
    public suspend fun serviceAccessRole(`value`: Output<String>) {
        this.serviceAccessRole = value
    }

    /**
     * @param value SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
     */
    @JvmName("fptiwjcopyjjqnyb")
    public suspend fun sslMode(`value`: Output<String>) {
        this.sslMode = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lvxmqiichubgenxc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value User name to be used to login to the endpoint database.
     */
    @JvmName("susschhgxvwlhngc")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value ARN for the certificate.
     */
    @JvmName("akeqpfkdmykyufty")
    public suspend fun certificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value Name of the endpoint database.
     */
    @JvmName("aslhegsqvcukovgk")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Configuration block for OpenSearch settings. See below.
     */
    @JvmName("dglfkscufofpcsra")
    public suspend fun elasticsearchSettings(`value`: EndpointElasticsearchSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchSettings = mapped
    }

    /**
     * @param argument Configuration block for OpenSearch settings. See below.
     */
    @JvmName("diavxgdsohgmwraj")
    public suspend fun elasticsearchSettings(argument: suspend EndpointElasticsearchSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointElasticsearchSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.elasticsearchSettings = mapped
    }

    /**
     * @param value Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     */
    @JvmName("rhtibfovlfspkhwu")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointId = mapped
    }

    /**
     * @param value Type of endpoint. Valid values are `source`, `target`.
     */
    @JvmName("aupxxnoymppvumdk")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`, `s3`, `sqlserver`, `sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
     */
    @JvmName("jvjmdwbfxngbhylb")
    public suspend fun engineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineName = mapped
    }

    /**
     * @param value Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs&#46;aws&#46;amazon&#46;com/dms/latest/userguide/CHAP_Source&#46;html)&#46; For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
     */
    @JvmName("scdylrmvfbtuariu")
    public suspend fun extraConnectionAttributes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extraConnectionAttributes = mapped
    }

    /**
     * @param value Configuration block for Kafka settings. See below.
     */
    @JvmName("xphjyyuomjeytacu")
    public suspend fun kafkaSettings(`value`: EndpointKafkaSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaSettings = mapped
    }

    /**
     * @param argument Configuration block for Kafka settings. See below.
     */
    @JvmName("qfxtkrdfxafdxbhn")
    public suspend fun kafkaSettings(argument: suspend EndpointKafkaSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointKafkaSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kafkaSettings = mapped
    }

    /**
     * @param value Configuration block for Kinesis settings. See below.
     */
    @JvmName("lpncwnctvkjrdkwo")
    public suspend fun kinesisSettings(`value`: EndpointKinesisSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisSettings = mapped
    }

    /**
     * @param argument Configuration block for Kinesis settings. See below.
     */
    @JvmName("xxqhckehuklyqskr")
    public suspend fun kinesisSettings(argument: suspend EndpointKinesisSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointKinesisSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kinesisSettings = mapped
    }

    /**
     * @param value ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. To encrypt an S3 target with a KMS Key, use the parameter `s3_settings.server_side_encryption_kms_key_id`. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.
     * The following arguments are optional:
     */
    @JvmName("gxqtbtfxkpuvorxk")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Configuration block for MongoDB settings. See below.
     */
    @JvmName("wgsbuwcnacjqhdpq")
    public suspend fun mongodbSettings(`value`: EndpointMongodbSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mongodbSettings = mapped
    }

    /**
     * @param argument Configuration block for MongoDB settings. See below.
     */
    @JvmName("fcihillpiidodfnh")
    public suspend fun mongodbSettings(argument: suspend EndpointMongodbSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointMongodbSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mongodbSettings = mapped
    }

    /**
     * @param value Password to be used to login to the endpoint database.
     */
    @JvmName("uyebeljarijrkcoc")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value
     */
    @JvmName("qoucmanpoxqbmmqc")
    public suspend fun pauseReplicationTasks(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pauseReplicationTasks = mapped
    }

    /**
     * @param value Port used by the endpoint database.
     */
    @JvmName("xrwgvujmurguwjlo")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Configuration block for Postgres settings. See below.
     */
    @JvmName("daitryygwppkyipt")
    public suspend fun postgresSettings(`value`: EndpointPostgresSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postgresSettings = mapped
    }

    /**
     * @param argument Configuration block for Postgres settings. See below.
     */
    @JvmName("vxxhgqslnosgyxvo")
    public suspend fun postgresSettings(argument: suspend EndpointPostgresSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointPostgresSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.postgresSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("ruidqwqmxphbqlje")
    public suspend fun redisSettings(`value`: EndpointRedisSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redisSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ayohecuqhxudbhgw")
    public suspend fun redisSettings(argument: suspend EndpointRedisSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointRedisSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redisSettings = mapped
    }

    /**
     * @param value Configuration block for Redshift settings. See below.
     */
    @JvmName("dofhllqvgrmgbecv")
    public suspend fun redshiftSettings(`value`: EndpointRedshiftSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshiftSettings = mapped
    }

    /**
     * @param argument Configuration block for Redshift settings. See below.
     */
    @JvmName("yrdrxecsgayacvdh")
    public suspend fun redshiftSettings(argument: suspend EndpointRedshiftSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointRedshiftSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redshiftSettings = mapped
    }

    /**
     * @param value (**Deprecated**, use the `aws.dms.S3Endpoint` resource instead) Configuration block for S3 settings. See below.
     */
    @JvmName("eovptxgukylpmrmp")
    public suspend fun s3Settings(`value`: EndpointS3SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Settings = mapped
    }

    /**
     * @param argument (**Deprecated**, use the `aws.dms.S3Endpoint` resource instead) Configuration block for S3 settings. See below.
     */
    @JvmName("kgvmxafjvcmctrwk")
    public suspend fun s3Settings(argument: suspend EndpointS3SettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointS3SettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3Settings = mapped
    }

    /**
     * @param value ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.
     * > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
     */
    @JvmName("ertiuiakcqxhyswj")
    public suspend fun secretsManagerAccessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsManagerAccessRoleArn = mapped
    }

    /**
     * @param value Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
     */
    @JvmName("obwaipbjavmtuqyt")
    public suspend fun secretsManagerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsManagerArn = mapped
    }

    /**
     * @param value Host name of the server.
     */
    @JvmName("yyrrllrdhwtlatug")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value ARN used by the service access IAM role for dynamodb endpoints.
     */
    @JvmName("xepeihdndluxtdbo")
    public suspend fun serviceAccessRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccessRole = mapped
    }

    /**
     * @param value SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
     */
    @JvmName("ulnrwwwtgbrndnrq")
    public suspend fun sslMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslMode = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cwfxlqfykrbicsnm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fdieslutgircqlug")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value User name to be used to login to the endpoint database.
     */
    @JvmName("lbydmveuljineeen")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        certificateArn = certificateArn,
        databaseName = databaseName,
        elasticsearchSettings = elasticsearchSettings,
        endpointId = endpointId,
        endpointType = endpointType,
        engineName = engineName,
        extraConnectionAttributes = extraConnectionAttributes,
        kafkaSettings = kafkaSettings,
        kinesisSettings = kinesisSettings,
        kmsKeyArn = kmsKeyArn,
        mongodbSettings = mongodbSettings,
        password = password,
        pauseReplicationTasks = pauseReplicationTasks,
        port = port,
        postgresSettings = postgresSettings,
        redisSettings = redisSettings,
        redshiftSettings = redshiftSettings,
        s3Settings = s3Settings,
        secretsManagerAccessRoleArn = secretsManagerAccessRoleArn,
        secretsManagerArn = secretsManagerArn,
        serverName = serverName,
        serviceAccessRole = serviceAccessRole,
        sslMode = sslMode,
        tags = tags,
        username = username,
    )
}
