@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [EventSubscription].
 */
@PulumiTagMarker
public class EventSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventSubscriptionArgs = EventSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventSubscriptionArgsBuilder.() -> Unit) {
        val builder = EventSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventSubscription {
        val builtJavaResource = com.pulumi.aws.dms.EventSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventSubscription(builtJavaResource)
    }
}

/**
 * Provides a DMS (Data Migration Service) event subscription resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dms.EventSubscription("example", {
 *     enabled: true,
 *     eventCategories: [
 *         "creation",
 *         "failure",
 *     ],
 *     name: "my-favorite-event-subscription",
 *     snsTopicArn: exampleAwsSnsTopic.arn,
 *     sourceIds: [exampleAwsDmsReplicationTask&#46;replicationTaskId],
 *     sourceType: "replication-task",
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dms.EventSubscription("example",
 *     enabled=True,
 *     event_categories=[
 *         "creation",
 *         "failure",
 *     ],
 *     name="my-favorite-event-subscription",
 *     sns_topic_arn=example_aws_sns_topic["arn"],
 *     source_ids=[example_aws_dms_replication_task["replicationTaskId"]],
 *     source_type="replication-task",
 *     tags={
 *         "Name": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Dms.EventSubscription("example", new()
 *     {
 *         Enabled = true,
 *         EventCategories = new[]
 *         {
 *             "creation",
 *             "failure",
 *         },
 *         Name = "my-favorite-event-subscription",
 *         SnsTopicArn = exampleAwsSnsTopic.Arn,
 *         SourceIds = new[]
 *         {
 *             exampleAwsDmsReplicationTask.ReplicationTaskId,
 *         },
 *         SourceType = "replication-task",
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dms.NewEventSubscription(ctx, "example", &dms.EventSubscriptionArgs{
 * 			Enabled: pulumi.Bool(true),
 * 			EventCategories: pulumi.StringArray{
 * 				pulumi.String("creation"),
 * 				pulumi.String("failure"),
 * 			},
 * 			Name:        pulumi.String("my-favorite-event-subscription"),
 * 			SnsTopicArn: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			SourceIds: pulumi.StringArray{
 * 				exampleAwsDmsReplicationTask.ReplicationTaskId,
 * 			},
 * 			SourceType: pulumi.String("replication-task"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.EventSubscription;
 * import com.pulumi.aws.dms.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSubscription("example", EventSubscriptionArgs.builder()
 *             .enabled(true)
 *             .eventCategories(
 *                 "creation",
 *                 "failure")
 *             .name("my-favorite-event-subscription")
 *             .snsTopicArn(exampleAwsSnsTopic.arn())
 *             .sourceIds(exampleAwsDmsReplicationTask.replicationTaskId())
 *             .sourceType("replication-task")
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dms:EventSubscription
 *     properties:
 *       enabled: true
 *       eventCategories:
 *         - creation
 *         - failure
 *       name: my-favorite-event-subscription
 *       snsTopicArn: ${exampleAwsSnsTopic.arn}
 *       sourceIds:
 *         - ${exampleAwsDmsReplicationTask.replicationTaskId}
 *       sourceType: replication-task
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import event subscriptions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:dms/eventSubscription:EventSubscription test my-awesome-event-subscription
 * ```
 */
public class EventSubscription internal constructor(
    override val javaResource: com.pulumi.aws.dms.EventSubscription,
) : KotlinCustomResource(javaResource, EventSubscriptionMapper) {
    /**
     * Amazon Resource Name (ARN) of the DMS Event Subscription.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether the event subscription should be enabled.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
     */
    public val eventCategories: Output<List<String>>
        get() = javaResource.eventCategories().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Name of event subscription.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * SNS topic arn to send events on.
     */
    public val snsTopicArn: Output<String>
        get() = javaResource.snsTopicArn().applyValue({ args0 -> args0 })

    /**
     * Ids of sources to listen to. If you don't specify a value, notifications are provided for all sources.
     */
    public val sourceIds: Output<List<String>>?
        get() = javaResource.sourceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Type of source for events. Valid values: `replication-instance` or `replication-task`
     */
    public val sourceType: Output<String>
        get() = javaResource.sourceType().applyValue({ args0 -> args0 })

    /**
     * Map of resource tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EventSubscriptionMapper : ResourceMapper<EventSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dms.EventSubscription::class == javaResource::class

    override fun map(javaResource: Resource): EventSubscription = EventSubscription(
        javaResource as
            com.pulumi.aws.dms.EventSubscription,
    )
}

/**
 * @see [EventSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventSubscription].
 */
public suspend fun eventSubscription(
    name: String,
    block: suspend EventSubscriptionResourceBuilder.() -> Unit,
): EventSubscription {
    val builder = EventSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventSubscription(name: String): EventSubscription {
    val builder = EventSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
